/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.exceptions;

import io.inugami.api.exceptions.DefaultErrorCode;
import io.inugami.api.exceptions.ErrorCode;
import io.inugami.api.exceptions.ErrorCodeResolver;
import io.inugami.api.exceptions.ExceptionWithErrorCode;
import io.inugami.api.exceptions.MessagesFormatter;
import io.inugami.api.exceptions.UncheckedException;
import io.inugami.api.exceptions.asserts.AssertBoolean;
import io.inugami.api.exceptions.asserts.AssertCommons;
import io.inugami.api.exceptions.asserts.AssertEmpty;
import io.inugami.api.exceptions.asserts.AssertEquals;
import io.inugami.api.exceptions.asserts.AssertFile;
import io.inugami.api.exceptions.asserts.AssertHigher;
import io.inugami.api.exceptions.asserts.AssertHigherOrEquals;
import io.inugami.api.exceptions.asserts.AssertLocalDate;
import io.inugami.api.exceptions.asserts.AssertLocalDateTime;
import io.inugami.api.exceptions.asserts.AssertLower;
import io.inugami.api.exceptions.asserts.AssertLowerOrEquals;
import io.inugami.api.exceptions.asserts.AssertModel;
import io.inugami.api.exceptions.asserts.AssertNotEquals;
import io.inugami.api.exceptions.asserts.AssertNull;
import io.inugami.api.exceptions.asserts.AssertRegex;
import io.inugami.api.functionnals.ActionWithException;
import io.inugami.api.functionnals.IsEmptyFacet;
import io.inugami.api.functionnals.VoidFunction;
import io.inugami.api.functionnals.VoidFunctionWithException;
import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Pattern;

public final class Asserts {
    public static void assertTrue(boolean expression) {
        AssertBoolean.INSTANCE.assertTrue(expression);
    }

    public static void assertTrue(String message, boolean expression) {
        AssertBoolean.INSTANCE.assertTrue(message, expression);
    }

    public static void assertTrue(ErrorCode errorCode, boolean expression) {
        AssertBoolean.INSTANCE.assertTrue(errorCode, expression);
    }

    public static void assertTrue(Supplier<String> messageProducer, boolean expression) {
        AssertBoolean.INSTANCE.assertTrue(messageProducer, expression);
    }

    public static void assertFalse(boolean expression) {
        AssertBoolean.INSTANCE.assertFalse(expression);
    }

    public static void assertFalse(String message, boolean expression) {
        AssertBoolean.INSTANCE.assertFalse(message, expression);
    }

    public static void assertFalse(Supplier<String> messageProducer, boolean expression) {
        AssertBoolean.INSTANCE.assertFalse(messageProducer, expression);
    }

    public static void assertFalse(ErrorCode errorCode, boolean expression) {
        AssertBoolean.INSTANCE.assertFalse(errorCode, expression);
    }

    public static void assertNull(String message, Object ... values) {
        AssertNull.INSTANCE.assertNull(message, values);
    }

    public static void assertNull(Supplier<String> messageProducer, Object ... values) {
        AssertNull.INSTANCE.assertNull(messageProducer, values);
    }

    public static void assertNull(ErrorCode errorCode, Object ... values) {
        AssertNull.INSTANCE.assertNull(errorCode, values);
    }

    public static void assertNotNull(Object ... objects) {
        AssertNull.INSTANCE.assertNotNull(objects);
    }

    public static void assertNotNull(String message, Object ... values) {
        AssertNull.INSTANCE.assertNotNull(message, values);
    }

    public static void assertNotNull(Supplier<String> messageProducer, Object ... values) {
        AssertNull.INSTANCE.assertNotNull(messageProducer, values);
    }

    public static void assertNotNull(ErrorCode errorCode, Object ... values) {
        AssertNull.INSTANCE.assertNotNull(errorCode, values);
    }

    public static void assertNotEmpty(String value) {
        AssertEmpty.INSTANCE.assertNotEmpty(value);
    }

    public static void assertNotEmpty(String message, String value) {
        AssertEmpty.INSTANCE.assertNotEmpty(message, value);
    }

    public static void assertNotEmpty(Supplier<String> messageProducer, String value) {
        AssertEmpty.INSTANCE.assertNotEmpty(messageProducer, value);
    }

    public static void assertNotEmpty(ErrorCode errorCode, String value) {
        AssertEmpty.INSTANCE.assertNotEmpty(errorCode, value);
    }

    public static boolean checkIsBlank(String value) {
        return AssertEmpty.INSTANCE.checkIsBlank(value);
    }

    public static void assertNotEmpty(Collection<?> value) {
        AssertEmpty.INSTANCE.assertNotEmpty(value);
    }

    public static void assertNotEmpty(Supplier<String> messageProducer, Collection<?> value) {
        AssertEmpty.INSTANCE.assertNotEmpty(messageProducer, value);
    }

    public static void assertNotEmpty(String message, Collection<?> value) {
        AssertEmpty.INSTANCE.assertNotEmpty(message, value);
    }

    public static void assertNotEmpty(ErrorCode errorCode, Collection<?> value) {
        AssertEmpty.INSTANCE.assertNotEmpty(errorCode, value);
    }

    public static void assertNotEmpty(IsEmptyFacet value) {
        AssertEmpty.INSTANCE.assertNotEmpty(value);
    }

    public static void assertNotEmpty(String message, IsEmptyFacet value) {
        AssertEmpty.INSTANCE.assertNotEmpty(message, value);
    }

    public static void assertNotEmpty(Supplier<String> messageProducer, IsEmptyFacet value) {
        AssertEmpty.INSTANCE.assertNotEmpty(messageProducer, value);
    }

    public static void assertNotEmpty(ErrorCode errorCode, IsEmptyFacet value) {
        AssertEmpty.INSTANCE.assertNotEmpty(errorCode, value);
    }

    public static void assertNotEmpty(Map<?, ?> value) {
        AssertEmpty.INSTANCE.assertNotEmpty(value);
    }

    public static void assertNotEmpty(String message, Map<?, ?> value) {
        AssertEmpty.INSTANCE.assertNotEmpty(message, value);
    }

    public static void assertNotEmpty(Supplier<String> messageProducer, Map<?, ?> value) {
        AssertEmpty.INSTANCE.assertNotEmpty(messageProducer, value);
    }

    public static void assertNotEmpty(ErrorCode errorCode, Map<?, ?> value) {
        AssertEmpty.INSTANCE.assertNotEmpty(errorCode, value);
    }

    public static void assertEmpty(String value) {
        AssertEmpty.INSTANCE.assertEmpty(value);
    }

    public static void assertEmpty(String message, String value) {
        AssertEmpty.INSTANCE.assertEmpty(message, value);
    }

    public static void assertEmpty(Supplier<String> messageProducer, String value) {
        AssertEmpty.INSTANCE.assertEmpty(messageProducer, value);
    }

    public static void assertEmpty(ErrorCode errorCode, String value) {
        AssertEmpty.INSTANCE.assertEmpty(errorCode, value);
    }

    public static void assertEmpty(Collection<?> value) {
        AssertEmpty.INSTANCE.assertEmpty(value);
    }

    public static void assertEmpty(Supplier<String> messageProducer, Collection<?> value) {
        AssertEmpty.INSTANCE.assertEmpty(messageProducer, value);
    }

    public static void assertEmpty(String message, Collection<?> value) {
        AssertEmpty.INSTANCE.assertEmpty(message, value);
    }

    public static void assertEmpty(ErrorCode errorCode, Collection<?> value) {
        AssertEmpty.INSTANCE.assertEmpty(errorCode, value);
    }

    public static void assertEmpty(Map<?, ?> value) {
        AssertEmpty.INSTANCE.assertEmpty(value);
    }

    public static void assertEmpty(String message, Map<?, ?> value) {
        AssertEmpty.INSTANCE.assertEmpty(message, value);
    }

    public static void assertEmpty(Supplier<String> messageProducer, Map<?, ?> value) {
        AssertEmpty.INSTANCE.assertEmpty(messageProducer, value);
    }

    public static void assertEmpty(ErrorCode errorCode, Map<?, ?> value) {
        AssertEmpty.INSTANCE.assertEmpty(errorCode, value);
    }

    public static void assertEmpty(IsEmptyFacet value) {
        AssertEmpty.INSTANCE.assertEmpty(value);
    }

    public static void assertEmpty(Supplier<String> messageProducer, IsEmptyFacet value) {
        AssertEmpty.INSTANCE.assertEmpty(messageProducer, value);
    }

    public static void assertEmpty(String message, IsEmptyFacet value) {
        AssertEmpty.INSTANCE.assertEmpty(message, value);
    }

    public static void assertEmpty(ErrorCode errorCode, IsEmptyFacet value) {
        AssertEmpty.INSTANCE.assertEmpty(errorCode, value);
    }

    public static void assertNullOrEmpty(String value) {
        AssertEmpty.INSTANCE.assertNullOrEmpty(value);
    }

    public static void assertNullOrEmpty(String message, String value) {
        AssertEmpty.INSTANCE.assertNullOrEmpty(message, value);
    }

    public static void assertNullOrEmpty(Supplier<String> messageProducer, String value) {
        AssertEmpty.INSTANCE.assertNullOrEmpty(messageProducer, value);
    }

    public static void assertNullOrEmpty(ErrorCode errorCode, String value) {
        AssertEmpty.INSTANCE.assertNullOrEmpty(errorCode, value);
    }

    public static void assertNullOrEmpty(Collection<?> value) {
        AssertEmpty.INSTANCE.assertNullOrEmpty(value);
    }

    public static void assertNullOrEmpty(Supplier<String> messageProducer, Collection<?> value) {
        AssertEmpty.INSTANCE.assertNullOrEmpty(messageProducer, value);
    }

    public static void assertNullOrEmpty(String message, Collection<?> value) {
        AssertEmpty.INSTANCE.assertNullOrEmpty(message, value);
    }

    public static void assertNullOrEmpty(ErrorCode errorCode, Collection<?> value) {
        AssertEmpty.INSTANCE.assertNullOrEmpty(errorCode, value);
    }

    public static void assertNullOrEmpty(Map<?, ?> value) {
        AssertEmpty.INSTANCE.assertNullOrEmpty(value);
    }

    public static void assertNullOrEmpty(String message, Map<?, ?> value) {
        AssertEmpty.INSTANCE.assertNullOrEmpty(message, value);
    }

    public static void assertNullOrEmpty(Supplier<String> messageProducer, Map<?, ?> value) {
        AssertEmpty.INSTANCE.assertNullOrEmpty(messageProducer, value);
    }

    public static void assertNullOrEmpty(ErrorCode errorCode, Map<?, ?> value) {
        AssertEmpty.INSTANCE.assertNullOrEmpty(errorCode, value);
    }

    public static void assertNullOrEmpty(IsEmptyFacet value) {
        AssertEmpty.INSTANCE.assertNullOrEmpty(value);
    }

    public static void assertNullOrEmpty(Supplier<String> messageProducer, IsEmptyFacet value) {
        AssertEmpty.INSTANCE.assertNullOrEmpty(messageProducer, value);
    }

    public static void assertNullOrEmpty(String message, IsEmptyFacet value) {
        AssertEmpty.INSTANCE.assertNullOrEmpty(message, value);
    }

    public static void assertNullOrEmpty(ErrorCode errorCode, IsEmptyFacet value) {
        AssertEmpty.INSTANCE.assertNullOrEmpty(errorCode, value);
    }

    public static void assertEquals(Object ref, Object value) {
        AssertEquals.INSTANCE.assertEquals(ref, value);
    }

    public static void assertEquals(String message, Object ref, Object value) {
        AssertEquals.INSTANCE.assertEquals(message, ref, value);
    }

    public static void assertEquals(Supplier<String> messageProducer, Object ref, Object value) {
        AssertEquals.INSTANCE.assertEquals(messageProducer, ref, value);
    }

    public static void assertEquals(ErrorCode errorCode, Object ref, Object value) {
        AssertEquals.INSTANCE.assertEquals(errorCode, ref, value);
    }

    public static void assertEquals(int ref, int value) {
        AssertEquals.INSTANCE.assertEquals(ref, value);
    }

    public static void assertEquals(String message, int ref, int value) {
        AssertEquals.INSTANCE.assertEquals(message, ref, value);
    }

    public static void assertEquals(Supplier<String> messageProducer, int ref, int value) {
        AssertEquals.INSTANCE.assertEquals(messageProducer, ref, value);
    }

    public static void assertEquals(ErrorCode errorCode, int ref, int value) {
        AssertEquals.INSTANCE.assertEquals(errorCode, ref, value);
    }

    public static void assertEquals(long ref, long value) {
        AssertEquals.INSTANCE.assertEquals(ref, value);
    }

    public static void assertEquals(String message, long ref, long value) {
        AssertEquals.INSTANCE.assertEquals(message, ref, value);
    }

    public static void assertEquals(Supplier<String> messageProducer, long ref, long value) {
        AssertEquals.INSTANCE.assertEquals(messageProducer, ref, value);
    }

    public static void assertEquals(ErrorCode errorCode, long ref, long value) {
        AssertEquals.INSTANCE.assertEquals(errorCode, ref, value);
    }

    public static void assertEquals(float ref, float value) {
        AssertEquals.INSTANCE.assertEquals(ref, value);
    }

    public static void assertEquals(String message, float ref, float value) {
        AssertEquals.INSTANCE.assertEquals(message, ref, value);
    }

    public static void assertEquals(Supplier<String> messageProducer, float ref, float value) {
        AssertEquals.INSTANCE.assertEquals(messageProducer, ref, value);
    }

    public static void assertEquals(ErrorCode errorCode, float ref, float value) {
        AssertEquals.INSTANCE.assertEquals(errorCode, ref, value);
    }

    public static void assertEquals(double ref, double value) {
        AssertEquals.INSTANCE.assertEquals(ref, value);
    }

    public static void assertEquals(String message, double ref, double value) {
        AssertEquals.INSTANCE.assertEquals(message, ref, value);
    }

    public static void assertEquals(Supplier<String> messageProducer, double ref, double value) {
        AssertEquals.INSTANCE.assertEquals(messageProducer, ref, value);
    }

    public static void assertEquals(ErrorCode errorCode, double ref, double value) {
        AssertEquals.INSTANCE.assertEquals(errorCode, ref, value);
    }

    public static void assertNotEquals(Object ref, Object value) {
        AssertNotEquals.INSTANCE.assertNotEquals(ref, value);
    }

    public static void assertNotEquals(String message, Object ref, Object value) {
        AssertNotEquals.INSTANCE.assertNotEquals(message, ref, value);
    }

    public static void assertNotEquals(Supplier<String> messageProducer, Object ref, Object value) {
        AssertNotEquals.INSTANCE.assertNotEquals(messageProducer, ref, value);
    }

    public static void assertNotEquals(ErrorCode errorCode, Object ref, Object value) {
        AssertNotEquals.INSTANCE.assertNotEquals(errorCode, ref, value);
    }

    public static void assertNotEquals(int ref, int value) {
        AssertNotEquals.INSTANCE.assertNotEquals(ref, value);
    }

    public static void assertNotEquals(String message, int ref, int value) {
        AssertNotEquals.INSTANCE.assertNotEquals(message, ref, value);
    }

    public static void assertNotEquals(Supplier<String> messageProducer, int ref, int value) {
        AssertNotEquals.INSTANCE.assertNotEquals(messageProducer, ref, value);
    }

    public static void assertNotEquals(ErrorCode errorCode, int ref, int value) {
        AssertNotEquals.INSTANCE.assertNotEquals(errorCode, ref, value);
    }

    public static void assertNotEquals(long ref, long value) {
        AssertNotEquals.INSTANCE.assertNotEquals(ref, value);
    }

    public static void assertNotEquals(String message, long ref, long value) {
        AssertNotEquals.INSTANCE.assertNotEquals(message, ref, value);
    }

    public static void assertNotEquals(Supplier<String> messageProducer, long ref, long value) {
        AssertNotEquals.INSTANCE.assertNotEquals(messageProducer, ref, value);
    }

    public static void assertNotEquals(ErrorCode errorCode, long ref, long value) {
        AssertNotEquals.INSTANCE.assertNotEquals(errorCode, ref, value);
    }

    public static void assertNotEquals(float ref, float value) {
        AssertNotEquals.INSTANCE.assertNotEquals(ref, value);
    }

    public static void assertNotEquals(String message, float ref, float value) {
        AssertNotEquals.INSTANCE.assertNotEquals(message, ref, value);
    }

    public static void assertNotEquals(Supplier<String> messageProducer, float ref, float value) {
        AssertNotEquals.INSTANCE.assertNotEquals(messageProducer, ref, value);
    }

    public static void assertNotEquals(ErrorCode errorCode, float ref, float value) {
        AssertNotEquals.INSTANCE.assertNotEquals(errorCode, ref, value);
    }

    public static void assertNotEquals(double ref, double value) {
        AssertNotEquals.INSTANCE.assertNotEquals(ref, value);
    }

    public static void assertNotEquals(String message, double ref, double value) {
        AssertNotEquals.INSTANCE.assertNotEquals(message, ref, value);
    }

    public static void assertNotEquals(Supplier<String> messageProducer, double ref, double value) {
        AssertNotEquals.INSTANCE.assertNotEquals(messageProducer, ref, value);
    }

    public static void assertNotEquals(ErrorCode errorCode, double ref, double value) {
        AssertNotEquals.INSTANCE.assertNotEquals(errorCode, ref, value);
    }

    public static void assertLower(int ref, int value) {
        AssertLower.INSTANCE.assertLower(ref, value);
    }

    public static void assertLower(String message, int ref, int value) {
        AssertLower.INSTANCE.assertLower(message, ref, value);
    }

    public static void assertLower(Supplier<String> messageProducer, int ref, int value) {
        AssertLower.INSTANCE.assertLower(messageProducer, ref, value);
    }

    public static void assertLower(ErrorCode errorCode, int ref, int value) {
        AssertLower.INSTANCE.assertLower(errorCode, ref, value);
    }

    public static void assertLower(long ref, long value) {
        AssertLower.INSTANCE.assertLower(ref, value);
    }

    public static void assertLower(String message, long ref, long value) {
        AssertLower.INSTANCE.assertLower(message, ref, value);
    }

    public static void assertLower(Supplier<String> messageProducer, long ref, long value) {
        AssertLower.INSTANCE.assertLower(messageProducer, ref, value);
    }

    public static void assertLower(ErrorCode errorCode, long ref, long value) {
        AssertLower.INSTANCE.assertLower(errorCode, ref, value);
    }

    public static void assertLower(float ref, float value) {
        AssertLower.INSTANCE.assertLower(ref, value);
    }

    public static void assertLower(String message, float ref, float value) {
        AssertLower.INSTANCE.assertLower(message, ref, value);
    }

    public static void assertLower(Supplier<String> messageProducer, float ref, float value) {
        AssertLower.INSTANCE.assertLower(messageProducer, ref, value);
    }

    public static void assertLower(ErrorCode errorCode, float ref, float value) {
        AssertLower.INSTANCE.assertLower(errorCode, ref, value);
    }

    public static void assertLower(double ref, double value) {
        AssertLower.INSTANCE.assertLower(ref, value);
    }

    public static void assertLower(String message, double ref, double value) {
        AssertLower.INSTANCE.assertLower(message, ref, value);
    }

    public static void assertLower(Supplier<String> messageProducer, double ref, double value) {
        AssertLower.INSTANCE.assertLower(messageProducer, ref, value);
    }

    public static void assertLower(ErrorCode errorCode, double ref, double value) {
        AssertLower.INSTANCE.assertLower(errorCode, ref, value);
    }

    public static void assertLower(Integer ref, Integer value) {
        AssertLower.INSTANCE.assertLower(ref, value);
    }

    public static void assertLower(String message, Integer ref, Integer value) {
        AssertLower.INSTANCE.assertLower(message, ref, value);
    }

    public static void assertLower(Supplier<String> messageProducer, Integer ref, Integer value) {
        AssertLower.INSTANCE.assertLower(messageProducer, ref, value);
    }

    public static void assertLower(ErrorCode errorCode, Integer ref, Integer value) {
        AssertLower.INSTANCE.assertLower(errorCode, ref, value);
    }

    public static void assertLower(Long ref, Long value) {
        AssertLower.INSTANCE.assertLower(ref, value);
    }

    public static void assertLower(String message, Long ref, Long value) {
        AssertLower.INSTANCE.assertLower(message, ref, value);
    }

    public static void assertLower(Supplier<String> messageProducer, Long ref, Long value) {
        AssertLower.INSTANCE.assertLower(messageProducer, ref, value);
    }

    public static void assertLower(ErrorCode errorCode, Long ref, Long value) {
        AssertLower.INSTANCE.assertLower(errorCode, ref, value);
    }

    public static void assertLower(Double ref, Double value) {
        AssertLower.INSTANCE.assertLower(ref, value);
    }

    public static void assertLower(String message, Double ref, Double value) {
        AssertLower.INSTANCE.assertLower(message, ref, value);
    }

    public static void assertLower(Supplier<String> messageProducer, Double ref, Double value) {
        AssertLower.INSTANCE.assertLower(messageProducer, ref, value);
    }

    public static void assertLower(ErrorCode errorCode, Double ref, Double value) {
        AssertLower.INSTANCE.assertLower(errorCode, ref, value);
    }

    public static void assertLower(BigDecimal ref, BigDecimal value) {
        AssertLower.INSTANCE.assertLower(ref, value);
    }

    public static void assertLower(String message, BigDecimal ref, BigDecimal value) {
        AssertLower.INSTANCE.assertLower(message, ref, value);
    }

    public static void assertLower(Supplier<String> messageProducer, BigDecimal ref, BigDecimal value) {
        AssertLower.INSTANCE.assertLower(messageProducer, ref, value);
    }

    public static void assertLower(ErrorCode errorCode, BigDecimal ref, BigDecimal value) {
        AssertLower.INSTANCE.assertLower(errorCode, ref, value);
    }

    public static void assertLowerOrEquals(int ref, int value) {
        AssertLowerOrEquals.INSTANCE.assertLowerOrEquals(ref, value);
    }

    public static void assertLowerOrEquals(String message, int ref, int value) {
        AssertLowerOrEquals.INSTANCE.assertLowerOrEquals(message, ref, value);
    }

    public static void assertLowerOrEquals(Supplier<String> messageProducer, int ref, int value) {
        AssertLowerOrEquals.INSTANCE.assertLowerOrEquals(messageProducer, ref, value);
    }

    public static void assertLowerOrEquals(ErrorCode errorCode, int ref, int value) {
        AssertLowerOrEquals.INSTANCE.assertLowerOrEquals(errorCode, ref, value);
    }

    public static void assertLowerOrEquals(long ref, long value) {
        AssertLowerOrEquals.INSTANCE.assertLowerOrEquals(ref, value);
    }

    public static void assertLowerOrEquals(String message, long ref, long value) {
        AssertLowerOrEquals.INSTANCE.assertLowerOrEquals(message, ref, value);
    }

    public static void assertLowerOrEquals(Supplier<String> messageProducer, long ref, long value) {
        AssertLowerOrEquals.INSTANCE.assertLowerOrEquals(messageProducer, ref, value);
    }

    public static void assertLowerOrEquals(ErrorCode errorCode, long ref, long value) {
        AssertLowerOrEquals.INSTANCE.assertLowerOrEquals(errorCode, ref, value);
    }

    public static void assertLowerOrEquals(float ref, float value) {
        AssertLowerOrEquals.INSTANCE.assertLowerOrEquals(ref, value);
    }

    public static void assertLowerOrEquals(String message, float ref, float value) {
        AssertLowerOrEquals.INSTANCE.assertLowerOrEquals(message, ref, value);
    }

    public static void assertLowerOrEquals(Supplier<String> messageProducer, float ref, float value) {
        AssertLowerOrEquals.INSTANCE.assertLowerOrEquals(messageProducer, ref, value);
    }

    public static void assertLowerOrEquals(ErrorCode errorCode, float ref, float value) {
        AssertLowerOrEquals.INSTANCE.assertLowerOrEquals(errorCode, ref, value);
    }

    public static void assertLowerOrEquals(double ref, double value) {
        AssertLowerOrEquals.INSTANCE.assertLowerOrEquals(ref, value);
    }

    public static void assertLowerOrEquals(String message, double ref, double value) {
        AssertLowerOrEquals.INSTANCE.assertLowerOrEquals(message, ref, value);
    }

    public static void assertLowerOrEquals(Supplier<String> messageProducer, double ref, double value) {
        AssertLowerOrEquals.INSTANCE.assertLowerOrEquals(messageProducer, ref, value);
    }

    public static void assertLowerOrEquals(ErrorCode errorCode, double ref, double value) {
        AssertLowerOrEquals.INSTANCE.assertLowerOrEquals(errorCode, ref, value);
    }

    public static void assertLowerOrEquals(Integer ref, Integer value) {
        AssertLowerOrEquals.INSTANCE.assertLowerOrEquals(ref, value);
    }

    public static void assertLowerOrEquals(String message, Integer ref, Integer value) {
        AssertLowerOrEquals.INSTANCE.assertLowerOrEquals(message, ref, value);
    }

    public static void assertLowerOrEquals(Supplier<String> messageProducer, Integer ref, Integer value) {
        AssertLowerOrEquals.INSTANCE.assertLowerOrEquals(messageProducer, ref, value);
    }

    public static void assertLowerOrEquals(ErrorCode errorCode, Integer ref, Integer value) {
        AssertLowerOrEquals.INSTANCE.assertLowerOrEquals(errorCode, ref, value);
    }

    public static void assertLowerOrEquals(Long ref, Long value) {
        AssertLowerOrEquals.INSTANCE.assertLowerOrEquals(ref, value);
    }

    public static void assertLowerOrEquals(String message, Long ref, Long value) {
        AssertLowerOrEquals.INSTANCE.assertLowerOrEquals(message, ref, value);
    }

    public static void assertLowerOrEquals(Supplier<String> messageProducer, Long ref, Long value) {
        AssertLowerOrEquals.INSTANCE.assertLowerOrEquals(messageProducer, ref, value);
    }

    public static void assertLowerOrEquals(ErrorCode errorCode, Long ref, Long value) {
        AssertLowerOrEquals.INSTANCE.assertLowerOrEquals(errorCode, ref, value);
    }

    public static void assertLowerOrEquals(Double ref, Double value) {
        AssertLowerOrEquals.INSTANCE.assertLowerOrEquals(ref, value);
    }

    public static void assertLowerOrEquals(String message, Double ref, Double value) {
        AssertLowerOrEquals.INSTANCE.assertLowerOrEquals(message, ref, value);
    }

    public static void assertLowerOrEquals(Supplier<String> messageProducer, Double ref, Double value) {
        AssertLowerOrEquals.INSTANCE.assertLowerOrEquals(messageProducer, ref, value);
    }

    public static void assertLowerOrEquals(ErrorCode errorCode, Double ref, Double value) {
        AssertLowerOrEquals.INSTANCE.assertLowerOrEquals(errorCode, ref, value);
    }

    public static void assertLowerOrEquals(BigDecimal ref, BigDecimal value) {
        AssertLowerOrEquals.INSTANCE.assertLowerOrEquals(ref, value);
    }

    public static void assertLowerOrEquals(String message, BigDecimal ref, BigDecimal value) {
        AssertLowerOrEquals.INSTANCE.assertLowerOrEquals(message, ref, value);
    }

    public static void assertLowerOrEquals(Supplier<String> messageProducer, BigDecimal ref, BigDecimal value) {
        AssertLowerOrEquals.INSTANCE.assertLowerOrEquals(messageProducer, ref, value);
    }

    public static void assertLowerOrEquals(ErrorCode errorCode, BigDecimal ref, BigDecimal value) {
        AssertLowerOrEquals.INSTANCE.assertLowerOrEquals(errorCode, ref, value);
    }

    public static void assertHigher(int ref, int value) {
        AssertHigher.INSTANCE.assertHigher(ref, value);
    }

    public static void assertHigher(String message, int ref, int value) {
        AssertHigher.INSTANCE.assertHigher(message, ref, value);
    }

    public static void assertHigher(Supplier<String> messageProducer, int ref, int value) {
        AssertHigher.INSTANCE.assertHigher(messageProducer, ref, value);
    }

    public static void assertHigher(ErrorCode errorCode, int ref, int value) {
        AssertHigher.INSTANCE.assertHigher(errorCode, ref, value);
    }

    public static void assertHigher(long ref, long value) {
        AssertHigher.INSTANCE.assertHigher(ref, value);
    }

    public static void assertHigher(String message, long ref, long value) {
        AssertHigher.INSTANCE.assertHigher(message, ref, value);
    }

    public static void assertHigher(Supplier<String> messageProducer, long ref, long value) {
        AssertHigher.INSTANCE.assertHigher(messageProducer, ref, value);
    }

    public static void assertHigher(ErrorCode errorCode, long ref, long value) {
        AssertHigher.INSTANCE.assertHigher(errorCode, ref, value);
    }

    public static void assertHigher(float ref, float value) {
        AssertHigher.INSTANCE.assertHigher(ref, value);
    }

    public static void assertHigher(String message, float ref, float value) {
        AssertHigher.INSTANCE.assertHigher(message, ref, value);
    }

    public static void assertHigher(Supplier<String> messageProducer, float ref, float value) {
        AssertHigher.INSTANCE.assertHigher(messageProducer, ref, value);
    }

    public static void assertHigher(ErrorCode errorCode, float ref, float value) {
        AssertHigher.INSTANCE.assertHigher(errorCode, ref, value);
    }

    public static void assertHigher(double ref, double value) {
        AssertHigher.INSTANCE.assertHigher(ref, value);
    }

    public static void assertHigher(String message, double ref, double value) {
        AssertHigher.INSTANCE.assertHigher(message, ref, value);
    }

    public static void assertHigher(Supplier<String> messageProducer, double ref, double value) {
        AssertHigher.INSTANCE.assertHigher(messageProducer, ref, value);
    }

    public static void assertHigher(ErrorCode errorCode, double ref, double value) {
        AssertHigher.INSTANCE.assertHigher(errorCode, ref, value);
    }

    public static void assertHigher(Integer ref, Integer value) {
        AssertHigher.INSTANCE.assertHigher(ref, value);
    }

    public static void assertHigher(String message, Integer ref, Integer value) {
        AssertHigher.INSTANCE.assertHigher(message, ref, value);
    }

    public static void assertHigher(Supplier<String> messageProducer, Integer ref, Integer value) {
        AssertHigher.INSTANCE.assertHigher(messageProducer, ref, value);
    }

    public static void assertHigher(ErrorCode errorCode, Integer ref, Integer value) {
        AssertHigher.INSTANCE.assertHigher(errorCode, ref, value);
    }

    public static void assertHigher(Long ref, Long value) {
        AssertHigher.INSTANCE.assertHigher(ref, value);
    }

    public static void assertHigher(String message, Long ref, Long value) {
        AssertHigher.INSTANCE.assertHigher(message, ref, value);
    }

    public static void assertHigher(Supplier<String> messageProducer, Long ref, Long value) {
        AssertHigher.INSTANCE.assertHigher(messageProducer, ref, value);
    }

    public static void assertHigher(ErrorCode errorCode, Long ref, Long value) {
        AssertHigher.INSTANCE.assertHigher(errorCode, ref, value);
    }

    public static void assertHigher(Double ref, Double value) {
        AssertHigher.INSTANCE.assertHigher(ref, value);
    }

    public static void assertHigher(String message, Double ref, Double value) {
        AssertHigher.INSTANCE.assertHigher(message, ref, value);
    }

    public static void assertHigher(Supplier<String> messageProducer, Double ref, Double value) {
        AssertHigher.INSTANCE.assertHigher(messageProducer, ref, value);
    }

    public static void assertHigher(ErrorCode errorCode, Double ref, Double value) {
        AssertHigher.INSTANCE.assertHigher(errorCode, ref, value);
    }

    public static void assertHigher(BigDecimal ref, BigDecimal value) {
        AssertHigher.INSTANCE.assertHigher(ref, value);
    }

    public static void assertHigher(String message, BigDecimal ref, BigDecimal value) {
        AssertHigher.INSTANCE.assertHigher(message, ref, value);
    }

    public static void assertHigher(Supplier<String> messageProducer, BigDecimal ref, BigDecimal value) {
        AssertHigher.INSTANCE.assertHigher(messageProducer, ref, value);
    }

    public static void assertHigher(ErrorCode errorCode, BigDecimal ref, BigDecimal value) {
        AssertHigher.INSTANCE.assertHigher(errorCode, ref, value);
    }

    public static void assertHigherOrEquals(int ref, int value) {
        AssertHigherOrEquals.INSTANCE.assertHigherOrEquals(ref, value);
    }

    public static void assertHigherOrEquals(String message, int ref, int value) {
        AssertHigherOrEquals.INSTANCE.assertHigherOrEquals(message, ref, value);
    }

    public static void assertHigherOrEquals(Supplier<String> messageProducer, int ref, int value) {
        AssertHigherOrEquals.INSTANCE.assertHigherOrEquals(messageProducer, ref, value);
    }

    public static void assertHigherOrEquals(ErrorCode errorCode, int ref, int value) {
        AssertHigherOrEquals.INSTANCE.assertHigherOrEquals(errorCode, ref, value);
    }

    public static void assertHigherOrEquals(long ref, long value) {
        AssertHigherOrEquals.INSTANCE.assertHigherOrEquals(ref, value);
    }

    public static void assertHigherOrEquals(String message, long ref, long value) {
        AssertHigherOrEquals.INSTANCE.assertHigherOrEquals(message, ref, value);
    }

    public static void assertHigherOrEquals(Supplier<String> messageProducer, long ref, long value) {
        AssertHigherOrEquals.INSTANCE.assertHigherOrEquals(messageProducer, ref, value);
    }

    public static void assertHigherOrEquals(ErrorCode errorCode, long ref, long value) {
        AssertHigherOrEquals.INSTANCE.assertHigherOrEquals(errorCode, ref, value);
    }

    public static void assertHigherOrEquals(float ref, float value) {
        AssertHigherOrEquals.INSTANCE.assertHigherOrEquals(ref, value);
    }

    public static void assertHigherOrEquals(String message, float ref, float value) {
        AssertHigherOrEquals.INSTANCE.assertHigherOrEquals(message, ref, value);
    }

    public static void assertHigherOrEquals(Supplier<String> messageProducer, float ref, float value) {
        AssertHigherOrEquals.INSTANCE.assertHigherOrEquals(messageProducer, ref, value);
    }

    public static void assertHigherOrEquals(ErrorCode errorCode, float ref, float value) {
        AssertHigherOrEquals.INSTANCE.assertHigherOrEquals(errorCode, ref, value);
    }

    public static void assertHigherOrEquals(double ref, double value) {
        AssertHigherOrEquals.INSTANCE.assertHigherOrEquals(ref, value);
    }

    public static void assertHigherOrEquals(String message, double ref, double value) {
        AssertHigherOrEquals.INSTANCE.assertHigherOrEquals(message, ref, value);
    }

    public static void assertHigherOrEquals(Supplier<String> messageProducer, double ref, double value) {
        AssertHigherOrEquals.INSTANCE.assertHigherOrEquals(messageProducer, ref, value);
    }

    public static void assertHigherOrEquals(ErrorCode errorCode, double ref, double value) {
        AssertHigherOrEquals.INSTANCE.assertHigherOrEquals(errorCode, ref, value);
    }

    public static void assertHigherOrEquals(Integer ref, Integer value) {
        AssertHigherOrEquals.INSTANCE.assertHigherOrEquals(ref, value);
    }

    public static void assertHigherOrEquals(Supplier<String> messageProducer, Integer ref, Integer value) {
        AssertHigherOrEquals.INSTANCE.assertHigherOrEquals(messageProducer, ref, value);
    }

    public static void assertHigherOrEquals(String message, Integer ref, Integer value) {
        AssertHigherOrEquals.INSTANCE.assertHigherOrEquals(message, ref, value);
    }

    public static void assertHigherOrEquals(ErrorCode errorCode, Integer ref, Integer value) {
        AssertHigherOrEquals.INSTANCE.assertHigherOrEquals(errorCode, ref, value);
    }

    public static void assertHigherOrEquals(Long ref, Long value) {
        AssertHigherOrEquals.INSTANCE.assertHigherOrEquals(ref, value);
    }

    public static void assertHigherOrEquals(String message, Long ref, Long value) {
        AssertHigherOrEquals.INSTANCE.assertHigherOrEquals(message, ref, value);
    }

    public static void assertHigherOrEquals(Supplier<String> messageProducer, Long ref, Long value) {
        AssertHigherOrEquals.INSTANCE.assertHigherOrEquals(messageProducer, ref, value);
    }

    public static void assertHigherOrEquals(ErrorCode errorCode, Long ref, Long value) {
        AssertHigherOrEquals.INSTANCE.assertHigherOrEquals(errorCode, ref, value);
    }

    public static void assertHigherOrEquals(Double ref, Double value) {
        AssertHigherOrEquals.INSTANCE.assertHigherOrEquals(ref, value);
    }

    public static void assertHigherOrEquals(String message, Double ref, Double value) {
        AssertHigherOrEquals.INSTANCE.assertHigherOrEquals(message, ref, value);
    }

    public static void assertHigherOrEquals(Supplier<String> messageProducer, Double ref, Double value) {
        AssertHigherOrEquals.INSTANCE.assertHigherOrEquals(messageProducer, ref, value);
    }

    public static void assertHigherOrEquals(ErrorCode errorCode, Double ref, Double value) {
        AssertHigherOrEquals.INSTANCE.assertHigherOrEquals(errorCode, ref, value);
    }

    public static void assertHigherOrEquals(BigDecimal ref, BigDecimal value) {
        AssertHigherOrEquals.INSTANCE.assertHigherOrEquals(ref, value);
    }

    public static void assertHigherOrEquals(String message, BigDecimal ref, BigDecimal value) {
        AssertHigherOrEquals.INSTANCE.assertHigherOrEquals(message, ref, value);
    }

    public static void assertHigherOrEquals(Supplier<String> messageProducer, BigDecimal ref, BigDecimal value) {
        AssertHigherOrEquals.INSTANCE.assertHigherOrEquals(messageProducer, ref, value);
    }

    public static void assertHigherOrEquals(ErrorCode errorCode, BigDecimal ref, BigDecimal value) {
        AssertHigherOrEquals.INSTANCE.assertHigherOrEquals(errorCode, ref, value);
    }

    public static void assertRegexMatch(Pattern regex, String value) {
        AssertRegex.INSTANCE.assertRegexMatch(regex, value);
    }

    public static void assertRegexMatch(String message, Pattern regex, String value) {
        AssertRegex.INSTANCE.assertRegexMatch(message, regex, value);
    }

    public static void assertRegexMatch(Supplier<String> messageProducer, Pattern regex, String value) {
        AssertRegex.INSTANCE.assertRegexMatch(messageProducer, regex, value);
    }

    public static void assertRegexMatch(ErrorCode errorCode, Pattern regex, String value) {
        AssertRegex.INSTANCE.assertRegexMatch(errorCode, regex, value);
    }

    public static void assertRegexMatch(String regex, String value) {
        AssertRegex.INSTANCE.assertRegexMatch(regex, value);
    }

    public static void assertRegexMatch(String message, String regex, String value) {
        AssertRegex.INSTANCE.assertRegexMatch(message, regex, value);
    }

    public static void assertRegexMatch(Supplier<String> messageProducer, String regex, String value) {
        AssertRegex.INSTANCE.assertRegexMatch(messageProducer, regex, value);
    }

    public static void assertRegexMatch(ErrorCode errorCode, String regex, String value) {
        AssertRegex.INSTANCE.assertRegexMatch(errorCode, regex, value);
    }

    public static void assertRegexNotMatch(Pattern regex, String value) {
        AssertRegex.INSTANCE.assertRegexNotMatch(regex, value);
    }

    public static void assertRegexNotMatch(String message, Pattern regex, String value) {
        AssertRegex.INSTANCE.assertRegexNotMatch(message, regex, value);
    }

    public static void assertRegexNotMatch(Supplier<String> messageProducer, Pattern regex, String value) {
        AssertRegex.INSTANCE.assertRegexNotMatch(messageProducer, regex, value);
    }

    public static void assertRegexNotMatch(ErrorCode errorCode, Pattern regex, String value) {
        AssertRegex.INSTANCE.assertRegexNotMatch(errorCode, regex, value);
    }

    public static void assertRegexNotMatch(String regex, String value) {
        AssertRegex.INSTANCE.assertRegexNotMatch(regex, value);
    }

    public static void assertRegexNotMatch(String message, String regex, String value) {
        AssertRegex.INSTANCE.assertRegexNotMatch(message, regex, value);
    }

    public static void assertRegexNotMatch(Supplier<String> messageProducer, String regex, String value) {
        AssertRegex.INSTANCE.assertRegexNotMatch(messageProducer, regex, value);
    }

    public static void assertRegexNotMatch(ErrorCode errorCode, String regex, String value) {
        AssertRegex.INSTANCE.assertRegexNotMatch(errorCode, regex, value);
    }

    public static void assertRegexFind(Pattern regex, String value) {
        AssertRegex.INSTANCE.assertRegexFind(regex, value);
    }

    public static void assertRegexFind(String message, Pattern regex, String value) {
        AssertRegex.INSTANCE.assertRegexFind(message, regex, value);
    }

    public static void assertRegexFind(Supplier<String> messageProducer, Pattern regex, String value) {
        AssertRegex.INSTANCE.assertRegexFind(messageProducer, regex, value);
    }

    public static void assertRegexFind(ErrorCode errorCode, Pattern regex, String value) {
        AssertRegex.INSTANCE.assertRegexFind(errorCode, regex, value);
    }

    public static void assertRegexFind(String regex, String value) {
        AssertRegex.INSTANCE.assertRegexFind(regex, value);
    }

    public static void assertRegexFind(String message, String regex, String value) {
        AssertRegex.INSTANCE.assertRegexFind(message, regex, value);
    }

    public static void assertRegexFind(Supplier<String> messageProducer, String regex, String value) {
        AssertRegex.INSTANCE.assertRegexFind(messageProducer, regex, value);
    }

    public static void assertRegexFind(ErrorCode errorCode, String regex, String value) {
        AssertRegex.INSTANCE.assertRegexFind(errorCode, regex, value);
    }

    public static void assertRegexNotFind(Pattern regex, String value) {
        AssertRegex.INSTANCE.assertRegexNotFind(regex, value);
    }

    public static void assertRegexNotFind(String message, Pattern regex, String value) {
        AssertRegex.INSTANCE.assertRegexNotFind(message, regex, value);
    }

    public static void assertRegexNotFind(Supplier<String> messageProducer, Pattern regex, String value) {
        AssertRegex.INSTANCE.assertRegexNotFind(messageProducer, regex, value);
    }

    public static void assertRegexNotFind(ErrorCode errorCode, Pattern regex, String value) {
        AssertRegex.INSTANCE.assertRegexNotFind(errorCode, regex, value);
    }

    public static void assertRegexNotFind(String regex, String value) {
        AssertRegex.INSTANCE.assertRegexNotFind(regex, value);
    }

    public static void assertRegexNotFind(String message, String regex, String value) {
        AssertRegex.INSTANCE.assertRegexNotFind(message, regex, value);
    }

    public static void assertRegexNotFind(Supplier<String> messageProducer, String regex, String value) {
        AssertRegex.INSTANCE.assertRegexNotFind(messageProducer, regex, value);
    }

    public static void assertRegexNotFind(ErrorCode errorCode, String regex, String value) {
        AssertRegex.INSTANCE.assertRegexNotFind(errorCode, regex, value);
    }

    public static List<ErrorCode> checkModel(VoidFunctionWithException ... assertions) {
        return AssertModel.INSTANCE.checkModel(assertions);
    }

    public static List<ErrorCode> checkModel(List<VoidFunctionWithException> assertions) {
        return AssertModel.INSTANCE.checkModel(assertions);
    }

    public static void assertModel(VoidFunctionWithException ... assertions) {
        AssertModel.INSTANCE.assertModel(assertions);
    }

    public static void assertModel(List<VoidFunctionWithException> assertions) {
        AssertModel.INSTANCE.assertModel(assertions);
    }

    public static void assertThrow(String message, VoidFunctionWithException function) {
        try {
            function.process();
            Asserts.throwException(message);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void assertFileExists(File path) {
        AssertFile.INSTANCE.assertFileExists(path);
    }

    public static void assertFileExists(String message, File path) {
        AssertFile.INSTANCE.assertFileExists(message, path);
    }

    public static void assertFileExists(ErrorCode errorCode, File path) {
        AssertFile.INSTANCE.assertFileExists(errorCode, path);
    }

    public static void assertFileReadable(File path) {
        AssertFile.INSTANCE.assertFileReadable(path);
    }

    public static void assertFileReadable(String message, File path) {
        AssertFile.INSTANCE.assertFileReadable(message, path);
    }

    public static void assertFileReadable(ErrorCode errorCode, File path) {
        AssertFile.INSTANCE.assertFileReadable(errorCode, path);
    }

    public static void assertFileWrite(File path) {
        AssertFile.INSTANCE.assertFileWrite(path);
    }

    public static void assertFileWrite(String message, File path) {
        AssertFile.INSTANCE.assertFileWrite(message, path);
    }

    public static void assertFileWrite(ErrorCode errorCode, File path) {
        AssertFile.INSTANCE.assertFileWrite(errorCode, path);
    }

    public static void assertFileExecutable(File path) {
        AssertFile.INSTANCE.assertFileExecutable(path);
    }

    public static void assertFileExecutable(String message, File path) {
        AssertFile.INSTANCE.assertFileExecutable(message, path);
    }

    public static void assertFileExecutable(ErrorCode errorCode, File path) {
        AssertFile.INSTANCE.assertFileExecutable(errorCode, path);
    }

    public static void assertFolderExists(File path) {
        AssertFile.INSTANCE.assertFolderExists(path);
    }

    public static void assertFolderExists(String message, File path) {
        AssertFile.INSTANCE.assertFolderExists(message, path);
    }

    public static void assertFolderExists(ErrorCode errorCode, File path) {
        AssertFile.INSTANCE.assertFolderExists(errorCode, path);
    }

    public static void assertBefore(ChronoLocalDate ref, ChronoLocalDate value) {
        AssertLocalDate.INSTANCE.assertBefore(ref, value);
    }

    public static void assertBefore(String message, ChronoLocalDate ref, ChronoLocalDate value) {
        AssertLocalDate.INSTANCE.assertBefore(message, ref, value);
    }

    public static void assertBefore(Supplier<String> messageProducer, ChronoLocalDate ref, ChronoLocalDate value) {
        AssertLocalDate.INSTANCE.assertBefore(messageProducer, ref, value);
    }

    public static void assertBefore(ErrorCode errorCode, ChronoLocalDate ref, ChronoLocalDate value) {
        AssertLocalDate.INSTANCE.assertBefore(errorCode, ref, value);
    }

    public static void assertAfter(ChronoLocalDate ref, ChronoLocalDate value) {
        AssertLocalDate.INSTANCE.assertAfter(ref, value);
    }

    public static void assertAfter(String message, ChronoLocalDate ref, ChronoLocalDate value) {
        AssertLocalDate.INSTANCE.assertAfter(message, ref, value);
    }

    public static void assertAfter(Supplier<String> messageProducer, ChronoLocalDate ref, ChronoLocalDate value) {
        AssertLocalDate.INSTANCE.assertAfter(messageProducer, ref, value);
    }

    public static void assertAfter(ErrorCode errorCode, ChronoLocalDate ref, ChronoLocalDate value) {
        AssertLocalDate.INSTANCE.assertAfter(errorCode, ref, value);
    }

    public static void assertEquals(ChronoLocalDate ref, ChronoLocalDate value) {
        AssertLocalDate.INSTANCE.assertEquals(ref, value);
    }

    public static void assertEquals(String message, ChronoLocalDate ref, ChronoLocalDate value) {
        AssertLocalDate.INSTANCE.assertEquals(message, ref, value);
    }

    public static void assertEquals(Supplier<String> messageProducer, ChronoLocalDate ref, ChronoLocalDate value) {
        AssertLocalDate.INSTANCE.assertEquals(messageProducer, ref, value);
    }

    public static void assertEquals(ErrorCode errorCode, ChronoLocalDate ref, ChronoLocalDate value) {
        AssertLocalDate.INSTANCE.assertEquals(errorCode, ref, value);
    }

    public static void assertBefore(ChronoLocalDateTime<LocalDate> ref, ChronoLocalDateTime<LocalDate> value) {
        AssertLocalDateTime.INSTANCE.assertBefore(ref, value);
    }

    public static void assertBefore(String message, ChronoLocalDateTime<LocalDate> ref, ChronoLocalDateTime<LocalDate> value) {
        AssertLocalDateTime.INSTANCE.assertBefore(message, ref, value);
    }

    public static void assertBefore(Supplier<String> messageProducer, ChronoLocalDateTime<LocalDate> ref, ChronoLocalDateTime<LocalDate> value) {
        AssertLocalDateTime.INSTANCE.assertBefore(messageProducer, ref, value);
    }

    public static void assertBefore(ErrorCode errorCode, ChronoLocalDateTime<LocalDate> ref, ChronoLocalDateTime<LocalDate> value) {
        AssertLocalDateTime.INSTANCE.assertBefore(errorCode, ref, value);
    }

    public static void assertAfter(ChronoLocalDateTime<LocalDate> ref, ChronoLocalDateTime<LocalDate> value) {
        AssertLocalDateTime.INSTANCE.assertAfter(ref, value);
    }

    public static void assertAfter(String message, ChronoLocalDateTime<LocalDate> ref, ChronoLocalDateTime<LocalDate> value) {
        AssertLocalDateTime.INSTANCE.assertAfter(message, ref, value);
    }

    public static void assertAfter(Supplier<String> messageProducer, ChronoLocalDateTime<LocalDate> ref, ChronoLocalDateTime<LocalDate> value) {
        AssertLocalDateTime.INSTANCE.assertAfter(messageProducer, ref, value);
    }

    public static void assertAfter(ErrorCode errorCode, ChronoLocalDateTime<LocalDate> ref, ChronoLocalDateTime<LocalDate> value) {
        AssertLocalDateTime.INSTANCE.assertAfter(errorCode, ref, value);
    }

    public static void assertEquals(ChronoLocalDateTime<LocalDate> ref, ChronoLocalDateTime<LocalDate> value) {
        AssertLocalDateTime.INSTANCE.assertEquals(ref, value);
    }

    public static void assertEquals(String message, ChronoLocalDateTime<LocalDate> ref, ChronoLocalDateTime<LocalDate> value) {
        AssertLocalDateTime.INSTANCE.assertEquals(message, ref, value);
    }

    public static void assertEquals(Supplier<String> messageProducer, ChronoLocalDateTime<LocalDate> ref, ChronoLocalDateTime<LocalDate> value) {
        AssertLocalDateTime.INSTANCE.assertEquals(messageProducer, ref, value);
    }

    public static void assertEquals(ErrorCode errorCode, ChronoLocalDateTime<LocalDate> ref, ChronoLocalDateTime<LocalDate> value) {
        AssertLocalDateTime.INSTANCE.assertEquals(errorCode, ref, value);
    }

    public static <T> T wrapErrorForSupplierWithException(ActionWithException action, ErrorCode errorCode) {
        return Asserts.wrapErrorForSupplierWithException(action, errorCode, null);
    }

    public static <T> T wrapErrorForSupplierWithException(ActionWithException action, ErrorCodeResolver resolver) {
        return Asserts.wrapErrorForSupplierWithException(action, null, resolver);
    }

    public static <T> T wrapErrorForSupplierWithException(ActionWithException action, ErrorCode errorCode, ErrorCodeResolver resolver) {
        Asserts.assertNotNull(action);
        try {
            return (T)action.process();
        }
        catch (Throwable e) {
            throw Asserts.handlerException(errorCode, resolver, e);
        }
    }

    public static <T> T wrapErrorForSupplier(Supplier<T> action, ErrorCode errorCode) {
        return Asserts.wrapErrorForSupplier(action, errorCode, null);
    }

    public static <T> T wrapErrorForSupplier(Supplier<T> action, ErrorCodeResolver resolver) {
        return Asserts.wrapErrorForSupplier(action, null, resolver);
    }

    public static <T> T wrapErrorForSupplier(Supplier<T> action, ErrorCode errorCode, ErrorCodeResolver resolver) {
        Asserts.assertNotNull(action);
        try {
            return action.get();
        }
        catch (Throwable e) {
            throw Asserts.handlerException(errorCode, resolver, e);
        }
    }

    public static void wrapErrorForVoidFunction(VoidFunction action, ErrorCode errorCode) {
        Asserts.wrapErrorForVoidFunction(action, errorCode, null);
    }

    public static void wrapErrorForVoidFunction(VoidFunction action, ErrorCodeResolver resolver) {
        Asserts.wrapErrorForVoidFunction(action, null, resolver);
    }

    public static void wrapErrorForVoidFunction(VoidFunction action, ErrorCode errorCode, ErrorCodeResolver resolver) {
        Asserts.assertNotNull(action);
        try {
            action.process();
        }
        catch (Throwable e) {
            throw Asserts.handlerException(errorCode, resolver, e);
        }
    }

    public static void wrapErrorForVoidFunctionWithException(VoidFunctionWithException action, ErrorCode errorCode) {
        Asserts.wrapErrorForVoidFunctionWithException(action, errorCode, null);
    }

    public static void wrapErrorForVoidFunctionWithException(VoidFunctionWithException action, ErrorCodeResolver resolver) {
        Asserts.wrapErrorForVoidFunctionWithException(action, null, resolver);
    }

    public static void wrapErrorForVoidFunctionWithException(VoidFunctionWithException action, ErrorCode errorCode, ErrorCodeResolver resolver) {
        Asserts.assertNotNull(action);
        try {
            action.process();
        }
        catch (Throwable e) {
            throw Asserts.handlerException(errorCode, resolver, e);
        }
    }

    private static ErrorCode resolveErrorCode(Throwable exception, ErrorCode errorCode, ErrorCodeResolver resolver) {
        if (errorCode == null) {
            if (exception instanceof ExceptionWithErrorCode) {
                return ((ExceptionWithErrorCode)exception).getErrorCode();
            }
            if (resolver != null) {
                ErrorCode error = resolver.resolve(exception);
                return error == null ? DefaultErrorCode.buildUndefineError() : error;
            }
            return DefaultErrorCode.buildUndefineError();
        }
        return errorCode;
    }

    private static UncheckedException handlerException(ErrorCode errorCode, ErrorCodeResolver resolver, Throwable e) {
        ErrorCode currentErrorCode = Asserts.resolveErrorCode(e, errorCode, resolver);
        if (currentErrorCode.getMessage() == null) {
            currentErrorCode = DefaultErrorCode.fromErrorCode((ErrorCode)currentErrorCode).message(e.getMessage()).build();
        }
        return new UncheckedException(currentErrorCode.addDetail(e.getMessage(), new Object[0]), e);
    }

    public static void throwException(String message) {
        AssertCommons.INSTANCE.throwException(null, message, new Serializable[0]);
    }

    public static void throwException(ErrorCode errorCode) {
        AssertCommons.INSTANCE.throwException(errorCode);
    }

    public static void throwException(ErrorCode errorCode, String message, Serializable ... args) {
        AssertCommons.INSTANCE.throwException(errorCode, MessagesFormatter.format((String)message, (Object[])args), new Serializable[0]);
    }

    private Asserts() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

