/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.exceptions;

import io.inugami.api.exceptions.CheckedException;
import io.inugami.api.exceptions.DefaultErrorCode;
import io.inugami.api.exceptions.ErrorCode;
import io.inugami.api.exceptions.UncheckedException;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiFunction;

public final class Checks {
    private static final BiFunction<ErrorCode, String, CheckedException> EXCEPTION_BUILDER = CheckedException::new;
    public static final String THIS_EXPRESSION_MUST_BE_TRUE = "this expression must be true";

    public static void isTrue(boolean expression) throws CheckedException {
        Checks.isTrue(THIS_EXPRESSION_MUST_BE_TRUE, expression);
    }

    public static void isTrue(String message, boolean expression) throws CheckedException {
        if (!expression) {
            Checks.throwException(message, EXCEPTION_BUILDER);
        }
    }

    public static void isTrue(ErrorCode errorCode, boolean expression) throws CheckedException {
        if (!expression) {
            Checks.throwException(errorCode, EXCEPTION_BUILDER);
        }
    }

    public static <E extends CheckedException> void isTrue(boolean expression, BiFunction<ErrorCode, String, E> errorBuilder) throws E {
        Checks.isTrue(THIS_EXPRESSION_MUST_BE_TRUE, expression, errorBuilder);
    }

    public static <E extends CheckedException> void isTrue(String message, boolean expression, BiFunction<ErrorCode, String, E> errorBuilder) throws E {
        if (!expression) {
            Checks.throwException(message, errorBuilder);
        }
    }

    public static <E extends CheckedException> void isTrue(ErrorCode errorCode, boolean expression, BiFunction<ErrorCode, String, E> errorBuilder) throws E {
        if (!expression) {
            Checks.throwException(errorCode, errorBuilder);
        }
    }

    public static void isFalse(boolean expression) throws CheckedException {
        Checks.isFalse(THIS_EXPRESSION_MUST_BE_TRUE, expression);
    }

    public static void isFalse(String message, boolean expression) throws CheckedException {
        if (expression) {
            Checks.throwException(message, EXCEPTION_BUILDER);
        }
    }

    public static void isFalse(ErrorCode errorCode, boolean expression) throws CheckedException {
        if (expression) {
            Checks.throwException(errorCode, EXCEPTION_BUILDER);
        }
    }

    public static <E extends CheckedException> void isFalse(boolean expression, BiFunction<ErrorCode, String, E> errorBuilder) throws E {
        Checks.isFalse(THIS_EXPRESSION_MUST_BE_TRUE, expression, errorBuilder);
    }

    public static <E extends CheckedException> void isFalse(String message, boolean expression, BiFunction<ErrorCode, String, E> errorBuilder) throws E {
        if (expression) {
            Checks.throwException(message, errorBuilder);
        }
    }

    public static <E extends CheckedException> void isFalse(ErrorCode errorCode, boolean expression, BiFunction<ErrorCode, String, E> errorBuilder) throws E {
        if (expression) {
            Checks.throwException(errorCode, errorBuilder);
        }
    }

    public static void isNull(Object ... objects) throws CheckedException {
        Checks.isNull("objects arguments must be null", objects);
    }

    public static void isNull(String message, Object ... values) throws CheckedException {
        for (Object item : values) {
            if (item == null) continue;
            Checks.throwException(message, EXCEPTION_BUILDER);
        }
    }

    public static void isNull(ErrorCode errorCode, Object ... values) throws CheckedException {
        for (Object item : values) {
            if (item == null) continue;
            Checks.throwException(errorCode, EXCEPTION_BUILDER);
        }
    }

    public static <E extends CheckedException> void isNull(BiFunction<ErrorCode, String, E> errorBuilder, Object ... objects) throws E {
        Checks.isNull("objects arguments must be null", errorBuilder, objects);
    }

    public static <E extends CheckedException> void isNull(String message, BiFunction<ErrorCode, String, E> errorBuilder, Object ... values) throws E {
        for (Object item : values) {
            if (item == null) continue;
            Checks.throwException(message, errorBuilder);
        }
    }

    public static <E extends CheckedException> void isNull(ErrorCode errorCode, BiFunction<ErrorCode, String, E> errorBuilder, Object ... values) throws E {
        for (Object item : values) {
            if (item == null) continue;
            Checks.throwException(errorCode, errorBuilder);
        }
    }

    public static void notNull(Object ... objects) throws CheckedException {
        Checks.notNull("this argument is required; it must not be null", objects);
    }

    public static void notNull(String message, Object ... values) throws CheckedException {
        for (Object item : values) {
            if (item != null) continue;
            Checks.throwException(message, EXCEPTION_BUILDER);
        }
    }

    public static void notNull(ErrorCode errorCode, Object ... values) throws CheckedException {
        for (Object item : values) {
            if (item != null) continue;
            Checks.throwException(errorCode, EXCEPTION_BUILDER);
        }
    }

    public static <E extends CheckedException> void notNull(BiFunction<ErrorCode, String, E> errorBuilder, Object ... objects) throws E {
        Checks.notNull("this argument is required; it must not be null", errorBuilder, objects);
    }

    public static <E extends CheckedException> void notNull(String message, BiFunction<ErrorCode, String, E> errorBuilder, Object ... values) throws E {
        for (Object item : values) {
            if (item != null) continue;
            Checks.throwException(message, errorBuilder);
        }
    }

    public static <E extends CheckedException> void notNull(ErrorCode errorCode, BiFunction<ErrorCode, String, E> errorBuilder, Object ... values) throws E {
        for (Object item : values) {
            if (item != null) continue;
            Checks.throwException(errorCode, errorBuilder);
        }
    }

    public static void notEmpty(String message, String value) throws CheckedException {
        if (Checks.checkIsBlank(value)) {
            Checks.throwException(message, EXCEPTION_BUILDER);
        }
    }

    public static void notEmpty(ErrorCode errorCode, String value) throws CheckedException {
        if (Checks.checkIsBlank(value)) {
            Checks.throwException(errorCode, EXCEPTION_BUILDER);
        }
    }

    public static <E extends CheckedException> void notEmpty(String message, String value, BiFunction<ErrorCode, String, E> errorBuilder) throws E {
        if (Checks.checkIsBlank(value)) {
            Checks.throwException(message, errorBuilder);
        }
    }

    public static <E extends CheckedException> void notEmpty(ErrorCode errorCode, String value, BiFunction<ErrorCode, String, E> errorBuilder) throws E {
        if (Checks.checkIsBlank(value)) {
            Checks.throwException(errorCode, errorBuilder);
        }
    }

    public static boolean checkIsBlank(String value) {
        boolean result;
        boolean bl = result = value == null || value.length() == 0;
        if (!result) {
            int length = value.length();
            for (int i = 0; i < length; ++i) {
                if (Character.isWhitespace(value.charAt(i))) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public static <E extends CheckedException> void notEmpty(String message, Collection<?> value, BiFunction<ErrorCode, String, E> errorBuilder) throws E {
        if (value == null || value.isEmpty()) {
            Checks.throwException(message, errorBuilder);
        }
    }

    public static <E extends CheckedException> void notEmpty(ErrorCode errorCode, Collection<?> value, BiFunction<ErrorCode, String, E> errorBuilder) throws E {
        if (value == null || value.isEmpty()) {
            Checks.throwException(errorCode, errorBuilder);
        }
    }

    public static <E extends CheckedException> void notEmpty(String message, Map<?, ?> value, BiFunction<ErrorCode, String, E> errorBuilder) throws E {
        if (value == null || value.isEmpty()) {
            Checks.throwException(message, errorBuilder);
        }
    }

    public static <E extends CheckedException> void notEmpty(ErrorCode errorCode, Map<?, ?> value, BiFunction<ErrorCode, String, E> errorBuilder) throws E {
        if (value == null || value.isEmpty()) {
            Checks.throwException(errorCode, errorBuilder);
        }
    }

    public static void notEmpty(String message, Collection<?> value) throws CheckedException {
        if (value == null || value.isEmpty()) {
            Checks.throwException(message, EXCEPTION_BUILDER);
        }
    }

    public static void notEmpty(ErrorCode errorCode, Collection<?> value) throws CheckedException {
        if (value == null || value.isEmpty()) {
            Checks.throwException(errorCode, EXCEPTION_BUILDER);
        }
    }

    public static void notEmpty(String message, Map<?, ?> value) throws CheckedException {
        if (value == null || value.isEmpty()) {
            Checks.throwException(message, EXCEPTION_BUILDER);
        }
    }

    public static void notEmpty(ErrorCode errorCode, Map<?, ?> value) throws CheckedException {
        if (value == null || value.isEmpty()) {
            Checks.throwException(errorCode, EXCEPTION_BUILDER);
        }
    }

    public static void equalsObj(Object ref, Object value) throws CheckedException {
        Checks.equalsObj(null, ref, value);
    }

    public static void equalsObj(String message, Object ref, Object value) throws CheckedException {
        boolean result;
        boolean bl = result = ref == value;
        if (!result && ref != null) {
            result = ref.equals(value);
        }
        if (!result) {
            String msg = message == null ? "objects must be equals!" : message;
            Checks.throwException(msg, EXCEPTION_BUILDER);
        }
    }

    public static <E extends CheckedException> void equalsObj(Object ref, Object value, BiFunction<ErrorCode, String, E> errorBuilder) throws E {
        Checks.equalsObj(null, ref, value, errorBuilder);
    }

    public static <E extends CheckedException> void equalsObj(String message, Object ref, Object value, BiFunction<ErrorCode, String, E> errorBuilder) throws E {
        boolean result;
        boolean bl = result = ref == value;
        if (!result && ref != null) {
            result = ref.equals(value);
        }
        if (!result) {
            String msg = message == null ? "objects must be equals!" : message;
            Checks.throwException(msg, errorBuilder);
        }
    }

    private static <E extends CheckedException> void throwException(String message, BiFunction<ErrorCode, String, E> exceptionBuilder) throws E {
        Checks.throwException(null, message, exceptionBuilder);
    }

    private static <E extends CheckedException> void throwException(ErrorCode errorCode, BiFunction<ErrorCode, String, E> exceptionBuilder) throws E {
        Checks.throwException(errorCode, null, exceptionBuilder);
    }

    private static <E extends CheckedException> void throwException(ErrorCode errorCode, String message, BiFunction<ErrorCode, String, E> exceptionBuilder) throws E {
        if (exceptionBuilder == null) {
            throw new UncheckedException(errorCode == null ? DefaultErrorCode.buildUndefineError() : errorCode, message);
        }
        throw (CheckedException)exceptionBuilder.apply(errorCode == null ? DefaultErrorCode.buildUndefineError() : errorCode, message);
    }

    private Checks() {
    }
}

