/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.exceptions.asserts;

import io.inugami.api.exceptions.ErrorCode;
import io.inugami.api.exceptions.asserts.AssertCommons;
import java.util.function.Supplier;

public final class AssertBoolean {
    private static final String ASSERT_TRUE_DEFAULT_MSG = "this expression must be true";
    private static final String ASSERT_FALSE_DEFAULT_MSG = "this expression must be false";
    public static final AssertBoolean INSTANCE = new AssertBoolean();

    public void assertTrue(boolean expression) {
        this.assertTrue(ASSERT_TRUE_DEFAULT_MSG, expression);
    }

    public void assertTrue(String message, boolean expression) {
        if (!expression) {
            AssertCommons.INSTANCE.throwException(message == null ? ASSERT_TRUE_DEFAULT_MSG : message);
        }
    }

    public void assertTrue(ErrorCode errorCode, boolean expression) {
        if (!expression) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertTrue(Supplier<String> messageProducer, boolean expression) {
        if (!expression) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? ASSERT_TRUE_DEFAULT_MSG : messageProducer.get());
        }
    }

    public void assertFalse(boolean expression) {
        this.assertFalse(ASSERT_FALSE_DEFAULT_MSG, expression);
    }

    public void assertFalse(String message, boolean expression) {
        if (expression) {
            AssertCommons.INSTANCE.throwException(message == null ? ASSERT_FALSE_DEFAULT_MSG : message);
        }
    }

    public void assertFalse(Supplier<String> messageProducer, boolean expression) {
        if (expression) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? ASSERT_FALSE_DEFAULT_MSG : messageProducer.get());
        }
    }

    public void assertFalse(ErrorCode errorCode, boolean expression) {
        if (expression) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    private AssertBoolean() {
    }
}

