/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.exceptions.asserts;

import io.inugami.api.exceptions.DefaultErrorCode;
import io.inugami.api.exceptions.ErrorCode;
import io.inugami.api.exceptions.MessagesFormatter;
import io.inugami.api.exceptions.MultiUncheckedException;
import io.inugami.api.exceptions.UncheckedException;
import java.io.Serializable;
import java.util.List;

public final class AssertCommons {
    public static final AssertCommons INSTANCE = new AssertCommons();

    public void throwException(String message) {
        throw new UncheckedException(DefaultErrorCode.buildUndefineError(), message);
    }

    public void throwException(ErrorCode errorCode) {
        throw new UncheckedException(errorCode, errorCode == null ? null : errorCode.getMessage());
    }

    public void throwException(ErrorCode errorCode, String message, Serializable ... args) {
        throw new UncheckedException(errorCode, MessagesFormatter.format((String)message, (Object[])args));
    }

    public void throwException(List<ErrorCode> errors) {
        throw new MultiUncheckedException(errors);
    }

    private AssertCommons() {
    }
}

