/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.exceptions.asserts;

import io.inugami.api.exceptions.ErrorCode;
import io.inugami.api.exceptions.asserts.AssertCommons;
import io.inugami.api.functionnals.IsEmptyFacet;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;

public final class AssertEmpty {
    private static final String ASSERT_NOT_EMPTY_DEFAULT_MSG = "the value mustn't be empty";
    private static final String ASSERT_EMPTY_DEFAULT_MSG = "the value should be empty";
    public static final AssertEmpty INSTANCE = new AssertEmpty();

    public void assertNotEmpty(String value) {
        if (this.checkIsBlank(value)) {
            AssertCommons.INSTANCE.throwException(ASSERT_NOT_EMPTY_DEFAULT_MSG);
        }
    }

    public void assertNotEmpty(String message, String value) {
        if (this.checkIsBlank(value)) {
            AssertCommons.INSTANCE.throwException(message == null ? ASSERT_NOT_EMPTY_DEFAULT_MSG : message);
        }
    }

    public void assertNotEmpty(Supplier<String> messageProducer, String value) {
        if (this.checkIsBlank(value)) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? ASSERT_NOT_EMPTY_DEFAULT_MSG : messageProducer.get());
        }
    }

    public void assertNotEmpty(ErrorCode errorCode, String value) {
        if (this.checkIsBlank(value)) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public boolean checkIsBlank(String value) {
        boolean result;
        boolean bl = result = value == null || value.length() == 0 || value.isEmpty();
        if (!result) {
            result = value.isBlank();
        }
        return result;
    }

    public void assertNotEmpty(Collection<?> value) {
        if (value == null || value.isEmpty()) {
            AssertCommons.INSTANCE.throwException(ASSERT_NOT_EMPTY_DEFAULT_MSG);
        }
    }

    public void assertNotEmpty(Supplier<String> messageProducer, Collection<?> value) {
        if (value == null || value.isEmpty()) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? ASSERT_NOT_EMPTY_DEFAULT_MSG : messageProducer.get());
        }
    }

    public void assertNotEmpty(String message, Collection<?> value) {
        if (value == null || value.isEmpty()) {
            AssertCommons.INSTANCE.throwException(message == null ? ASSERT_NOT_EMPTY_DEFAULT_MSG : message);
        }
    }

    public void assertNotEmpty(ErrorCode errorCode, Collection<?> value) {
        if (value == null || value.isEmpty()) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertNotEmpty(IsEmptyFacet value) {
        if (value == null || value.isEmpty()) {
            AssertCommons.INSTANCE.throwException(ASSERT_NOT_EMPTY_DEFAULT_MSG);
        }
    }

    public void assertNotEmpty(String message, IsEmptyFacet value) {
        if (value == null || value.isEmpty()) {
            AssertCommons.INSTANCE.throwException(message == null ? ASSERT_NOT_EMPTY_DEFAULT_MSG : message);
        }
    }

    public void assertNotEmpty(Supplier<String> messageProducer, IsEmptyFacet value) {
        if (value == null || value.isEmpty()) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? ASSERT_NOT_EMPTY_DEFAULT_MSG : messageProducer.get());
        }
    }

    public void assertNotEmpty(ErrorCode errorCode, IsEmptyFacet value) {
        if (value == null || value.isEmpty()) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertNotEmpty(Map<?, ?> value) {
        if (value == null || value.isEmpty()) {
            AssertCommons.INSTANCE.throwException(ASSERT_NOT_EMPTY_DEFAULT_MSG);
        }
    }

    public void assertNotEmpty(String message, Map<?, ?> value) {
        if (value == null || value.isEmpty()) {
            AssertCommons.INSTANCE.throwException(message == null ? ASSERT_NOT_EMPTY_DEFAULT_MSG : message);
        }
    }

    public void assertNotEmpty(Supplier<String> messageProducer, Map<?, ?> value) {
        if (value == null || value.isEmpty()) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? ASSERT_NOT_EMPTY_DEFAULT_MSG : messageProducer.get());
        }
    }

    public void assertNotEmpty(ErrorCode errorCode, Map<?, ?> value) {
        if (value == null || value.isEmpty()) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertEmpty(String value) {
        if (!this.checkIsBlank(value)) {
            AssertCommons.INSTANCE.throwException(ASSERT_EMPTY_DEFAULT_MSG);
        }
    }

    public void assertEmpty(String message, String value) {
        if (!this.checkIsBlank(value)) {
            AssertCommons.INSTANCE.throwException(message == null ? ASSERT_EMPTY_DEFAULT_MSG : message);
        }
    }

    public void assertEmpty(Supplier<String> messageProducer, String value) {
        if (!this.checkIsBlank(value)) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? ASSERT_EMPTY_DEFAULT_MSG : messageProducer.get());
        }
    }

    public void assertEmpty(ErrorCode errorCode, String value) {
        if (!this.checkIsBlank(value)) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertEmpty(Collection<?> value) {
        if (value == null || !value.isEmpty()) {
            AssertCommons.INSTANCE.throwException(ASSERT_EMPTY_DEFAULT_MSG);
        }
    }

    public void assertEmpty(Supplier<String> messageProducer, Collection<?> value) {
        if (value == null || !value.isEmpty()) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? ASSERT_EMPTY_DEFAULT_MSG : messageProducer.get());
        }
    }

    public void assertEmpty(String message, Collection<?> value) {
        if (value == null || !value.isEmpty()) {
            AssertCommons.INSTANCE.throwException(message == null ? ASSERT_EMPTY_DEFAULT_MSG : message);
        }
    }

    public void assertEmpty(ErrorCode errorCode, Collection<?> value) {
        if (value == null || !value.isEmpty()) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertEmpty(Map<?, ?> value) {
        if (value == null || !value.isEmpty()) {
            AssertCommons.INSTANCE.throwException(ASSERT_EMPTY_DEFAULT_MSG);
        }
    }

    public void assertEmpty(String message, Map<?, ?> value) {
        if (value == null || !value.isEmpty()) {
            AssertCommons.INSTANCE.throwException(message == null ? ASSERT_EMPTY_DEFAULT_MSG : message);
        }
    }

    public void assertEmpty(Supplier<String> messageProducer, Map<?, ?> value) {
        if (value == null || !value.isEmpty()) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? ASSERT_EMPTY_DEFAULT_MSG : messageProducer.get());
        }
    }

    public void assertEmpty(ErrorCode errorCode, Map<?, ?> value) {
        if (value == null || !value.isEmpty()) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertEmpty(IsEmptyFacet value) {
        if (value == null || !value.isEmpty()) {
            AssertCommons.INSTANCE.throwException(ASSERT_EMPTY_DEFAULT_MSG);
        }
    }

    public void assertEmpty(Supplier<String> messageProducer, IsEmptyFacet value) {
        if (value == null || !value.isEmpty()) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? ASSERT_EMPTY_DEFAULT_MSG : messageProducer.get());
        }
    }

    public void assertEmpty(String message, IsEmptyFacet value) {
        if (value == null || !value.isEmpty()) {
            AssertCommons.INSTANCE.throwException(message == null ? ASSERT_EMPTY_DEFAULT_MSG : message);
        }
    }

    public void assertEmpty(ErrorCode errorCode, IsEmptyFacet value) {
        if (value == null || !value.isEmpty()) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertNullOrEmpty(String value) {
        if (value != null && !this.checkIsBlank(value)) {
            AssertCommons.INSTANCE.throwException(ASSERT_EMPTY_DEFAULT_MSG);
        }
    }

    public void assertNullOrEmpty(String message, String value) {
        if (value != null && !this.checkIsBlank(value)) {
            AssertCommons.INSTANCE.throwException(message == null ? ASSERT_EMPTY_DEFAULT_MSG : message);
        }
    }

    public void assertNullOrEmpty(Supplier<String> messageProducer, String value) {
        if (value != null && !this.checkIsBlank(value)) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? ASSERT_EMPTY_DEFAULT_MSG : messageProducer.get());
        }
    }

    public void assertNullOrEmpty(ErrorCode errorCode, String value) {
        if (value != null && !this.checkIsBlank(value)) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertNullOrEmpty(Collection<?> value) {
        if (value != null && !value.isEmpty()) {
            AssertCommons.INSTANCE.throwException(ASSERT_EMPTY_DEFAULT_MSG);
        }
    }

    public void assertNullOrEmpty(Supplier<String> messageProducer, Collection<?> value) {
        if (value != null && !value.isEmpty()) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? ASSERT_EMPTY_DEFAULT_MSG : messageProducer.get());
        }
    }

    public void assertNullOrEmpty(String message, Collection<?> value) {
        if (value != null && !value.isEmpty()) {
            AssertCommons.INSTANCE.throwException(message == null ? ASSERT_EMPTY_DEFAULT_MSG : message);
        }
    }

    public void assertNullOrEmpty(ErrorCode errorCode, Collection<?> value) {
        if (value != null && !value.isEmpty()) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertNullOrEmpty(Map<?, ?> value) {
        if (value != null && !value.isEmpty()) {
            AssertCommons.INSTANCE.throwException(ASSERT_EMPTY_DEFAULT_MSG);
        }
    }

    public void assertNullOrEmpty(String message, Map<?, ?> value) {
        if (value != null && !value.isEmpty()) {
            AssertCommons.INSTANCE.throwException(message == null ? ASSERT_EMPTY_DEFAULT_MSG : message);
        }
    }

    public void assertNullOrEmpty(Supplier<String> messageProducer, Map<?, ?> value) {
        if (value != null && !value.isEmpty()) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? ASSERT_EMPTY_DEFAULT_MSG : messageProducer.get());
        }
    }

    public void assertNullOrEmpty(ErrorCode errorCode, Map<?, ?> value) {
        if (value != null && !value.isEmpty()) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertNullOrEmpty(IsEmptyFacet value) {
        if (value != null && !value.isEmpty()) {
            AssertCommons.INSTANCE.throwException(ASSERT_EMPTY_DEFAULT_MSG);
        }
    }

    public void assertNullOrEmpty(Supplier<String> messageProducer, IsEmptyFacet value) {
        if (value != null && !value.isEmpty()) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? ASSERT_EMPTY_DEFAULT_MSG : messageProducer.get());
        }
    }

    public void assertNullOrEmpty(String message, IsEmptyFacet value) {
        if (value != null && !value.isEmpty()) {
            AssertCommons.INSTANCE.throwException(message == null ? ASSERT_EMPTY_DEFAULT_MSG : message);
        }
    }

    public void assertNullOrEmpty(ErrorCode errorCode, IsEmptyFacet value) {
        if (value != null && !value.isEmpty()) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    private AssertEmpty() {
    }
}

