/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.exceptions.asserts;

import io.inugami.api.exceptions.ErrorCode;
import io.inugami.api.exceptions.asserts.AssertCommons;
import java.util.function.Supplier;

public final class AssertEquals {
    private static final String DEFAULT_MESSAGE = "object must be equals";
    public static final AssertEquals INSTANCE = new AssertEquals();

    public void assertEquals(Object ref, Object value) {
        this.assertEquals(DEFAULT_MESSAGE, ref, value);
    }

    public void assertEquals(String message, Object ref, Object value) {
        boolean result;
        boolean bl = result = ref == value;
        if (!result && ref != null) {
            result = ref.equals(value);
        }
        if (!result) {
            String msg = message == null ? DEFAULT_MESSAGE : message;
            AssertCommons.INSTANCE.throwException(msg);
        }
    }

    public void assertEquals(Supplier<String> messageProducer, Object ref, Object value) {
        boolean result;
        boolean bl = result = ref == value;
        if (!result && ref != null) {
            result = ref.equals(value);
        }
        if (!result) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? DEFAULT_MESSAGE : messageProducer.get());
        }
    }

    public void assertEquals(ErrorCode errorCode, Object ref, Object value) {
        boolean result;
        boolean bl = result = ref == value;
        if (!result && ref != null) {
            result = ref.equals(value);
        }
        if (!result) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertEquals(int ref, int value) {
        this.assertEquals(DEFAULT_MESSAGE, ref, value);
    }

    public void assertEquals(String message, int ref, int value) {
        if (ref != value) {
            String msg = message == null ? DEFAULT_MESSAGE : message;
            AssertCommons.INSTANCE.throwException(msg);
        }
    }

    public void assertEquals(Supplier<String> messageProducer, int ref, int value) {
        if (ref != value) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? DEFAULT_MESSAGE : messageProducer.get());
        }
    }

    public void assertEquals(ErrorCode errorCode, int ref, int value) {
        if (ref != value) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertEquals(long ref, long value) {
        this.assertEquals(DEFAULT_MESSAGE, ref, value);
    }

    public void assertEquals(String message, long ref, long value) {
        if (ref != value) {
            String msg = message == null ? DEFAULT_MESSAGE : message;
            AssertCommons.INSTANCE.throwException(msg);
        }
    }

    public void assertEquals(Supplier<String> messageProducer, long ref, long value) {
        if (ref != value) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? DEFAULT_MESSAGE : messageProducer.get());
        }
    }

    public void assertEquals(ErrorCode errorCode, long ref, long value) {
        if (ref != value) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertEquals(float ref, float value) {
        this.assertEquals(DEFAULT_MESSAGE, ref, value);
    }

    public void assertEquals(String message, float ref, float value) {
        if (ref != value) {
            String msg = message == null ? DEFAULT_MESSAGE : message;
            AssertCommons.INSTANCE.throwException(msg);
        }
    }

    public void assertEquals(Supplier<String> messageProducer, float ref, float value) {
        if (ref != value) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? DEFAULT_MESSAGE : messageProducer.get());
        }
    }

    public void assertEquals(ErrorCode errorCode, float ref, float value) {
        if (ref != value) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertEquals(double ref, double value) {
        this.assertEquals(DEFAULT_MESSAGE, ref, value);
    }

    public void assertEquals(String message, double ref, double value) {
        if (ref != value) {
            String msg = message == null ? DEFAULT_MESSAGE : message;
            AssertCommons.INSTANCE.throwException(msg);
        }
    }

    public void assertEquals(Supplier<String> messageProducer, double ref, double value) {
        if (ref != value) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? DEFAULT_MESSAGE : messageProducer.get());
        }
    }

    public void assertEquals(ErrorCode errorCode, double ref, double value) {
        if (ref != value) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    private AssertEquals() {
    }
}

