/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.exceptions.asserts;

import io.inugami.api.exceptions.Asserts;
import io.inugami.api.exceptions.ErrorCode;
import io.inugami.api.exceptions.MessagesFormatter;
import io.inugami.api.exceptions.asserts.AssertCommons;
import java.io.File;

public final class AssertFile {
    public static final AssertFile INSTANCE = new AssertFile();
    private static final String FILE_NOT_EXISTS = "file {0} doesn't exists";
    private static final String FILE_NOT_FILE = "file {0} is a folder";
    private static final String FILE_NOT_READABLE = "file {0} can't be read";
    private static final String FILE_NOT_WRITE = "file {0} can't be write";
    private static final String FILE_NOT_EXECUTABLE = "file {0} can't be execute";
    private static final String FOLDER_NOT_EXISTS = "folder {0} doesn't exists";
    private static final String FOLDER_NOT_IS_FILE = "folder {0} is a file";

    public void assertFileExists(File path) {
        Asserts.assertNotNull(() -> MessagesFormatter.format((String)FILE_NOT_EXISTS, (Object[])new Object[]{path}), path);
        if (!path.exists()) {
            AssertCommons.INSTANCE.throwException(MessagesFormatter.format((String)FILE_NOT_EXISTS, (Object[])new Object[]{path}));
        }
        if (!path.isFile()) {
            AssertCommons.INSTANCE.throwException(MessagesFormatter.format((String)FILE_NOT_FILE, (Object[])new Object[]{path}));
        }
    }

    public void assertFileExists(String message, File path) {
        Asserts.assertNotNull(message, path);
        if (!path.exists()) {
            AssertCommons.INSTANCE.throwException(message);
        }
        if (!path.isFile()) {
            AssertCommons.INSTANCE.throwException(message);
        }
    }

    public void assertFileExists(ErrorCode errorCode, File path) {
        Asserts.assertNotNull(errorCode, new Object[]{path});
        if (!path.exists()) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
        if (!path.isFile()) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertFileReadable(File path) {
        this.assertFileExists(path);
        if (!path.canRead()) {
            AssertCommons.INSTANCE.throwException(MessagesFormatter.format((String)FILE_NOT_READABLE, (Object[])new Object[]{path}));
        }
    }

    public void assertFileReadable(String message, File path) {
        this.assertFileExists(message, path);
        if (!path.canRead()) {
            AssertCommons.INSTANCE.throwException(message);
        }
    }

    public void assertFileReadable(ErrorCode errorCode, File path) {
        this.assertFileExists(errorCode, path);
        if (!path.canRead()) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertFileWrite(File path) {
        this.assertFileExists(path);
        if (!path.canWrite()) {
            AssertCommons.INSTANCE.throwException(MessagesFormatter.format((String)FILE_NOT_WRITE, (Object[])new Object[]{path}));
        }
    }

    public void assertFileWrite(String message, File path) {
        this.assertFileExists(message, path);
        if (!path.canWrite()) {
            AssertCommons.INSTANCE.throwException(message);
        }
    }

    public void assertFileWrite(ErrorCode errorCode, File path) {
        this.assertFileExists(errorCode, path);
        if (!path.canWrite()) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertFileExecutable(File path) {
        this.assertFileExists(path);
        if (!path.canExecute()) {
            AssertCommons.INSTANCE.throwException(MessagesFormatter.format((String)FILE_NOT_EXECUTABLE, (Object[])new Object[]{path}));
        }
    }

    public void assertFileExecutable(String message, File path) {
        this.assertFileExists(message, path);
        if (!path.canExecute()) {
            AssertCommons.INSTANCE.throwException(message);
        }
    }

    public void assertFileExecutable(ErrorCode errorCode, File path) {
        this.assertFileExists(errorCode, path);
        if (!path.canExecute()) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertFolderExists(File path) {
        Asserts.assertNotNull(() -> MessagesFormatter.format((String)FOLDER_NOT_EXISTS, (Object[])new Object[]{path}), path);
        if (!path.exists()) {
            AssertCommons.INSTANCE.throwException(MessagesFormatter.format((String)FOLDER_NOT_EXISTS, (Object[])new Object[]{path}));
        }
        if (!path.isDirectory()) {
            AssertCommons.INSTANCE.throwException(MessagesFormatter.format((String)FOLDER_NOT_IS_FILE, (Object[])new Object[]{path}));
        }
    }

    public void assertFolderExists(String message, File path) {
        Asserts.assertNotNull(message, path);
        if (!path.exists()) {
            AssertCommons.INSTANCE.throwException(message);
        }
        if (!path.isDirectory()) {
            AssertCommons.INSTANCE.throwException(message);
        }
    }

    public void assertFolderExists(ErrorCode errorCode, File path) {
        Asserts.assertNotNull(errorCode, new Object[]{path});
        if (!path.exists()) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
        if (!path.isDirectory()) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    private AssertFile() {
    }
}

