/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.exceptions.asserts;

import io.inugami.api.exceptions.ErrorCode;
import io.inugami.api.exceptions.asserts.AssertCommons;
import java.math.BigDecimal;
import java.util.function.Supplier;

public final class AssertHigher {
    private static final String DEFAULT_MESSAGE = "value must be higher";
    public static final AssertHigher INSTANCE = new AssertHigher();

    public void assertHigher(int ref, int value) {
        this.assertHigher(DEFAULT_MESSAGE, ref, value);
    }

    public void assertHigher(String message, int ref, int value) {
        if (ref >= value) {
            String msg = message == null ? DEFAULT_MESSAGE : message;
            AssertCommons.INSTANCE.throwException(msg);
        }
    }

    public void assertHigher(Supplier<String> messageProducer, int ref, int value) {
        if (ref >= value) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? DEFAULT_MESSAGE : messageProducer.get());
        }
    }

    public void assertHigher(ErrorCode errorCode, int ref, int value) {
        if (ref >= value) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertHigher(long ref, long value) {
        this.assertHigher(DEFAULT_MESSAGE, ref, value);
    }

    public void assertHigher(String message, long ref, long value) {
        if (ref >= value) {
            String msg = message == null ? DEFAULT_MESSAGE : message;
            AssertCommons.INSTANCE.throwException(msg);
        }
    }

    public void assertHigher(Supplier<String> messageProducer, long ref, long value) {
        if (ref >= value) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? DEFAULT_MESSAGE : messageProducer.get());
        }
    }

    public void assertHigher(ErrorCode errorCode, long ref, long value) {
        if (ref >= value) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertHigher(float ref, float value) {
        this.assertHigher(DEFAULT_MESSAGE, ref, value);
    }

    public void assertHigher(String message, float ref, float value) {
        if (ref >= value) {
            String msg = message == null ? DEFAULT_MESSAGE : message;
            AssertCommons.INSTANCE.throwException(msg);
        }
    }

    public void assertHigher(Supplier<String> messageProducer, float ref, float value) {
        if (ref >= value) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? DEFAULT_MESSAGE : messageProducer.get());
        }
    }

    public void assertHigher(ErrorCode errorCode, float ref, float value) {
        if (ref >= value) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertHigher(double ref, double value) {
        this.assertHigher(DEFAULT_MESSAGE, ref, value);
    }

    public void assertHigher(String message, double ref, double value) {
        if (ref >= value) {
            String msg = message == null ? DEFAULT_MESSAGE : message;
            AssertCommons.INSTANCE.throwException(msg);
        }
    }

    public void assertHigher(Supplier<String> messageProducer, double ref, double value) {
        if (ref >= value) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? DEFAULT_MESSAGE : messageProducer.get());
        }
    }

    public void assertHigher(ErrorCode errorCode, double ref, double value) {
        if (ref >= value) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertHigher(Integer ref, Integer value) {
        this.assertHigher(DEFAULT_MESSAGE, ref, value);
    }

    public void assertHigher(String message, Integer ref, Integer value) {
        if (AssertHigher.checkLower(ref, value)) {
            String msg = message == null ? DEFAULT_MESSAGE : message;
            AssertCommons.INSTANCE.throwException(msg);
        }
    }

    public void assertHigher(Supplier<String> messageProducer, Integer ref, Integer value) {
        if (AssertHigher.checkLower(ref, value)) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? DEFAULT_MESSAGE : messageProducer.get());
        }
    }

    public void assertHigher(ErrorCode errorCode, Integer ref, Integer value) {
        if (AssertHigher.checkLower(ref, value)) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertHigher(Long ref, Long value) {
        this.assertHigher(DEFAULT_MESSAGE, ref, value);
    }

    public void assertHigher(String message, Long ref, Long value) {
        if (AssertHigher.checkLower(ref, value)) {
            String msg = message == null ? DEFAULT_MESSAGE : message;
            AssertCommons.INSTANCE.throwException(msg);
        }
    }

    public void assertHigher(Supplier<String> messageProducer, Long ref, Long value) {
        if (AssertHigher.checkLower(ref, value)) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? DEFAULT_MESSAGE : messageProducer.get());
        }
    }

    public void assertHigher(ErrorCode errorCode, Long ref, Long value) {
        if (AssertHigher.checkLower(ref, value)) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertHigher(Double ref, Double value) {
        this.assertHigher(DEFAULT_MESSAGE, ref, value);
    }

    public void assertHigher(String message, Double ref, Double value) {
        if (AssertHigher.checkLower(ref, value)) {
            String msg = message == null ? DEFAULT_MESSAGE : message;
            AssertCommons.INSTANCE.throwException(msg);
        }
    }

    public void assertHigher(Supplier<String> messageProducer, Double ref, Double value) {
        if (AssertHigher.checkLower(ref, value)) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? DEFAULT_MESSAGE : messageProducer.get());
        }
    }

    public void assertHigher(ErrorCode errorCode, Double ref, Double value) {
        if (AssertHigher.checkLower(ref, value)) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertHigher(BigDecimal ref, BigDecimal value) {
        this.assertHigher(DEFAULT_MESSAGE, ref, value);
    }

    public void assertHigher(String message, BigDecimal ref, BigDecimal value) {
        if (AssertHigher.checkLower(ref, value)) {
            String msg = message == null ? DEFAULT_MESSAGE : message;
            AssertCommons.INSTANCE.throwException(msg);
        }
    }

    public void assertHigher(Supplier<String> messageProducer, BigDecimal ref, BigDecimal value) {
        if (AssertHigher.checkLower(ref, value)) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? DEFAULT_MESSAGE : messageProducer.get());
        }
    }

    public void assertHigher(ErrorCode errorCode, BigDecimal ref, BigDecimal value) {
        if (AssertHigher.checkLower(ref, value)) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    private static boolean checkLower(Integer ref, Integer value) {
        return ref == null ? value != null : ref.compareTo(value) >= 0;
    }

    private static boolean checkLower(Long ref, Long value) {
        return ref == null ? value != null : ref.compareTo(value) >= 0;
    }

    private static boolean checkLower(Double ref, Double value) {
        return ref == null ? value != null : ref.compareTo(value) >= 0;
    }

    private static boolean checkLower(BigDecimal ref, BigDecimal value) {
        return ref == null ? value != null : ref.compareTo(value) >= 0;
    }

    private AssertHigher() {
    }
}

