/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.exceptions.asserts;

import io.inugami.api.exceptions.ErrorCode;
import io.inugami.api.exceptions.asserts.AssertCommons;
import java.math.BigDecimal;
import java.util.function.Supplier;

public final class AssertHigherOrEquals {
    private static final String DEFAULT_MESSAGE = "value must be higher or equals";
    public static final AssertHigherOrEquals INSTANCE = new AssertHigherOrEquals();

    public void assertHigherOrEquals(int ref, int value) {
        this.assertHigherOrEquals(DEFAULT_MESSAGE, ref, value);
    }

    public void assertHigherOrEquals(String message, int ref, int value) {
        if (ref > value) {
            String msg = message == null ? DEFAULT_MESSAGE : message;
            AssertCommons.INSTANCE.throwException(msg);
        }
    }

    public void assertHigherOrEquals(Supplier<String> messageProducer, int ref, int value) {
        if (ref > value) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? DEFAULT_MESSAGE : messageProducer.get());
        }
    }

    public void assertHigherOrEquals(ErrorCode errorCode, int ref, int value) {
        if (ref > value) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertHigherOrEquals(long ref, long value) {
        this.assertHigherOrEquals(DEFAULT_MESSAGE, ref, value);
    }

    public void assertHigherOrEquals(String message, long ref, long value) {
        if (ref > value) {
            String msg = message == null ? DEFAULT_MESSAGE : message;
            AssertCommons.INSTANCE.throwException(msg);
        }
    }

    public void assertHigherOrEquals(Supplier<String> messageProducer, long ref, long value) {
        if (ref > value) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? DEFAULT_MESSAGE : messageProducer.get());
        }
    }

    public void assertHigherOrEquals(ErrorCode errorCode, long ref, long value) {
        if (ref > value) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertHigherOrEquals(float ref, float value) {
        this.assertHigherOrEquals(DEFAULT_MESSAGE, ref, value);
    }

    public void assertHigherOrEquals(String message, float ref, float value) {
        if (ref > value) {
            String msg = message == null ? DEFAULT_MESSAGE : message;
            AssertCommons.INSTANCE.throwException(msg);
        }
    }

    public void assertHigherOrEquals(Supplier<String> messageProducer, float ref, float value) {
        if (ref > value) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? DEFAULT_MESSAGE : messageProducer.get());
        }
    }

    public void assertHigherOrEquals(ErrorCode errorCode, float ref, float value) {
        if (ref > value) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertHigherOrEquals(double ref, double value) {
        this.assertHigherOrEquals(DEFAULT_MESSAGE, ref, value);
    }

    public void assertHigherOrEquals(String message, double ref, double value) {
        if (ref > value) {
            String msg = message == null ? DEFAULT_MESSAGE : message;
            AssertCommons.INSTANCE.throwException(msg);
        }
    }

    public void assertHigherOrEquals(Supplier<String> messageProducer, double ref, double value) {
        if (ref > value) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? DEFAULT_MESSAGE : messageProducer.get());
        }
    }

    public void assertHigherOrEquals(ErrorCode errorCode, double ref, double value) {
        if (ref > value) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertHigherOrEquals(Integer ref, Integer value) {
        this.assertHigherOrEquals(DEFAULT_MESSAGE, ref, value);
    }

    public void assertHigherOrEquals(String message, Integer ref, Integer value) {
        if (AssertHigherOrEquals.checkLower(ref, value)) {
            String msg = message == null ? DEFAULT_MESSAGE : message;
            AssertCommons.INSTANCE.throwException(msg);
        }
    }

    public void assertHigherOrEquals(Supplier<String> messageProducer, Integer ref, Integer value) {
        if (AssertHigherOrEquals.checkLower(ref, value)) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? DEFAULT_MESSAGE : messageProducer.get());
        }
    }

    public void assertHigherOrEquals(ErrorCode errorCode, Integer ref, Integer value) {
        if (AssertHigherOrEquals.checkLower(ref, value)) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertHigherOrEquals(Long ref, Long value) {
        this.assertHigherOrEquals(DEFAULT_MESSAGE, ref, value);
    }

    public void assertHigherOrEquals(String message, Long ref, Long value) {
        if (AssertHigherOrEquals.checkLower(ref, value)) {
            String msg = message == null ? DEFAULT_MESSAGE : message;
            AssertCommons.INSTANCE.throwException(msg);
        }
    }

    public void assertHigherOrEquals(Supplier<String> messageProducer, Long ref, Long value) {
        if (AssertHigherOrEquals.checkLower(ref, value)) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? DEFAULT_MESSAGE : messageProducer.get());
        }
    }

    public void assertHigherOrEquals(ErrorCode errorCode, Long ref, Long value) {
        if (AssertHigherOrEquals.checkLower(ref, value)) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertHigherOrEquals(Double ref, Double value) {
        this.assertHigherOrEquals(DEFAULT_MESSAGE, ref, value);
    }

    public void assertHigherOrEquals(String message, Double ref, Double value) {
        if (AssertHigherOrEquals.checkLower(ref, value)) {
            String msg = message == null ? DEFAULT_MESSAGE : message;
            AssertCommons.INSTANCE.throwException(msg);
        }
    }

    public void assertHigherOrEquals(Supplier<String> messageProducer, Double ref, Double value) {
        if (AssertHigherOrEquals.checkLower(ref, value)) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? DEFAULT_MESSAGE : messageProducer.get());
        }
    }

    public void assertHigherOrEquals(ErrorCode errorCode, Double ref, Double value) {
        if (AssertHigherOrEquals.checkLower(ref, value)) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertHigherOrEquals(BigDecimal ref, BigDecimal value) {
        this.assertHigherOrEquals(DEFAULT_MESSAGE, ref, value);
    }

    public void assertHigherOrEquals(String message, BigDecimal ref, BigDecimal value) {
        if (AssertHigherOrEquals.checkLower(ref, value)) {
            String msg = message == null ? DEFAULT_MESSAGE : message;
            AssertCommons.INSTANCE.throwException(msg);
        }
    }

    public void assertHigherOrEquals(Supplier<String> messageProducer, BigDecimal ref, BigDecimal value) {
        if (AssertHigherOrEquals.checkLower(ref, value)) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? DEFAULT_MESSAGE : messageProducer.get());
        }
    }

    public void assertHigherOrEquals(ErrorCode errorCode, BigDecimal ref, BigDecimal value) {
        if (AssertHigherOrEquals.checkLower(ref, value)) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    private static boolean checkLower(Integer ref, Integer value) {
        return ref == null ? value != null : ref.compareTo(value) > 0;
    }

    private static boolean checkLower(Long ref, Long value) {
        return ref == null ? value != null : ref.compareTo(value) > 0;
    }

    private static boolean checkLower(Double ref, Double value) {
        return ref == null ? value != null : ref.compareTo(value) > 0;
    }

    private static boolean checkLower(BigDecimal ref, BigDecimal value) {
        return ref == null ? value != null : ref.compareTo(value) > 0;
    }

    private AssertHigherOrEquals() {
    }
}

