/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.exceptions.asserts;

import io.inugami.api.exceptions.ErrorCode;
import io.inugami.api.exceptions.asserts.AssertCommons;
import io.inugami.api.exceptions.asserts.AssertNull;
import java.time.chrono.ChronoLocalDate;
import java.util.function.Supplier;

public class AssertLocalDate {
    public static final String OBJECT_REF_NULL = "Reference value is required";
    public static final String OBJECT_NULL = "Value is required";
    public static final String CURRENT_DATE_IS_AFTER_THE_REFERENCE = "Current date is after the reference";
    public static final String CURRENT_DATE_IS_BEFORE_THE_REFERENCE = "Current date is before the reference";
    public static final String CURRENT_DATE_ISN_T_EQUALS_WITH_REFERENCE = "Current date isn't equals with reference";
    public static final AssertLocalDate INSTANCE = new AssertLocalDate();

    public void assertBefore(ChronoLocalDate ref, ChronoLocalDate value) {
        this.assertBefore(CURRENT_DATE_IS_AFTER_THE_REFERENCE, ref, value);
    }

    public void assertBefore(String message, ChronoLocalDate ref, ChronoLocalDate value) {
        if (AssertLocalDate.isAfter(ref, value)) {
            String msg = message == null ? CURRENT_DATE_IS_AFTER_THE_REFERENCE : message;
            AssertCommons.INSTANCE.throwException(msg);
        }
    }

    public void assertBefore(Supplier<String> messageProducer, ChronoLocalDate ref, ChronoLocalDate value) {
        if (AssertLocalDate.isAfter(ref, value)) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? CURRENT_DATE_IS_AFTER_THE_REFERENCE : messageProducer.get());
        }
    }

    public void assertBefore(ErrorCode errorCode, ChronoLocalDate ref, ChronoLocalDate value) {
        if (AssertLocalDate.isAfter(ref, value)) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    private boolean isBefore(ChronoLocalDate ref, ChronoLocalDate value) {
        AssertNull.INSTANCE.assertNotNull(OBJECT_REF_NULL, ref);
        AssertNull.INSTANCE.assertNotNull(OBJECT_NULL, value);
        return ref.isAfter(value);
    }

    public void assertAfter(ChronoLocalDate ref, ChronoLocalDate value) {
        this.assertAfter(CURRENT_DATE_IS_BEFORE_THE_REFERENCE, ref, value);
    }

    public void assertAfter(String message, ChronoLocalDate ref, ChronoLocalDate value) {
        if (this.isBefore(ref, value)) {
            String msg = message == null ? CURRENT_DATE_IS_BEFORE_THE_REFERENCE : message;
            AssertCommons.INSTANCE.throwException(msg);
        }
    }

    public void assertAfter(Supplier<String> messageProducer, ChronoLocalDate ref, ChronoLocalDate value) {
        if (this.isBefore(ref, value)) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? CURRENT_DATE_IS_BEFORE_THE_REFERENCE : messageProducer.get());
        }
    }

    public void assertAfter(ErrorCode errorCode, ChronoLocalDate ref, ChronoLocalDate value) {
        if (this.isBefore(ref, value)) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    private static boolean isAfter(ChronoLocalDate ref, ChronoLocalDate value) {
        AssertNull.INSTANCE.assertNotNull(OBJECT_REF_NULL, ref);
        AssertNull.INSTANCE.assertNotNull(OBJECT_NULL, value);
        return ref.isBefore(value);
    }

    public void assertEquals(ChronoLocalDate ref, ChronoLocalDate value) {
        this.assertEquals(CURRENT_DATE_ISN_T_EQUALS_WITH_REFERENCE, ref, value);
    }

    public void assertEquals(String message, ChronoLocalDate ref, ChronoLocalDate value) {
        if (!AssertLocalDate.isEquals(ref, value)) {
            String msg = message == null ? CURRENT_DATE_ISN_T_EQUALS_WITH_REFERENCE : message;
            AssertCommons.INSTANCE.throwException(msg);
        }
    }

    public void assertEquals(Supplier<String> messageProducer, ChronoLocalDate ref, ChronoLocalDate value) {
        if (!AssertLocalDate.isEquals(ref, value)) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? CURRENT_DATE_ISN_T_EQUALS_WITH_REFERENCE : messageProducer.get());
        }
    }

    public void assertEquals(ErrorCode errorCode, ChronoLocalDate ref, ChronoLocalDate value) {
        if (!AssertLocalDate.isEquals(ref, value)) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    private static boolean isEquals(ChronoLocalDate ref, ChronoLocalDate value) {
        AssertNull.INSTANCE.assertNotNull(OBJECT_REF_NULL, ref);
        AssertNull.INSTANCE.assertNotNull(OBJECT_NULL, value);
        return ref.isEqual(value);
    }
}

