/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.exceptions.asserts;

import io.inugami.api.exceptions.ErrorCode;
import io.inugami.api.exceptions.asserts.AssertCommons;
import io.inugami.api.exceptions.asserts.AssertNull;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.util.function.Supplier;

public class AssertLocalDateTime {
    public static final String OBJECT_REF_NULL = "Reference value is required";
    public static final String OBJECT_NULL = "Value is required";
    public static final String CURRENT_DATE_IS_AFTER_THE_REFERENCE = "Current date is after the reference";
    public static final String CURRENT_DATE_IS_BEFORE_THE_REFERENCE = "Current date is before the reference";
    public static final String CURRENT_DATE_ISN_T_EQUALS_WITH_REFERENCE = "Current date isn't equals with reference";
    public static final AssertLocalDateTime INSTANCE = new AssertLocalDateTime();

    public void assertBefore(ChronoLocalDateTime<LocalDate> ref, ChronoLocalDateTime<LocalDate> value) {
        this.assertBefore(CURRENT_DATE_IS_AFTER_THE_REFERENCE, ref, value);
    }

    public void assertBefore(String message, ChronoLocalDateTime<LocalDate> ref, ChronoLocalDateTime<LocalDate> value) {
        if (AssertLocalDateTime.isAfter(ref, value)) {
            String msg = message == null ? CURRENT_DATE_IS_AFTER_THE_REFERENCE : message;
            AssertCommons.INSTANCE.throwException(msg);
        }
    }

    public void assertBefore(Supplier<String> messageProducer, ChronoLocalDateTime<LocalDate> ref, ChronoLocalDateTime<LocalDate> value) {
        if (AssertLocalDateTime.isAfter(ref, value)) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? CURRENT_DATE_IS_AFTER_THE_REFERENCE : messageProducer.get());
        }
    }

    public void assertBefore(ErrorCode errorCode, ChronoLocalDateTime<LocalDate> ref, ChronoLocalDateTime<LocalDate> value) {
        if (AssertLocalDateTime.isAfter(ref, value)) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    private boolean isBefore(ChronoLocalDateTime<LocalDate> ref, ChronoLocalDateTime<LocalDate> value) {
        AssertNull.INSTANCE.assertNotNull(OBJECT_REF_NULL, ref);
        AssertNull.INSTANCE.assertNotNull(OBJECT_NULL, value);
        return ref.isAfter(value);
    }

    public void assertAfter(ChronoLocalDateTime<LocalDate> ref, ChronoLocalDateTime<LocalDate> value) {
        this.assertAfter(CURRENT_DATE_IS_BEFORE_THE_REFERENCE, ref, value);
    }

    public void assertAfter(String message, ChronoLocalDateTime<LocalDate> ref, ChronoLocalDateTime<LocalDate> value) {
        if (this.isBefore(ref, value)) {
            String msg = message == null ? CURRENT_DATE_IS_BEFORE_THE_REFERENCE : message;
            AssertCommons.INSTANCE.throwException(msg);
        }
    }

    public void assertAfter(Supplier<String> messageProducer, ChronoLocalDateTime<LocalDate> ref, ChronoLocalDateTime<LocalDate> value) {
        if (this.isBefore(ref, value)) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? CURRENT_DATE_IS_BEFORE_THE_REFERENCE : messageProducer.get());
        }
    }

    public void assertAfter(ErrorCode errorCode, ChronoLocalDateTime<LocalDate> ref, ChronoLocalDateTime<LocalDate> value) {
        if (this.isBefore(ref, value)) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    private static boolean isAfter(ChronoLocalDateTime<LocalDate> ref, ChronoLocalDateTime<LocalDate> value) {
        AssertNull.INSTANCE.assertNotNull(OBJECT_REF_NULL, ref);
        AssertNull.INSTANCE.assertNotNull(OBJECT_NULL, value);
        return ref.isBefore(value);
    }

    public void assertEquals(ChronoLocalDateTime<LocalDate> ref, ChronoLocalDateTime<LocalDate> value) {
        this.assertEquals(CURRENT_DATE_ISN_T_EQUALS_WITH_REFERENCE, ref, value);
    }

    public void assertEquals(String message, ChronoLocalDateTime<LocalDate> ref, ChronoLocalDateTime<LocalDate> value) {
        if (!AssertLocalDateTime.isEquals(ref, value)) {
            String msg = message == null ? CURRENT_DATE_ISN_T_EQUALS_WITH_REFERENCE : message;
            AssertCommons.INSTANCE.throwException(msg);
        }
    }

    public void assertEquals(Supplier<String> messageProducer, ChronoLocalDateTime<LocalDate> ref, ChronoLocalDateTime<LocalDate> value) {
        if (!AssertLocalDateTime.isEquals(ref, value)) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? CURRENT_DATE_ISN_T_EQUALS_WITH_REFERENCE : messageProducer.get());
        }
    }

    public void assertEquals(ErrorCode errorCode, ChronoLocalDateTime<LocalDate> ref, ChronoLocalDateTime<LocalDate> value) {
        if (!AssertLocalDateTime.isEquals(ref, value)) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    private static boolean isEquals(ChronoLocalDateTime<LocalDate> ref, ChronoLocalDateTime<LocalDate> value) {
        AssertNull.INSTANCE.assertNotNull(OBJECT_REF_NULL, ref);
        AssertNull.INSTANCE.assertNotNull(OBJECT_NULL, value);
        return ref.isEqual(value);
    }
}

