/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.exceptions.asserts;

import io.inugami.api.exceptions.ErrorCode;
import io.inugami.api.exceptions.asserts.AssertCommons;
import java.math.BigDecimal;
import java.util.function.Supplier;

public final class AssertLower {
    private static final String DEFAULT_MESSAGE = "value must be lower";
    public static final AssertLower INSTANCE = new AssertLower();

    public void assertLower(int ref, int value) {
        this.assertLower(DEFAULT_MESSAGE, ref, value);
    }

    public void assertLower(String message, int ref, int value) {
        if (ref <= value) {
            String msg = message == null ? DEFAULT_MESSAGE : message;
            AssertCommons.INSTANCE.throwException(msg);
        }
    }

    public void assertLower(Supplier<String> messageProducer, int ref, int value) {
        if (ref <= value) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? DEFAULT_MESSAGE : messageProducer.get());
        }
    }

    public void assertLower(ErrorCode errorCode, int ref, int value) {
        if (ref <= value) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertLower(long ref, long value) {
        this.assertLower(DEFAULT_MESSAGE, ref, value);
    }

    public void assertLower(String message, long ref, long value) {
        if (ref <= value) {
            String msg = message == null ? DEFAULT_MESSAGE : message;
            AssertCommons.INSTANCE.throwException(msg);
        }
    }

    public void assertLower(Supplier<String> messageProducer, long ref, long value) {
        if (ref <= value) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? DEFAULT_MESSAGE : messageProducer.get());
        }
    }

    public void assertLower(ErrorCode errorCode, long ref, long value) {
        if (ref <= value) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertLower(float ref, float value) {
        this.assertLower(DEFAULT_MESSAGE, ref, value);
    }

    public void assertLower(String message, float ref, float value) {
        if (ref <= value) {
            String msg = message == null ? DEFAULT_MESSAGE : message;
            AssertCommons.INSTANCE.throwException(msg);
        }
    }

    public void assertLower(Supplier<String> messageProducer, float ref, float value) {
        if (ref <= value) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? DEFAULT_MESSAGE : messageProducer.get());
        }
    }

    public void assertLower(ErrorCode errorCode, float ref, float value) {
        if (ref <= value) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertLower(double ref, double value) {
        this.assertLower(DEFAULT_MESSAGE, ref, value);
    }

    public void assertLower(String message, double ref, double value) {
        if (ref <= value) {
            String msg = message == null ? DEFAULT_MESSAGE : message;
            AssertCommons.INSTANCE.throwException(msg);
        }
    }

    public void assertLower(Supplier<String> messageProducer, double ref, double value) {
        if (ref <= value) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? DEFAULT_MESSAGE : messageProducer.get());
        }
    }

    public void assertLower(ErrorCode errorCode, double ref, double value) {
        if (ref <= value) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertLower(Integer ref, Integer value) {
        this.assertLower(DEFAULT_MESSAGE, ref, value);
    }

    public void assertLower(String message, Integer ref, Integer value) {
        if (AssertLower.checkHigher(ref, value)) {
            String msg = message == null ? DEFAULT_MESSAGE : message;
            AssertCommons.INSTANCE.throwException(msg);
        }
    }

    public void assertLower(Supplier<String> messageProducer, Integer ref, Integer value) {
        if (AssertLower.checkHigher(ref, value)) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? DEFAULT_MESSAGE : messageProducer.get());
        }
    }

    public void assertLower(ErrorCode errorCode, Integer ref, Integer value) {
        if (AssertLower.checkHigher(ref, value)) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertLower(Long ref, Long value) {
        this.assertLower(DEFAULT_MESSAGE, ref, value);
    }

    public void assertLower(String message, Long ref, Long value) {
        if (AssertLower.checkHigher(ref, value)) {
            String msg = message == null ? DEFAULT_MESSAGE : message;
            AssertCommons.INSTANCE.throwException(msg);
        }
    }

    public void assertLower(Supplier<String> messageProducer, Long ref, Long value) {
        if (AssertLower.checkHigher(ref, value)) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? DEFAULT_MESSAGE : messageProducer.get());
        }
    }

    public void assertLower(ErrorCode errorCode, Long ref, Long value) {
        if (AssertLower.checkHigher(ref, value)) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertLower(Double ref, Double value) {
        this.assertLower(DEFAULT_MESSAGE, ref, value);
    }

    public void assertLower(String message, Double ref, Double value) {
        if (AssertLower.checkHigher(ref, value)) {
            String msg = message == null ? DEFAULT_MESSAGE : message;
            AssertCommons.INSTANCE.throwException(msg);
        }
    }

    public void assertLower(Supplier<String> messageProducer, Double ref, Double value) {
        if (AssertLower.checkHigher(ref, value)) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? DEFAULT_MESSAGE : messageProducer.get());
        }
    }

    public void assertLower(ErrorCode errorCode, Double ref, Double value) {
        if (AssertLower.checkHigher(ref, value)) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertLower(BigDecimal ref, BigDecimal value) {
        this.assertLower(DEFAULT_MESSAGE, ref, value);
    }

    public void assertLower(String message, BigDecimal ref, BigDecimal value) {
        if (AssertLower.checkHigher(ref, value)) {
            String msg = message == null ? DEFAULT_MESSAGE : message;
            AssertCommons.INSTANCE.throwException(msg);
        }
    }

    public void assertLower(Supplier<String> messageProducer, BigDecimal ref, BigDecimal value) {
        if (AssertLower.checkHigher(ref, value)) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? DEFAULT_MESSAGE : messageProducer.get());
        }
    }

    public void assertLower(ErrorCode errorCode, BigDecimal ref, BigDecimal value) {
        if (AssertLower.checkHigher(ref, value)) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    private static boolean checkHigher(Integer ref, Integer value) {
        return ref == null ? value != null : ref.compareTo(value) <= 0;
    }

    private static boolean checkHigher(Long ref, Long value) {
        return ref == null ? value != null : ref.compareTo(value) <= 0;
    }

    private static boolean checkHigher(Double ref, Double value) {
        return ref == null ? value != null : ref.compareTo(value) <= 0;
    }

    private static boolean checkHigher(BigDecimal ref, BigDecimal value) {
        return ref == null ? value != null : ref.compareTo(value) <= 0;
    }

    private AssertLower() {
    }
}

