/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.exceptions.asserts;

import io.inugami.api.exceptions.ErrorCode;
import io.inugami.api.exceptions.asserts.AssertCommons;
import java.math.BigDecimal;
import java.util.function.Supplier;

public final class AssertLowerOrEquals {
    private static final String DEFAULT_MESSAGE = "value must be lower or equals";
    public static final AssertLowerOrEquals INSTANCE = new AssertLowerOrEquals();

    public void assertLowerOrEquals(int ref, int value) {
        this.assertLowerOrEquals(DEFAULT_MESSAGE, ref, value);
    }

    public void assertLowerOrEquals(String message, int ref, int value) {
        if (ref < value) {
            String msg = message == null ? DEFAULT_MESSAGE : message;
            AssertCommons.INSTANCE.throwException(msg);
        }
    }

    public void assertLowerOrEquals(Supplier<String> messageProducer, int ref, int value) {
        if (ref < value) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? DEFAULT_MESSAGE : messageProducer.get());
        }
    }

    public void assertLowerOrEquals(ErrorCode errorCode, int ref, int value) {
        if (ref < value) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertLowerOrEquals(long ref, long value) {
        this.assertLowerOrEquals(DEFAULT_MESSAGE, ref, value);
    }

    public void assertLowerOrEquals(String message, long ref, long value) {
        if (ref < value) {
            String msg = message == null ? DEFAULT_MESSAGE : message;
            AssertCommons.INSTANCE.throwException(msg);
        }
    }

    public void assertLowerOrEquals(Supplier<String> messageProducer, long ref, long value) {
        if (ref < value) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? DEFAULT_MESSAGE : messageProducer.get());
        }
    }

    public void assertLowerOrEquals(ErrorCode errorCode, long ref, long value) {
        if (ref < value) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertLowerOrEquals(float ref, float value) {
        this.assertLowerOrEquals(DEFAULT_MESSAGE, ref, value);
    }

    public void assertLowerOrEquals(String message, float ref, float value) {
        if (ref < value) {
            String msg = message == null ? DEFAULT_MESSAGE : message;
            AssertCommons.INSTANCE.throwException(msg);
        }
    }

    public void assertLowerOrEquals(Supplier<String> messageProducer, float ref, float value) {
        if (ref < value) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? DEFAULT_MESSAGE : messageProducer.get());
        }
    }

    public void assertLowerOrEquals(ErrorCode errorCode, float ref, float value) {
        if (ref < value) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertLowerOrEquals(double ref, double value) {
        this.assertLowerOrEquals(DEFAULT_MESSAGE, ref, value);
    }

    public void assertLowerOrEquals(String message, double ref, double value) {
        if (ref < value) {
            String msg = message == null ? DEFAULT_MESSAGE : message;
            AssertCommons.INSTANCE.throwException(msg);
        }
    }

    public void assertLowerOrEquals(Supplier<String> messageProducer, double ref, double value) {
        if (ref < value) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? DEFAULT_MESSAGE : messageProducer.get());
        }
    }

    public void assertLowerOrEquals(ErrorCode errorCode, double ref, double value) {
        if (ref < value) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertLowerOrEquals(Integer ref, Integer value) {
        this.assertLowerOrEquals(DEFAULT_MESSAGE, ref, value);
    }

    public void assertLowerOrEquals(String message, Integer ref, Integer value) {
        if (AssertLowerOrEquals.checkHigher(ref, value)) {
            String msg = message == null ? DEFAULT_MESSAGE : message;
            AssertCommons.INSTANCE.throwException(msg);
        }
    }

    public void assertLowerOrEquals(Supplier<String> messageProducer, Integer ref, Integer value) {
        if (AssertLowerOrEquals.checkHigher(ref, value)) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? DEFAULT_MESSAGE : messageProducer.get());
        }
    }

    public void assertLowerOrEquals(ErrorCode errorCode, Integer ref, Integer value) {
        if (AssertLowerOrEquals.checkHigher(ref, value)) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertLowerOrEquals(Long ref, Long value) {
        this.assertLowerOrEquals(DEFAULT_MESSAGE, ref, value);
    }

    public void assertLowerOrEquals(String message, Long ref, Long value) {
        if (AssertLowerOrEquals.checkHigher(ref, value)) {
            String msg = message == null ? DEFAULT_MESSAGE : message;
            AssertCommons.INSTANCE.throwException(msg);
        }
    }

    public void assertLowerOrEquals(Supplier<String> messageProducer, Long ref, Long value) {
        if (AssertLowerOrEquals.checkHigher(ref, value)) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? DEFAULT_MESSAGE : messageProducer.get());
        }
    }

    public void assertLowerOrEquals(ErrorCode errorCode, Long ref, Long value) {
        if (AssertLowerOrEquals.checkHigher(ref, value)) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertLowerOrEquals(Double ref, Double value) {
        this.assertLowerOrEquals(DEFAULT_MESSAGE, ref, value);
    }

    public void assertLowerOrEquals(String message, Double ref, Double value) {
        if (AssertLowerOrEquals.checkHigher(ref, value)) {
            String msg = message == null ? DEFAULT_MESSAGE : message;
            AssertCommons.INSTANCE.throwException(msg);
        }
    }

    public void assertLowerOrEquals(Supplier<String> messageProducer, Double ref, Double value) {
        if (AssertLowerOrEquals.checkHigher(ref, value)) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? DEFAULT_MESSAGE : messageProducer.get());
        }
    }

    public void assertLowerOrEquals(ErrorCode errorCode, Double ref, Double value) {
        if (AssertLowerOrEquals.checkHigher(ref, value)) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertLowerOrEquals(BigDecimal ref, BigDecimal value) {
        this.assertLowerOrEquals(DEFAULT_MESSAGE, ref, value);
    }

    public void assertLowerOrEquals(String message, BigDecimal ref, BigDecimal value) {
        if (AssertLowerOrEquals.checkHigher(ref, value)) {
            String msg = message == null ? DEFAULT_MESSAGE : message;
            AssertCommons.INSTANCE.throwException(msg);
        }
    }

    public void assertLowerOrEquals(Supplier<String> messageProducer, BigDecimal ref, BigDecimal value) {
        if (AssertLowerOrEquals.checkHigher(ref, value)) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? DEFAULT_MESSAGE : messageProducer.get());
        }
    }

    public void assertLowerOrEquals(ErrorCode errorCode, BigDecimal ref, BigDecimal value) {
        if (AssertLowerOrEquals.checkHigher(ref, value)) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    private static boolean checkHigher(Integer ref, Integer value) {
        return ref == null ? value != null : ref.compareTo(value) < 0;
    }

    private static boolean checkHigher(Long ref, Long value) {
        return ref == null ? value != null : ref.compareTo(value) < 0;
    }

    private static boolean checkHigher(Double ref, Double value) {
        return ref == null ? value != null : ref.compareTo(value) < 0;
    }

    private static boolean checkHigher(BigDecimal ref, BigDecimal value) {
        return ref == null ? value != null : ref.compareTo(value) < 0;
    }

    private AssertLowerOrEquals() {
    }
}

