/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.exceptions.asserts;

import io.inugami.api.exceptions.DefaultErrorCode;
import io.inugami.api.exceptions.ErrorCode;
import io.inugami.api.exceptions.ExceptionWithErrorCode;
import io.inugami.api.exceptions.asserts.AssertCommons;
import io.inugami.api.functionnals.VoidFunctionWithException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class AssertModel {
    public static final AssertModel INSTANCE = new AssertModel();

    public List<ErrorCode> checkModel(VoidFunctionWithException ... assertions) {
        return this.checkModel(Arrays.asList(assertions));
    }

    public List<ErrorCode> checkModel(List<VoidFunctionWithException> assertions) {
        ArrayList<ErrorCode> result = new ArrayList<ErrorCode>();
        if (assertions != null) {
            for (VoidFunctionWithException function : assertions) {
                try {
                    function.process();
                }
                catch (Exception e) {
                    if (e instanceof ExceptionWithErrorCode) {
                        result.add(((ExceptionWithErrorCode)e).getErrorCode());
                        continue;
                    }
                    result.add((ErrorCode)DefaultErrorCode.fromErrorCode((ErrorCode)DefaultErrorCode.buildUndefineError()).message(e.getMessage()).build());
                }
            }
        }
        return result;
    }

    public void assertModel(VoidFunctionWithException ... assertions) {
        this.assertModel(Arrays.asList(assertions));
    }

    public void assertModel(List<VoidFunctionWithException> assertions) {
        List<ErrorCode> errors = this.checkModel(assertions);
        if (!errors.isEmpty()) {
            AssertCommons.INSTANCE.throwException(errors);
        }
    }

    private AssertModel() {
    }
}

