/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.exceptions.asserts;

import io.inugami.api.exceptions.ErrorCode;
import io.inugami.api.exceptions.asserts.AssertCommons;
import java.util.function.Supplier;

public final class AssertNotEquals {
    private static final String ASSERT_NOT_EQUALS_DEEFAULT_MSG = "values mustn't be equals";
    public static final AssertNotEquals INSTANCE = new AssertNotEquals();

    public void assertNotEquals(Object ref, Object value) {
        this.assertNotEquals(ASSERT_NOT_EQUALS_DEEFAULT_MSG, ref, value);
    }

    public void assertNotEquals(String message, Object ref, Object value) {
        if (AssertNotEquals.checkObjectEquals(ref, value)) {
            String msg = message == null ? ASSERT_NOT_EQUALS_DEEFAULT_MSG : message;
            AssertCommons.INSTANCE.throwException(msg);
        }
    }

    public void assertNotEquals(Supplier<String> messageProducer, Object ref, Object value) {
        if (AssertNotEquals.checkObjectEquals(ref, value)) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? ASSERT_NOT_EQUALS_DEEFAULT_MSG : messageProducer.get());
        }
    }

    public void assertNotEquals(ErrorCode errorCode, Object ref, Object value) {
        if (AssertNotEquals.checkObjectEquals(ref, value)) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertNotEquals(int ref, int value) {
        this.assertNotEquals(ASSERT_NOT_EQUALS_DEEFAULT_MSG, ref, value);
    }

    public void assertNotEquals(String message, int ref, int value) {
        if (ref == value) {
            String msg = message == null ? ASSERT_NOT_EQUALS_DEEFAULT_MSG : message;
            AssertCommons.INSTANCE.throwException(msg);
        }
    }

    public void assertNotEquals(Supplier<String> messageProducer, int ref, int value) {
        if (ref == value) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? ASSERT_NOT_EQUALS_DEEFAULT_MSG : messageProducer.get());
        }
    }

    public void assertNotEquals(ErrorCode errorCode, int ref, int value) {
        if (ref == value) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertNotEquals(long ref, long value) {
        this.assertNotEquals(ASSERT_NOT_EQUALS_DEEFAULT_MSG, ref, value);
    }

    public void assertNotEquals(String message, long ref, long value) {
        if (ref == value) {
            String msg = message == null ? ASSERT_NOT_EQUALS_DEEFAULT_MSG : message;
            AssertCommons.INSTANCE.throwException(msg);
        }
    }

    public void assertNotEquals(Supplier<String> messageProducer, long ref, long value) {
        if (ref == value) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? ASSERT_NOT_EQUALS_DEEFAULT_MSG : messageProducer.get());
        }
    }

    public void assertNotEquals(ErrorCode errorCode, long ref, long value) {
        if (ref == value) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertNotEquals(float ref, float value) {
        this.assertNotEquals(ASSERT_NOT_EQUALS_DEEFAULT_MSG, ref, value);
    }

    public void assertNotEquals(String message, float ref, float value) {
        if (ref == value) {
            String msg = message == null ? ASSERT_NOT_EQUALS_DEEFAULT_MSG : message;
            AssertCommons.INSTANCE.throwException(msg);
        }
    }

    public void assertNotEquals(Supplier<String> messageProducer, float ref, float value) {
        if (ref == value) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? ASSERT_NOT_EQUALS_DEEFAULT_MSG : messageProducer.get());
        }
    }

    public void assertNotEquals(ErrorCode errorCode, float ref, float value) {
        if (ref == value) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertNotEquals(double ref, double value) {
        this.assertNotEquals(ASSERT_NOT_EQUALS_DEEFAULT_MSG, ref, value);
    }

    public void assertNotEquals(String message, double ref, double value) {
        if (ref == value) {
            String msg = message == null ? ASSERT_NOT_EQUALS_DEEFAULT_MSG : message;
            AssertCommons.INSTANCE.throwException(msg);
        }
    }

    public void assertNotEquals(Supplier<String> messageProducer, double ref, double value) {
        if (ref == value) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? ASSERT_NOT_EQUALS_DEEFAULT_MSG : messageProducer.get());
        }
    }

    public void assertNotEquals(ErrorCode errorCode, double ref, double value) {
        if (ref == value) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    private static boolean checkObjectEquals(Object ref, Object value) {
        return ref == null ? value == null : ref.equals(value);
    }

    private AssertNotEquals() {
    }
}

