/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.exceptions.asserts;

import io.inugami.api.exceptions.ErrorCode;
import io.inugami.api.exceptions.asserts.AssertCommons;
import java.util.function.Supplier;

public final class AssertNull {
    private static final String ASSERT_NULL_DEFAULT_MSG = "objects arguments must be null";
    private static final String ASSERT_NOT_NULL_DEFAULT_MSG = "this argument is required; it must not be null";
    public static final AssertNull INSTANCE = new AssertNull();

    public void assertNull(Object ... objects) {
        this.assertNull(ASSERT_NULL_DEFAULT_MSG, objects);
    }

    public void assertNull(String message, Object ... values) {
        if (values == null) {
            return;
        }
        for (Object item : values) {
            if (item == null) continue;
            AssertCommons.INSTANCE.throwException(message == null ? ASSERT_NULL_DEFAULT_MSG : message);
        }
    }

    public void assertNull(Supplier<String> messageProducer, Object ... values) {
        if (values == null) {
            return;
        }
        for (Object item : values) {
            if (item == null) continue;
            AssertCommons.INSTANCE.throwException(messageProducer == null ? ASSERT_NULL_DEFAULT_MSG : messageProducer.get());
        }
    }

    public void assertNull(ErrorCode errorCode, Object ... values) {
        if (values == null) {
            return;
        }
        for (Object item : values) {
            if (item == null) continue;
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertNotNull(Object ... objects) {
        this.assertNotNull(ASSERT_NOT_NULL_DEFAULT_MSG, objects);
    }

    public void assertNotNull(String message, Object ... values) {
        if (AssertNull.checkIfHasNull(values)) {
            AssertCommons.INSTANCE.throwException(message == null ? ASSERT_NOT_NULL_DEFAULT_MSG : message);
        }
    }

    public void assertNotNull(Supplier<String> messageProducer, Object ... values) {
        if (AssertNull.checkIfHasNull(values)) {
            AssertCommons.INSTANCE.throwException(messageProducer == null ? ASSERT_NULL_DEFAULT_MSG : messageProducer.get());
        }
    }

    public void assertNotNull(ErrorCode errorCode, Object ... values) {
        if (AssertNull.checkIfHasNull(values)) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    private static boolean checkIfHasNull(Object ... values) {
        if (values == null) {
            return true;
        }
        for (Object value : values) {
            if (value != null) continue;
            return true;
        }
        return false;
    }

    private AssertNull() {
    }
}

