/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.exceptions.asserts;

import io.inugami.api.exceptions.ErrorCode;
import io.inugami.api.exceptions.MessagesFormatter;
import io.inugami.api.exceptions.asserts.AssertCommons;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Pattern;

public final class AssertRegex {
    private static final String NOT_MATCH = "current value {0} doesn't match with {1}";
    private static final String MATCH = "current value {0} should not match with {1}";
    private static final String FIND = "current value {0} doesn't find any result with {1}";
    private static final String NOT_FIND = "current value {0} should have any result with {1}";
    public static final String REGEX_IS_REQUIRED = "regex is required";
    public static final AssertRegex INSTANCE = new AssertRegex();

    public void assertRegexMatch(Pattern regex, String value) {
        this.assertRegexMatch(() -> MessagesFormatter.format((String)NOT_MATCH, (Object[])new Object[]{value, regex}), regex, value);
    }

    public void assertRegexMatch(String message, Pattern regex, String value) {
        Objects.requireNonNull(regex, REGEX_IS_REQUIRED);
        if (value == null || !regex.matcher(value).matches()) {
            AssertCommons.INSTANCE.throwException(message == null ? MessagesFormatter.format((String)NOT_MATCH, (Object[])new Object[]{value, regex}) : message);
        }
    }

    public void assertRegexMatch(Supplier<String> messageProducer, Pattern regex, String value) {
        Objects.requireNonNull(regex, REGEX_IS_REQUIRED);
        if (value == null || !regex.matcher(value).matches()) {
            AssertCommons.INSTANCE.throwException(messageProducer.get());
        }
    }

    public void assertRegexMatch(ErrorCode errorCode, Pattern regex, String value) {
        Objects.requireNonNull(regex, REGEX_IS_REQUIRED);
        if (value == null || !regex.matcher(value).matches()) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertRegexMatch(String regex, String value) {
        this.assertRegexMatch(() -> MessagesFormatter.format((String)NOT_MATCH, (Object[])new Object[]{value, regex}), regex, value);
    }

    public void assertRegexMatch(String message, String regex, String value) {
        Objects.requireNonNull(regex, REGEX_IS_REQUIRED);
        if (value == null || !AssertRegex.match(regex, value)) {
            AssertCommons.INSTANCE.throwException(message == null ? MessagesFormatter.format((String)NOT_MATCH, (Object[])new Object[]{value, regex}) : message);
        }
    }

    public void assertRegexMatch(Supplier<String> messageProducer, String regex, String value) {
        Objects.requireNonNull(regex, REGEX_IS_REQUIRED);
        if (value == null || !AssertRegex.match(regex, value)) {
            AssertCommons.INSTANCE.throwException(messageProducer.get());
        }
    }

    public void assertRegexMatch(ErrorCode errorCode, String regex, String value) {
        Objects.requireNonNull(regex, REGEX_IS_REQUIRED);
        if (value == null || !AssertRegex.match(regex, value)) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertRegexNotMatch(Pattern regex, String value) {
        this.assertRegexNotMatch(() -> MessagesFormatter.format((String)MATCH, (Object[])new Object[]{value, regex}), regex, value);
    }

    public void assertRegexNotMatch(String message, Pattern regex, String value) {
        Objects.requireNonNull(regex, REGEX_IS_REQUIRED);
        if (value == null || regex.matcher(value).matches()) {
            AssertCommons.INSTANCE.throwException(message == null ? MessagesFormatter.format((String)MATCH, (Object[])new Object[]{value, regex}) : message);
        }
    }

    public void assertRegexNotMatch(Supplier<String> messageProducer, Pattern regex, String value) {
        Objects.requireNonNull(regex, REGEX_IS_REQUIRED);
        if (value == null || regex.matcher(value).matches()) {
            AssertCommons.INSTANCE.throwException(messageProducer.get());
        }
    }

    public void assertRegexNotMatch(ErrorCode errorCode, Pattern regex, String value) {
        Objects.requireNonNull(regex, REGEX_IS_REQUIRED);
        if (value == null || regex.matcher(value).matches()) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertRegexNotMatch(String regex, String value) {
        this.assertRegexNotMatch(() -> MessagesFormatter.format((String)MATCH, (Object[])new Object[]{value, regex}), regex, value);
    }

    public void assertRegexNotMatch(String message, String regex, String value) {
        Objects.requireNonNull(regex, REGEX_IS_REQUIRED);
        if (value == null || AssertRegex.match(regex, value)) {
            AssertCommons.INSTANCE.throwException(message == null ? MessagesFormatter.format((String)MATCH, (Object[])new Object[]{value, regex}) : message);
        }
    }

    public void assertRegexNotMatch(Supplier<String> messageProducer, String regex, String value) {
        Objects.requireNonNull(regex, REGEX_IS_REQUIRED);
        if (value == null || AssertRegex.match(regex, value)) {
            AssertCommons.INSTANCE.throwException(messageProducer.get());
        }
    }

    public void assertRegexNotMatch(ErrorCode errorCode, String regex, String value) {
        Objects.requireNonNull(regex, REGEX_IS_REQUIRED);
        if (value == null || AssertRegex.match(regex, value)) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertRegexFind(Pattern regex, String value) {
        this.assertRegexFind(() -> MessagesFormatter.format((String)FIND, (Object[])new Object[]{value, regex}), regex, value);
    }

    public void assertRegexFind(String message, Pattern regex, String value) {
        Objects.requireNonNull(regex, REGEX_IS_REQUIRED);
        if (value == null || !regex.matcher(value).find()) {
            AssertCommons.INSTANCE.throwException(message == null ? MessagesFormatter.format((String)FIND, (Object[])new Object[]{value, regex}) : message);
        }
    }

    public void assertRegexFind(Supplier<String> messageProducer, Pattern regex, String value) {
        Objects.requireNonNull(regex, REGEX_IS_REQUIRED);
        if (value == null || !regex.matcher(value).find()) {
            AssertCommons.INSTANCE.throwException(messageProducer.get());
        }
    }

    public void assertRegexFind(ErrorCode errorCode, Pattern regex, String value) {
        Objects.requireNonNull(regex, REGEX_IS_REQUIRED);
        if (value == null || !regex.matcher(value).find()) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertRegexFind(String regex, String value) {
        this.assertRegexFind(() -> MessagesFormatter.format((String)FIND, (Object[])new Object[]{value, regex}), regex, value);
    }

    public void assertRegexFind(String message, String regex, String value) {
        Objects.requireNonNull(regex, REGEX_IS_REQUIRED);
        if (value == null || !AssertRegex.find(regex, value)) {
            AssertCommons.INSTANCE.throwException(message == null ? MessagesFormatter.format((String)FIND, (Object[])new Object[]{value, regex}) : message);
        }
    }

    public void assertRegexFind(Supplier<String> messageProducer, String regex, String value) {
        Objects.requireNonNull(regex, REGEX_IS_REQUIRED);
        if (value == null || !AssertRegex.find(regex, value)) {
            AssertCommons.INSTANCE.throwException(messageProducer.get());
        }
    }

    public void assertRegexFind(ErrorCode errorCode, String regex, String value) {
        Objects.requireNonNull(regex, REGEX_IS_REQUIRED);
        if (value == null || !AssertRegex.find(regex, value)) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertRegexNotFind(Pattern regex, String value) {
        this.assertRegexNotFind(() -> MessagesFormatter.format((String)NOT_FIND, (Object[])new Object[]{value, regex}), regex, value);
    }

    public void assertRegexNotFind(String message, Pattern regex, String value) {
        Objects.requireNonNull(regex, REGEX_IS_REQUIRED);
        if (value == null || regex.matcher(value).find()) {
            AssertCommons.INSTANCE.throwException(message == null ? MessagesFormatter.format((String)NOT_FIND, (Object[])new Object[]{value, regex}) : message);
        }
    }

    public void assertRegexNotFind(Supplier<String> messageProducer, Pattern regex, String value) {
        Objects.requireNonNull(regex, REGEX_IS_REQUIRED);
        if (value == null || regex.matcher(value).find()) {
            AssertCommons.INSTANCE.throwException(messageProducer.get());
        }
    }

    public void assertRegexNotFind(ErrorCode errorCode, Pattern regex, String value) {
        Objects.requireNonNull(regex, REGEX_IS_REQUIRED);
        if (value == null || regex.matcher(value).find()) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    public void assertRegexNotFind(String regex, String value) {
        this.assertRegexNotFind(() -> MessagesFormatter.format((String)NOT_FIND, (Object[])new Object[]{value, regex}), regex, value);
    }

    public void assertRegexNotFind(String message, String regex, String value) {
        Objects.requireNonNull(regex, REGEX_IS_REQUIRED);
        if (value == null || AssertRegex.find(regex, value)) {
            AssertCommons.INSTANCE.throwException(message == null ? MessagesFormatter.format((String)NOT_FIND, (Object[])new Object[]{value, regex}) : message);
        }
    }

    public void assertRegexNotFind(Supplier<String> messageProducer, String regex, String value) {
        Objects.requireNonNull(regex, REGEX_IS_REQUIRED);
        if (value == null || AssertRegex.find(regex, value)) {
            AssertCommons.INSTANCE.throwException(messageProducer.get());
        }
    }

    public void assertRegexNotFind(ErrorCode errorCode, String regex, String value) {
        Objects.requireNonNull(regex, REGEX_IS_REQUIRED);
        if (value == null || AssertRegex.find(regex, value)) {
            AssertCommons.INSTANCE.throwException(errorCode);
        }
    }

    private static boolean match(String regex, String value) {
        Pattern pattern = Pattern.compile(regex, 2);
        return pattern.matcher(value).matches();
    }

    private static boolean find(String regex, String value) {
        Pattern pattern = Pattern.compile(regex, 2);
        return pattern.matcher(value).find();
    }

    private AssertRegex() {
    }
}

