/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.exceptions.services;

import io.inugami.api.exceptions.ErrorCode;
import io.inugami.api.exceptions.TechnicalException;

public class ConnectorException
extends TechnicalException {
    private static final long serialVersionUID = 389031756408740003L;
    private final int code;
    private transient Object result;

    public ConnectorException(int code, String message, Throwable cause) {
        super(code, message, cause);
        this.code = code;
    }

    public ConnectorException(int code, String message) {
        super(code, message, null);
        this.code = code;
    }

    public ConnectorException() {
        this.code = 500;
    }

    public ConnectorException(ErrorCode errorCode, Throwable cause, String message, Object ... values) {
        super(errorCode, cause, message, values);
        this.code = errorCode == null ? 500 : errorCode.getStatusCode();
    }

    public ConnectorException(ErrorCode errorCode, Throwable cause) {
        super(errorCode, cause);
        this.code = errorCode == null ? 500 : errorCode.getStatusCode();
    }

    public ConnectorException(ErrorCode errorCode) {
        super(errorCode);
        this.code = errorCode == null ? 500 : errorCode.getStatusCode();
    }

    public ConnectorException(String message, Object ... values) {
        super(message, values);
        this.code = 500;
    }

    public ConnectorException(String message, Throwable cause) {
        super(message, cause);
        this.code = 500;
    }

    public ConnectorException(String message) {
        super(message);
        this.code = 500;
    }

    public ConnectorException(Throwable cause, String message, Object ... values) {
        super(cause, message, values);
        this.code = 500;
    }

    public ConnectorException(Throwable cause) {
        super(cause);
        this.code = 500;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public int getCode() {
        return this.code;
    }

    public Object getResult() {
        return this.result;
    }
}

