/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.exceptions.services;

import io.inugami.api.exceptions.MessagesFormatter;
import io.inugami.api.exceptions.TechnicalException;
import io.inugami.api.models.events.GenericEvent;
import io.inugami.api.models.events.TargetConfig;
import java.util.Optional;

public class EventProcessException
extends TechnicalException {
    private static final long serialVersionUID = -3327417822907598222L;
    public static final int ERR_CODE = 500;
    private final GenericEvent event;
    private final TargetConfig target;

    protected EventProcessException(GenericEvent event, TargetConfig target, int code, String message, Throwable cause) {
        super(code, message, cause);
        this.event = event;
        this.target = target;
    }

    public EventProcessException() {
        this(null, null, 500, null, null);
    }

    public EventProcessException(String message, Throwable cause) {
        this(null, null, 500, message, cause);
    }

    public EventProcessException(GenericEvent event, TargetConfig target, String message, Throwable cause) {
        this(event, target, 500, message, cause);
    }

    public EventProcessException(String message, Object ... values) {
        this(null, null, 500, MessagesFormatter.format((String)message, (Object[])values), null);
    }

    public EventProcessException(Throwable cause, String message, Object ... values) {
        this(null, null, 500, MessagesFormatter.format((String)message, (Object[])values), cause);
    }

    public EventProcessException(String message) {
        this(null, null, 500, message, null);
    }

    public EventProcessException(Throwable cause) {
        this(null, null, 500, null, cause);
    }

    public Optional<GenericEvent> getEvent() {
        Optional<GenericEvent> result = Optional.empty();
        if (this.event != null) {
            result = Optional.of(this.event);
        }
        return result;
    }

    public Optional<TargetConfig> getTarget() {
        Optional<TargetConfig> result = Optional.empty();
        if (this.target != null) {
            result = Optional.of(this.target);
        }
        return result;
    }
}

