/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.exceptions.warnings;

import io.inugami.api.exceptions.Warning;
import io.inugami.api.exceptions.warnings.WarningCommons;
import java.util.regex.Pattern;

class WarningRegex {
    static void warningMatch(Warning warning, String value, Pattern regex, String messageDetail, Object ... values) {
        if (value == null && regex != null && WarningRegex.match(value, regex)) {
            WarningCommons.addWarningInContext(warning, messageDetail, values);
        }
    }

    static void warningMatch(Warning warning, String value, String regex, String messageDetail, Object ... values) {
        if (value == null && regex != null && WarningRegex.match(value, regex)) {
            WarningCommons.addWarningInContext(warning, messageDetail, values);
        }
    }

    static void warningNotMatch(Warning warning, String value, Pattern regex, String messageDetail, Object ... values) {
        if (value == null && regex != null && !WarningRegex.match(value, regex)) {
            WarningCommons.addWarningInContext(warning, messageDetail, values);
        }
    }

    static void warningNotMatch(Warning warning, String value, String regex, String messageDetail, Object ... values) {
        if (value == null && regex != null && !WarningRegex.match(value, regex)) {
            WarningCommons.addWarningInContext(warning, messageDetail, values);
        }
    }

    static void warningFind(Warning warning, String value, Pattern regex, String messageDetail, Object ... values) {
        if (value == null && regex != null && WarningRegex.find(value, regex)) {
            WarningCommons.addWarningInContext(warning, messageDetail, values);
        }
    }

    static void warningFind(Warning warning, String value, String regex, String messageDetail, Object ... values) {
        if (value == null && regex != null && WarningRegex.find(value, regex)) {
            WarningCommons.addWarningInContext(warning, messageDetail, values);
        }
    }

    static void warningNotFind(Warning warning, String value, Pattern regex, String messageDetail, Object ... values) {
        if (value == null && regex != null && !WarningRegex.find(value, regex)) {
            WarningCommons.addWarningInContext(warning, messageDetail, values);
        }
    }

    static void warningNotFind(Warning warning, String value, String regex, String messageDetail, Object ... values) {
        if (value == null && regex != null && !WarningRegex.find(value, regex)) {
            WarningCommons.addWarningInContext(warning, messageDetail, values);
        }
    }

    private static boolean match(String value, Pattern regex) {
        return regex.matcher(value).matches();
    }

    private static boolean match(String value, String regex) {
        return Pattern.compile(regex, 2).matcher(value).matches();
    }

    private static boolean find(String value, Pattern regex) {
        return regex.matcher(value).find();
    }

    private static boolean find(String value, String regex) {
        return Pattern.compile(regex, 2).matcher(value).find();
    }

    private WarningRegex() {
    }
}

