/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.loggers;

import io.inugami.api.exceptions.FatalException;
import io.inugami.api.models.Rgb;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.function.Function;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AsciiRenderer {
    private static final Logger DEBUG = LoggerFactory.getLogger((String)"DEBUGLOG");
    private static final Function<Rgb, String> DEFAULT_MAPPER = color -> {
        String result = "#";
        if (color.getColor() == 0) {
            result = "#";
        } else if (color.getAvg() == -1) {
            result = " ";
        } else if (color.getAvg() < 5) {
            result = "@";
        } else if (color.getAvg() < 48) {
            result = "O";
        } else if (color.getAvg() < 80) {
            result = "%";
        }
        return result;
    };

    static String renderImageAscii(URL file, Function<Rgb, String> asciiMapper) {
        BufferedImage image = null;
        try {
            image = ImageIO.read(file);
        }
        catch (IOException e) {
            DEBUG.error(e.getMessage(), (Throwable)e);
            throw new FatalException(e.getMessage(), e);
        }
        Function<Rgb, String> mapper = asciiMapper == null ? DEFAULT_MAPPER : asciiMapper;
        StringBuilder buffer = new StringBuilder();
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                buffer.append(mapper.apply(Rgb.builder().addColor(image.getRGB(x, y)).build()));
            }
            buffer.append('\n');
        }
        return buffer.toString();
    }

    private AsciiRenderer() {
    }
}

