/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.loggers;

import io.inugami.api.loggers.AsciiRenderer;
import io.inugami.api.models.Rgb;
import java.net.URL;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public final class Loggers {
    public static final String APPLICATION_NAME = "APPLICATION";
    public static final Logger APPLICATION = LoggerFactory.getLogger((String)"APPLICATION");
    public static final String ALERTING_NAME = "ALERTING";
    public static final Logger ALERTING = LoggerFactory.getLogger((String)"ALERTING");
    public static final String ALERTS_EVENT_NAME = "ALERTS_EVENT";
    public static final Logger ALERTS_EVENT = LoggerFactory.getLogger((String)"ALERTS_EVENT");
    public static final String JAVA_SCRIPT_NAME = "JAVA_SCRIPT";
    public static final Logger JAVA_SCRIPT = LoggerFactory.getLogger((String)"JAVA_SCRIPT");
    public static final String CACHE_NAME = "CACHE";
    public static final Logger CACHE = LoggerFactory.getLogger((String)"CACHE");
    public static final String CONFIG_NAME = "CONFIG";
    public static final Logger CONFIG = LoggerFactory.getLogger((String)"CONFIG");
    public static final String CHRONOLOG_NAME = "CHRONOLOG";
    public static final Logger CHRONOLOG = LoggerFactory.getLogger((String)"CHRONOLOG");
    public static final String PLUGINS_NAME = "PLUGINS";
    public static final Logger PLUGINS = LoggerFactory.getLogger((String)"PLUGINS");
    public static final String EVENTSLOG_NAME = "EVENTSLOG";
    public static final Logger EVENTSLOG = LoggerFactory.getLogger((String)"EVENTSLOG");
    public static final String SSELOG_NAME = "SSELOG";
    public static final Logger SSELOG = LoggerFactory.getLogger((String)"SSELOG");
    public static final String XLLOG_NAME = "XLLOG";
    public static final Logger XLLOG = LoggerFactory.getLogger((String)"XLLOG");
    public static final String INIT_NAME = "INITIALIZE";
    public static final Logger INIT = LoggerFactory.getLogger((String)"INITIALIZE");
    public static final String PROCESSOR_NAME = "PROCESSOR";
    public static final Logger PROCESSOR = LoggerFactory.getLogger((String)"PROCESSOR");
    public static final String DEBUGLOG_NAME = "DEBUGLOG";
    public static final Logger DEBUG = LoggerFactory.getLogger((String)"DEBUGLOG");
    public static final String PROVIDER_NAME = "PROVIDER";
    public static final Logger PROVIDER = LoggerFactory.getLogger((String)"PROVIDER");
    public static final String HANDLER_NAME = "HANDLER";
    public static final Logger HANDLER = LoggerFactory.getLogger((String)"HANDLER");
    public static final String IO_NAME = "IO_ACCESS";
    public static final Logger IO = LoggerFactory.getLogger((String)"IO_ACCESS");
    public static final String SSE_NAME = "SSE";
    public static final Logger SSE = LoggerFactory.getLogger((String)"SSE");
    public static final String METRICS_NAME = "METRICS";
    public static final Logger METRICS = LoggerFactory.getLogger((String)"METRICS");
    public static final String EVENTS_NAME = "EVENTS";
    public static final Logger EVENTS = LoggerFactory.getLogger((String)"EVENTS");
    public static final String SYSTEM_NAME = "SYSTEM";
    public static final Logger SYSTEM = LoggerFactory.getLogger((String)"SYSTEM");
    public static final String SECURITY_NAME = "SECURITY";
    public static final Logger SECURITY = LoggerFactory.getLogger((String)"SECURITY");
    public static final String SCRIPTS_NAME = "SCRIPTS";
    public static final Logger SCRIPTS = LoggerFactory.getLogger((String)"SCRIPTS");
    public static final String ALERTS_SENDER_NAME = "ALERTS_SENDER";
    public static final Logger ALERTS_SENDER = LoggerFactory.getLogger((String)"ALERTS_SENDER");
    public static final String HEALTH_NAME = "HEALTH";
    public static final Logger HEALTH = LoggerFactory.getLogger((String)"HEALTH");
    public static final String TASK_NAME = "TASK";
    public static final Logger TASK = LoggerFactory.getLogger((String)"TASK");
    public static final String REST_NAME = "REST";
    public static final Logger REST = LoggerFactory.getLogger((String)"REST");
    public static final String IOLOG_NAME = "IOLOG";
    public static final Logger IOLOG = LoggerFactory.getLogger((String)"IOLOG");
    public static final String PARTNERLOG_NAME = "PARTNERLOG";
    public static final Logger PARTNERLOG = LoggerFactory.getLogger((String)"PARTNERLOG");
    public static final String KPI_NAME = "KPI";
    public static final Logger KPI = LoggerFactory.getLogger((String)"KPI");
    public static final String LOG_INITIALIZER_NAME = "LOG_INITIALIZER";
    public static final Logger LOG_INITIALIZER = LoggerFactory.getLogger((String)"LOG_INITIALIZER");

    public static void log(Logger logger, Level level, Supplier<String> message, Object ... values) {
        if (logger == null || level == null || message == null) {
            return;
        }
        if (Loggers.loggerEnabled(logger, level)) {
            switch (level) {
                case TRACE: {
                    logger.trace(message.get(), values);
                    break;
                }
                case DEBUG: {
                    logger.debug(message.get(), values);
                    break;
                }
                case INFO: {
                    logger.info(message.get(), values);
                    break;
                }
                case WARN: {
                    logger.warn(message.get(), values);
                    break;
                }
                case ERROR: {
                    logger.error(message.get(), values);
                }
            }
        }
    }

    public static boolean loggerEnabled(Logger logger, Level level) {
        boolean result = false;
        switch (level) {
            case TRACE: {
                result = logger.isTraceEnabled();
                break;
            }
            case DEBUG: {
                result = logger.isDebugEnabled();
                break;
            }
            case INFO: {
                result = logger.isInfoEnabled();
                break;
            }
            case WARN: {
                result = logger.isWarnEnabled();
                break;
            }
            case ERROR: {
                result = logger.isErrorEnabled();
            }
        }
        return result;
    }

    public static void imageAscii(URL file) {
        Loggers.imageAscii(file, APPLICATION, null);
    }

    public static void imageAscii(URL file, Logger logger) {
        Loggers.imageAscii(file, logger, null);
    }

    public static void imageAscii(URL file, Function<Rgb, String> asciiMapper) {
        Loggers.imageAscii(file, APPLICATION, asciiMapper);
    }

    public static void imageAscii(URL file, Logger logger, Function<Rgb, String> asciiMapper) {
        String data = Loggers.renderImageAscii(file, asciiMapper);
        logger.info("\n{}", (Object)data);
    }

    public static String renderImageAscii(URL file) {
        return Loggers.renderImageAscii(file, null);
    }

    public static String renderImageAscii(URL file, Function<Rgb, String> asciiMapper) {
        return AsciiRenderer.renderImageAscii(file, asciiMapper);
    }

    private Loggers() {
    }
}

