/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.loggers.mdc.initializer;

import io.inugami.api.loggers.Loggers;
import io.inugami.api.loggers.mdc.initializer.MdcInitializerSpi;
import io.inugami.api.monitoring.MdcService;
import io.inugami.api.spi.SpiLoader;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MdcInitializer {
    public static void initialize() {
        List<MdcInitializerSpi> initializers = SpiLoader.getInstance().loadSpiServicesByPriority(MdcInitializerSpi.class);
        Map<String, Serializable> mdcContext = MdcInitializer.loadValues(initializers);
        MdcService mdcService = MdcService.getInstance();
        for (Map.Entry<String, Serializable> entry : mdcContext.entrySet()) {
            mdcService.setMdc(entry.getKey(), entry.getValue());
        }
        Loggers.LOG_INITIALIZER.info("initialize log MDC");
        mdcService.clear();
    }

    private static Map<String, Serializable> loadValues(List<MdcInitializerSpi> initializers) {
        LinkedHashMap<String, Serializable> result = new LinkedHashMap<String, Serializable>();
        for (MdcInitializerSpi initializer : initializers) {
            result.putAll(initializer.getDefaultValue());
        }
        return result;
    }

    private MdcInitializer() {
    }
}

