/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.mapping.events;

import io.inugami.api.functionnals.ApplyIfNotNullAndSameType;
import io.inugami.api.mapping.Mapper;
import io.inugami.api.mapping.events.ListAlertsMapper;
import io.inugami.api.mapping.events.ListProcessorMapper;
import io.inugami.api.models.events.TargetConfig;
import io.inugami.api.models.events.TargetConfigBuilder;
import io.inugami.api.tools.NashornTools;
import java.util.List;
import java.util.function.Function;
import javax.script.Bindings;

public class TargetMapper
implements Mapper<TargetConfig, Object>,
ApplyIfNotNullAndSameType {
    public TargetConfig mapping(Object data) {
        return data instanceof Bindings ? this.process((Bindings)data) : null;
    }

    private TargetConfig process(Bindings data) {
        TargetConfigBuilder builder = new TargetConfigBuilder();
        ListProcessorMapper processorsMapper = new ListProcessorMapper();
        ListAlertsMapper alertsMapper = new ListAlertsMapper();
        Function mapString = this.buildStringMapper();
        Function<Object, List> mapProcessors = v -> NashornTools.isArray(v) ? processorsMapper.mapping(NashornTools.convertToList(v)) : null;
        Function<Object, List> mapAlerts = v -> NashornTools.isArray(v) ? alertsMapper.mapping(NashornTools.convertToList(v)) : null;
        this.ifNotNullAndSameType(data.get("name"), mapString, builder::addName);
        this.ifNotNullAndSameType(data.get("from"), mapString, builder::addFrom);
        this.ifNotNullAndSameType(data.get("until"), mapString, builder::addUntil);
        this.ifNotNullAndSameType(data.get("provider"), mapString, builder::addProvider);
        this.ifNotNullAndSameType(data.get("mapper"), mapString, builder::addMapper);
        this.ifNotNullAndSameType(data.get("query"), mapString, builder::addQuery);
        this.ifNotNullAndSameType(data.get("processors"), mapProcessors, builder::addProcessors);
        this.ifNotNullAndSameType(data.get("alertings"), mapAlerts, builder::addAlertings);
        return builder.build();
    }
}

