/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.marshalling;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import io.inugami.api.marshalling.ClassSerializer;
import io.inugami.api.marshalling.FieldSerializer;
import io.inugami.api.marshalling.JsonMarshallerSpi;
import io.inugami.api.marshalling.MethodSerializer;
import io.inugami.api.marshalling.ModuleRegisterSpi;
import io.inugami.api.spi.SpiLoader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class JsonMarshaller {
    private static final SimpleModule INUGAMI_MODULE = JsonMarshaller.initInugamiModule();
    private static final List<Module> EXTERNAL_MODULES = JsonMarshaller.loadExternalModules();
    private final ObjectMapper defaultObjectMapper;
    private final ObjectMapper indentedObjectMapper;
    private static final JsonMarshaller INSTANCE = new JsonMarshaller();

    private static List<Module> loadExternalModules() {
        List moduleLoaders = SpiLoader.getInstance().loadSpiService(ModuleRegisterSpi.class);
        return moduleLoaders.stream().map(ModuleRegisterSpi::extractModules).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static SimpleModule initInugamiModule() {
        SimpleModule module = new SimpleModule();
        module.addSerializer(Method.class, (JsonSerializer)new MethodSerializer(Method.class));
        module.addSerializer(Class.class, (JsonSerializer)new ClassSerializer(Class.class));
        module.addSerializer(Field.class, (JsonSerializer)new FieldSerializer(Field.class));
        return module;
    }

    public static JsonMarshaller getInstance() {
        return INSTANCE;
    }

    private JsonMarshaller() {
        DefaultObjectMapperBuilder defaultBuilder = new DefaultObjectMapperBuilder();
        JsonMarshallerSpi builder = SpiLoader.getInstance().loadSpiServiceByPriority(JsonMarshallerSpi.class, defaultBuilder);
        ObjectMapper mapper = builder.buildObjectMapper();
        if (mapper == null) {
            mapper = defaultBuilder.buildObjectMapper();
        }
        this.defaultObjectMapper = mapper;
        ObjectMapper indentedMapper = builder.buildIndentedObjectMapper();
        if (indentedMapper == null) {
            indentedMapper = defaultBuilder.buildIndentedObjectMapper();
        }
        this.indentedObjectMapper = indentedMapper;
    }

    public ObjectMapper getDefaultObjectMapper() {
        return this.defaultObjectMapper;
    }

    public ObjectMapper getIndentedObjectMapper() {
        return this.indentedObjectMapper;
    }

    private static class DefaultObjectMapperBuilder
    implements JsonMarshallerSpi {
        private DefaultObjectMapperBuilder() {
        }

        @Override
        public ObjectMapper buildObjectMapper() {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.findAndRegisterModules();
            objectMapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
            objectMapper.registerModule((Module)new ParameterNamesModule()).registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule());
            for (Module module : EXTERNAL_MODULES) {
                objectMapper.registerModule(module);
            }
            objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            objectMapper.registerModule((Module)INUGAMI_MODULE);
            return objectMapper;
        }

        @Override
        public ObjectMapper buildIndentedObjectMapper() {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
            objectMapper.findAndRegisterModules();
            objectMapper.enable(SerializationFeature.INDENT_OUTPUT).configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
            objectMapper.registerModule((Module)new ParameterNamesModule()).registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule());
            for (Module module : EXTERNAL_MODULES) {
                objectMapper.registerModule(module);
            }
            objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            objectMapper.registerModule((Module)INUGAMI_MODULE);
            return objectMapper;
        }
    }
}

