/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.marshalling;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.inugami.api.models.JsonBuilder;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;

public class MethodSerializer
extends StdSerializer<Method> {
    protected MethodSerializer(Class<Method> t) {
        super(t);
    }

    public void serialize(Method method, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (method == null) {
            jsonGenerator.writeNull();
        } else {
            jsonGenerator.writeString(MethodSerializer.renderAsJson(method));
        }
    }

    private static String renderAsJson(Method method) {
        JsonBuilder json = new JsonBuilder();
        ((JsonBuilder)((JsonBuilder)((JsonBuilder)((JsonBuilder)json.write(method.getReturnType() == null ? "void" : method.getReturnType().getName())).write(" ")).write(method.getDeclaringClass().getName())).write(method.getName())).openTuple();
        Parameter[] params = method.getParameters();
        int nbParams = params.length;
        for (int i = 0; i < nbParams; ++i) {
            json.write(params[i].getClass().getName());
            if (i >= nbParams - 1) continue;
            json.addSeparator();
        }
        json.closeTuple();
        return json.toString();
    }
}

