/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.models;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.io.Serializable;

@XStreamAlias(value="gav")
public class Gav
implements Serializable {
    private static final long serialVersionUID = -6931854882445061439L;
    public static final String SEPARATOR = ":";
    @XStreamAsAttribute
    private String groupId;
    @XStreamAsAttribute
    private String artifactId;
    @XStreamAsAttribute
    private String version;
    @XStreamAsAttribute
    private String qualifier;

    public boolean equalsWithoutVersion(Object obj) {
        boolean result;
        boolean bl = result = this == obj;
        if (!result && obj != null && obj instanceof Gav) {
            Gav other = (Gav)obj;
            result = this.groupId.equals(other.getGroupId()) && this.artifactId.equals(other.getArtifactId());
        }
        return result;
    }

    public String getHash() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.groupId);
        sb.append(SEPARATOR);
        sb.append(this.artifactId);
        sb.append(SEPARATOR);
        sb.append(this.version);
        if (this.qualifier != null) {
            sb.append(SEPARATOR);
            sb.append(this.qualifier);
        }
        return sb.toString();
    }

    public static GavBuilder builder() {
        return new GavBuilder();
    }

    public GavBuilder toBuilder() {
        return new GavBuilder().groupId(this.groupId).artifactId(this.artifactId).version(this.version).qualifier(this.qualifier);
    }

    public String toString() {
        return "Gav(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", qualifier=" + this.getQualifier() + ")";
    }

    public Gav(String groupId, String artifactId, String version, String qualifier) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.qualifier = qualifier;
    }

    public Gav() {
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Gav)) {
            return false;
        }
        Gav other = (Gav)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$qualifier = this.getQualifier();
        String other$qualifier = other.getQualifier();
        return !(this$qualifier == null ? other$qualifier != null : !this$qualifier.equals(other$qualifier));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Gav;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $qualifier = this.getQualifier();
        result = result * 59 + ($qualifier == null ? 43 : $qualifier.hashCode());
        return result;
    }

    public static class GavBuilder {
        private String groupId;
        private String artifactId;
        private String version;
        private String qualifier;

        public GavBuilder addHash(String value) {
            if (value != null) {
                String[] parts = value.split(Gav.SEPARATOR);
                this.groupId(parts[0]);
                if (parts.length > 1) {
                    this.artifactId(parts[1]);
                }
                if (parts.length > 2) {
                    this.version(parts[2]);
                }
                if (parts.length > 3) {
                    this.qualifier(parts[3]);
                }
            }
            return this;
        }

        GavBuilder() {
        }

        public GavBuilder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public GavBuilder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public GavBuilder version(String version) {
            this.version = version;
            return this;
        }

        public GavBuilder qualifier(String qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        public Gav build() {
            return new Gav(this.groupId, this.artifactId, this.version, this.qualifier);
        }

        public String toString() {
            return "Gav.GavBuilder(groupId=" + this.groupId + ", artifactId=" + this.artifactId + ", version=" + this.version + ", qualifier=" + this.qualifier + ")";
        }
    }
}

