/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.models;

import io.inugami.api.models.data.basic.Json;
import io.inugami.api.models.data.basic.JsonObject;
import java.util.List;

public class JsonBuilder {
    public static final char SEPARATOR_CHAR = ',';
    public static final String VALUE_NULL = "null";
    public static final String SPACE = " ";
    private static final String DOT = ".";
    private static final String DOUBLE_DOT = ":";
    private final StringBuilder buffer = new StringBuilder();

    public <E extends JsonBuilder> E returnInstance() {
        return (E)this;
    }

    public <E extends JsonBuilder> E writeFunction(String name, String ... params) {
        this.buffer.append(" function ");
        this.buffer.append(name);
        this.openTuple();
        for (int i = 0; i < params.length; ++i) {
            if (i != 0) {
                this.addSeparator();
            }
            this.buffer.append(params[i]);
        }
        this.closeTuple();
        return this.returnInstance();
    }

    public <E extends JsonBuilder> E addReturnKeyword() {
        this.buffer.append("return ");
        return this.returnInstance();
    }

    public <E extends JsonBuilder> E openObject() {
        this.buffer.append("{");
        return this.returnInstance();
    }

    public <E extends JsonBuilder> E closeObject() {
        this.buffer.append("}");
        return this.returnInstance();
    }

    public <E extends JsonBuilder> E openList() {
        this.buffer.append('[');
        return this.returnInstance();
    }

    public <E extends JsonBuilder> E closeList() {
        this.buffer.append(']');
        return this.returnInstance();
    }

    public <E extends JsonBuilder> E openTuple() {
        this.buffer.append("(");
        return this.returnInstance();
    }

    public <E extends JsonBuilder> E closeTuple() {
        this.buffer.append(")");
        return this.returnInstance();
    }

    public <E extends JsonBuilder> E openComment() {
        this.buffer.append("/*");
        return this.returnInstance();
    }

    public <E extends JsonBuilder> E closeComment() {
        this.buffer.append("*/");
        return this.returnInstance();
    }

    public <E extends JsonBuilder> E addField(String name) {
        this.valueQuot(name);
        this.buffer.append(':');
        return this.returnInstance();
    }

    public <E extends JsonBuilder> E write(Object value) {
        this.buffer.append(value);
        return this.returnInstance();
    }

    public <E extends JsonBuilder> E write(boolean value) {
        this.buffer.append(value ? "true" : "false");
        return this.returnInstance();
    }

    public <E extends JsonBuilder> E write(byte value) {
        this.buffer.append(value);
        return this.returnInstance();
    }

    public <E extends JsonBuilder> E write(short value) {
        this.buffer.append(value);
        return this.returnInstance();
    }

    public <E extends JsonBuilder> E write(int value) {
        this.buffer.append(value);
        return this.returnInstance();
    }

    public <E extends JsonBuilder> E write(long value) {
        this.buffer.append(value);
        return this.returnInstance();
    }

    public <E extends JsonBuilder> E write(float value) {
        this.buffer.append(value);
        return this.returnInstance();
    }

    public <E extends JsonBuilder> E write(double value) {
        this.buffer.append(value);
        return this.returnInstance();
    }

    public <E extends JsonBuilder> E writeSpace() {
        return this.writeSpace(1);
    }

    public <E extends JsonBuilder> E writeSpace(int size) {
        if (size > 0) {
            for (int i = size - 1; i >= 0; --i) {
                this.write(SPACE);
            }
        }
        return this.returnInstance();
    }

    public <E extends JsonBuilder> E writeParam(String key, String value) {
        this.buffer.append('\"');
        this.buffer.append(key);
        this.buffer.append('\"');
        this.buffer.append(':');
        this.buffer.append('\"');
        this.buffer.append(value);
        this.buffer.append('\"');
        return this.returnInstance();
    }

    public <E extends JsonBuilder> E valueQuot(Object value) {
        if (value == null) {
            this.valueNull();
        } else {
            this.buffer.append("\"");
            this.buffer.append(value);
            this.buffer.append("\"");
        }
        return this.returnInstance();
    }

    public <E extends JsonBuilder> E valueNull() {
        this.buffer.append(VALUE_NULL);
        return this.returnInstance();
    }

    public <E extends JsonBuilder> E addLine() {
        this.buffer.append("\n");
        return this.returnInstance();
    }

    public <E extends JsonBuilder> E addSeparator() {
        this.buffer.append(',');
        return this.returnInstance();
    }

    public <E extends JsonBuilder> E addEndLine() {
        this.buffer.append(";\n");
        return this.returnInstance();
    }

    public <E extends JsonBuilder> E writeListString(List<String> values) {
        if (values == null) {
            this.valueNull();
        } else {
            this.openList();
            int size = values.size();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    this.addSeparator();
                }
                this.valueQuot(values.get(i));
            }
            this.closeList();
        }
        return this.returnInstance();
    }

    public <E extends JsonBuilder> E line() {
        this.buffer.append('\n');
        return this.returnInstance();
    }

    public <E extends JsonBuilder> E tab() {
        this.buffer.append('\t');
        return this.returnInstance();
    }

    public JsonBuilder writeListJsonObject(List<? extends JsonObject> values) {
        if (values == null) {
            this.valueNull();
        } else {
            this.openList();
            int size = values.size();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    this.addSeparator();
                }
                this.write(values.get(i).convertToJson());
            }
            this.closeList();
        }
        return this;
    }

    public JsonObject toJsonObject() {
        return new Json(this.toString());
    }

    public StringBuilder append(Object value) {
        return this.buffer.append(value);
    }

    public StringBuilder append(String value) {
        return this.buffer.append(value);
    }

    public StringBuilder append(StringBuffer value) {
        return this.buffer.append(value);
    }

    public StringBuilder append(CharSequence value) {
        return this.buffer.append(value);
    }

    public StringBuilder append(CharSequence value, int start, int end) {
        return this.buffer.append(value, start, end);
    }

    public StringBuilder append(char ... str) {
        return this.buffer.append(str);
    }

    public StringBuilder append(char[] str, int offset, int len) {
        return this.buffer.append(str, offset, len);
    }

    public StringBuilder append(boolean value) {
        return this.buffer.append(value);
    }

    public StringBuilder append(char value) {
        return this.buffer.append(value);
    }

    public StringBuilder append(int value) {
        return this.buffer.append(value);
    }

    public StringBuilder append(long value) {
        return this.buffer.append(value);
    }

    public StringBuilder append(float value) {
        return this.buffer.append(value);
    }

    public StringBuilder append(double value) {
        return this.buffer.append(value);
    }

    public JsonBuilder dot() {
        this.buffer.append(DOT);
        return this;
    }

    public JsonBuilder doubleDot() {
        this.buffer.append(DOUBLE_DOT);
        return this;
    }

    public JsonBuilder deco(int nbChar) {
        return this.deco(SPACE, nbChar);
    }

    public JsonBuilder deco(String deco, int nbChar) {
        if (nbChar > 0) {
            String currentDeco = deco == null ? SPACE : deco;
            for (int i = nbChar; i > 0; --i) {
                this.buffer.append(currentDeco);
            }
        }
        return this;
    }

    public String toString() {
        return this.buffer.toString();
    }

    public <E extends JsonBuilder> E clear() {
        this.buffer.setLength(0);
        this.buffer.trimToSize();
        return this.returnInstance();
    }
}

