/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.models;

import java.io.Serializable;

public final class NumberValue
implements Serializable {
    private static final long serialVersionUID = -9102126543728343919L;
    private double last;
    private double current;

    public static NumberValueBuilder builder() {
        return new NumberValueBuilder();
    }

    public NumberValueBuilder toBuilder() {
        return new NumberValueBuilder().last(this.last).current(this.current);
    }

    public String toString() {
        return "NumberValue(last=" + this.getLast() + ", current=" + this.getCurrent() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NumberValue)) {
            return false;
        }
        NumberValue other = (NumberValue)o;
        if (Double.compare(this.getLast(), other.getLast()) != 0) {
            return false;
        }
        return Double.compare(this.getCurrent(), other.getCurrent()) == 0;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $last = Double.doubleToLongBits(this.getLast());
        result = result * 59 + (int)($last >>> 32 ^ $last);
        long $current = Double.doubleToLongBits(this.getCurrent());
        result = result * 59 + (int)($current >>> 32 ^ $current);
        return result;
    }

    public NumberValue(double last, double current) {
        this.last = last;
        this.current = current;
    }

    public NumberValue() {
    }

    public void setLast(double last) {
        this.last = last;
    }

    public void setCurrent(double current) {
        this.current = current;
    }

    public double getLast() {
        return this.last;
    }

    public double getCurrent() {
        return this.current;
    }

    public static class NumberValueBuilder {
        private double last;
        private double current;

        NumberValueBuilder() {
        }

        public NumberValueBuilder last(double last) {
            this.last = last;
            return this;
        }

        public NumberValueBuilder current(double current) {
            this.current = current;
            return this;
        }

        public NumberValue build() {
            return new NumberValue(this.last, this.current);
        }

        public String toString() {
            return "NumberValue.NumberValueBuilder(last=" + this.last + ", current=" + this.current + ")";
        }
    }
}

