/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.models;

import io.inugami.api.tools.Hex;
import java.io.Serializable;

public final class Rgb
implements Serializable {
    private static final long serialVersionUID = -3447074324241155009L;
    private byte red;
    private byte green;
    private byte blue;
    private int color;
    private byte avg;
    private String hexa;

    public static RgbBuilder builder() {
        return new RgbBuilder();
    }

    public RgbBuilder toBuilder() {
        return new RgbBuilder().red(this.red).green(this.green).blue(this.blue).color(this.color).avg(this.avg).hexa(this.hexa);
    }

    public String toString() {
        return "Rgb(hexa=" + this.getHexa() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Rgb)) {
            return false;
        }
        Rgb other = (Rgb)o;
        return this.getColor() == other.getColor();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getColor();
        return result;
    }

    public Rgb(byte red, byte green, byte blue, int color, byte avg, String hexa) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.color = color;
        this.avg = avg;
        this.hexa = hexa;
    }

    public Rgb() {
    }

    public void setRed(byte red) {
        this.red = red;
    }

    public void setGreen(byte green) {
        this.green = green;
    }

    public void setBlue(byte blue) {
        this.blue = blue;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setAvg(byte avg) {
        this.avg = avg;
    }

    public void setHexa(String hexa) {
        this.hexa = hexa;
    }

    public byte getRed() {
        return this.red;
    }

    public byte getGreen() {
        return this.green;
    }

    public byte getBlue() {
        return this.blue;
    }

    public int getColor() {
        return this.color;
    }

    public byte getAvg() {
        return this.avg;
    }

    public String getHexa() {
        return this.hexa;
    }

    public static class RgbBuilder {
        private byte red;
        private byte green;
        private byte blue;
        private int color;
        private byte avg;
        private String hexa;

        public RgbBuilder addColor(int color) {
            this.color = color;
            this.red = (byte)(color >> 16);
            this.green = (byte)((color & 0xFF00) >> 8);
            this.blue = (byte)(color & 0xFF);
            this.avg = (byte)((this.red + this.green + this.blue) / 3);
            this.hexa = Hex.encodeHexString(new byte[]{this.red, this.green, this.blue});
            return this;
        }

        RgbBuilder() {
        }

        public RgbBuilder red(byte red) {
            this.red = red;
            return this;
        }

        public RgbBuilder green(byte green) {
            this.green = green;
            return this;
        }

        public RgbBuilder blue(byte blue) {
            this.blue = blue;
            return this;
        }

        public RgbBuilder color(int color) {
            this.color = color;
            return this;
        }

        public RgbBuilder avg(byte avg) {
            this.avg = avg;
            return this;
        }

        public RgbBuilder hexa(String hexa) {
            this.hexa = hexa;
            return this;
        }

        public Rgb build() {
            return new Rgb(this.red, this.green, this.blue, this.color, this.avg, this.hexa);
        }

        public String toString() {
            return "Rgb.RgbBuilder(red=" + this.red + ", green=" + this.green + ", blue=" + this.blue + ", color=" + this.color + ", avg=" + this.avg + ", hexa=" + this.hexa + ")";
        }
    }
}

