/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.models;

public final class Tuple<K, V> {
    private K key;
    private V value;

    public static <K, V> TupleBuilder<K, V> builder() {
        return new TupleBuilder();
    }

    public TupleBuilder<K, V> toBuilder() {
        return new TupleBuilder().key(this.key).value(this.value);
    }

    public String toString() {
        return "Tuple(key=" + this.getKey() + ", value=" + this.getValue() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Tuple)) {
            return false;
        }
        Tuple other = (Tuple)o;
        K this$key = this.getKey();
        K other$key = other.getKey();
        return !(this$key == null ? other$key != null : !this$key.equals(other$key));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        K $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        return result;
    }

    public Tuple(K key, V value) {
        this.key = key;
        this.value = value;
    }

    public Tuple() {
    }

    public void setKey(K key) {
        this.key = key;
    }

    public void setValue(V value) {
        this.value = value;
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public static class TupleBuilder<K, V> {
        private K key;
        private V value;

        TupleBuilder() {
        }

        public TupleBuilder<K, V> key(K key) {
            this.key = key;
            return this;
        }

        public TupleBuilder<K, V> value(V value) {
            this.value = value;
            return this;
        }

        public Tuple<K, V> build() {
            return new Tuple<K, V>(this.key, this.value);
        }

        public String toString() {
            return "Tuple.TupleBuilder(key=" + this.key + ", value=" + this.value + ")";
        }
    }
}

