/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.models.data;

public final class DataGeneratorUtils {
    public static final String[] LOREM = new String[]{"lorem", "ac", "adipiscing", "aliquam", "aliquet", "sagittis", "amet", "consectetur", "ante", "arcu", "cras", "nullam", "at", "auctor", "augue", "bibendum", "morbi", "blandit", "commodo", "condimentum", "duis", "sed", "congue", "risus", "consequat", "convallis", "donec", "cursus", "in", "dapibus", "diam", "et", "dictumst", "nulla", "vestibulum", "dignissim", "dis", "dolor", "suspendisse", "dui", "efficitur", "tellus", "egestas", "eget", "phasellus", "eleifend", "proin", "elementum", "elit", "nunc", "enim", "ut", "erat", "pellentesque", "eros", "est", "eu", "euismod", "ex", "facilisi", "vivamus", "facilisis", "faucibus", "felis", "praesent", "fermentum", "feugiat", "finibus", "fringilla", "gravida", "habitasse", "hac", "iaculis", "id", "imperdiet", "interdum", "ipsum", "justo", "integer", "lacinia", "lacus", "laoreet", "leo", "libero", "ligula", "lobortis", "lorem", "mauris", "magna", "magnis", "malesuada", "massa", "sit", "etiam", "nam", "maximus", "metus", "mi", "quisque", "molestie", "mollis", "montes", "nascetur", "mus", "natoque", "nec", "neque", "nibh", "quis", "nisi", "nisl", "fusce", "non", "pharetra", "vehicula", "odio", "orci", "ornare", "parturient", "penatibus", "placerat", "platea", "porta", "porttitor", "posuere", "pretium", "pulvinar", "purus", "quam", "ridiculus", "sapien", "scelerisque", "sem", "vitae", "sociis", "sodales", "cum", "suscipit", "tempor", "tempus", "tincidunt", "tortor", "tristique", "turpis", "ullamcorper", "ultrices", "urna", "varius", "vel", "velit", "venenatis", "viverra", "volutpat", "vulputate"};
    private static final int LENGTH = LOREM.length;
    public static final String[] CATEGORY = new String[]{"lorem", "cursus", "ipsum", "justo", "vehicula", "tempus", "ridiculus", "tortor"};
    private static final int LENGTH_CATEGORY = CATEGORY.length;

    private DataGeneratorUtils() {
    }

    public static String getWord() {
        return LOREM[DataGeneratorUtils.getRandomBetween(0, LENGTH - 1)];
    }

    public static String getCategory() {
        return CATEGORY[DataGeneratorUtils.getRandomBetween(0, LENGTH_CATEGORY - 1)];
    }

    public static String getLabel() {
        return DataGeneratorUtils.getPhrase(5, 10, true);
    }

    public static String getPhrase() {
        return DataGeneratorUtils.getPhrase(5, 10, false);
    }

    public static String getSection() {
        return DataGeneratorUtils.getSection(DataGeneratorUtils.getRandomBetween(3, 10), 5, 30);
    }

    public static String getSection(int nbLine, int nbWordMin, int nbWordMax) {
        StringBuilder result = new StringBuilder();
        for (int line = 0; line < nbLine; ++line) {
            result.append(DataGeneratorUtils.getPhrase(nbWordMin, nbWordMax, false));
            result.append(' ');
        }
        return result.toString();
    }

    public static String getPhrase(int nbWordMin, int nbWordMax, boolean isLabel) {
        int nbWord = DataGeneratorUtils.getRandomBetween(nbWordMin, nbWordMax);
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < nbWord; ++i) {
            String word = DataGeneratorUtils.getWord();
            if (i == 0) {
                result.append(word.substring(0, 1).toUpperCase());
                result.append(word.substring(1));
                continue;
            }
            result.append(" ");
            result.append(word);
        }
        if (!isLabel) {
            result.append(".");
        }
        return result.toString();
    }

    public static double getDouble(double min, double max) {
        double diff = max - min;
        return min + Math.random() * diff;
    }

    public static int getRandomBetween(int start, int end) {
        int diff = end - start;
        return start + Double.valueOf(Math.random() * (double)diff).intValue();
    }
}

