/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.models.data.basic;

import io.inugami.api.models.JsonBuilder;
import io.inugami.api.models.data.basic.JsonObject;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class JsonMap<K extends Serializable, V extends JsonObject>
implements JsonObject {
    private static final long serialVersionUID = -6379031016086770674L;
    private final Map<K, V> data;

    public JsonMap(Map<K, V> data) {
        this.data = data;
    }

    public String toString() {
        return this.convertToJson();
    }

    @Override
    public String convertToJson() {
        JsonBuilder json = new JsonBuilder();
        if (this.data == null) {
            json.valueNull();
        } else {
            json.openObject();
            int cursor = 0;
            for (Map.Entry<K, V> entry : this.data.entrySet()) {
                if (cursor != 0) {
                    json.addSeparator();
                }
                if (entry.getValue() == null) {
                    json.valueNull();
                } else {
                    json.addField(String.valueOf(entry.getKey()));
                    json.write(((JsonObject)entry.getValue()).convertToJson());
                }
                ++cursor;
            }
            json.closeObject();
        }
        return json.toString();
    }

    public Map<K, V> getData() {
        return this.data;
    }

    @Override
    public JsonObject cloneObj() {
        HashMap<Serializable, JsonObject> newMap = new HashMap<Serializable, JsonObject>();
        if (this.data != null) {
            for (Map.Entry item : newMap.entrySet()) {
                JsonObject itemData = (JsonObject)item.getValue();
                if (itemData == null) continue;
                newMap.put((Serializable)item.getKey(), itemData.cloneObj());
            }
        }
        return new JsonMap(newMap);
    }
}

