/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.models.data.basic;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.inugami.api.loggers.Loggers;
import io.inugami.api.marshalling.JsonMarshaller;
import io.inugami.api.models.ClonableObject;
import io.inugami.api.models.data.JsonObjectToJson;
import java.nio.charset.Charset;

public interface JsonObject
extends JsonObjectToJson,
ClonableObject<JsonObject> {
    default public <T extends JsonObject> T convertToObject(byte[] data, Charset encoding) {
        String json = new String(data, encoding);
        ObjectMapper objectMapper = JsonMarshaller.getInstance().getDefaultObjectMapper();
        try {
            return (T)((JsonObject)objectMapper.readValue(json, new TypeReference<T>(){}));
        }
        catch (JsonProcessingException e) {
            Loggers.DEBUG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    default public JsonObject cloneObj() {
        return null;
    }
}

