/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.models.data.graphite.number;

import io.inugami.api.models.data.graphite.number.GraphiteNumber;
import java.math.BigDecimal;

public class FloatNumber
implements GraphiteNumber {
    private static final long serialVersionUID = -2112757362454710593L;
    private final double value;

    public FloatNumber(double value) {
        this.value = value;
    }

    public static FloatNumber of(double value) {
        return new FloatNumber(value);
    }

    @Override
    public GraphiteNumber add(GraphiteNumber number) {
        double toAdd = number == null ? 0.0 : number.toDouble();
        return new FloatNumber(this.value + toAdd);
    }

    @Override
    public GraphiteNumber sub(GraphiteNumber number) {
        double toSub = number == null ? 0.0 : number.toDouble();
        return new FloatNumber(this.value - toSub);
    }

    @Override
    public String rendering() {
        return String.valueOf(this.value);
    }

    @Override
    public String convertToJson() {
        return this.rendering();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.value);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        boolean result;
        boolean bl = result = this == obj;
        if (!result && obj != null && obj instanceof GraphiteNumber) {
            double other = ((GraphiteNumber)obj).toDouble();
            result = this.value == other;
        }
        return result;
    }

    public String toString() {
        return this.rendering();
    }

    @Override
    public long toLong() {
        return Double.valueOf(this.value).longValue();
    }

    @Override
    public double toDouble() {
        return this.value;
    }

    @Override
    public GraphiteNumber cloneNumber() {
        return new FloatNumber(this.value);
    }

    @Override
    public boolean isDecimal() {
        return true;
    }

    @Override
    public BigDecimal toBigDecimal() {
        return BigDecimal.valueOf(this.value);
    }
}

