/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.models.data.graphite.number;

import io.inugami.api.models.data.graphite.number.GraphiteNumber;
import java.math.BigDecimal;

public class LongNumber
implements GraphiteNumber {
    private static final long serialVersionUID = 5221104927236998757L;
    private final long value;

    public LongNumber(long value) {
        this.value = value;
    }

    public static LongNumber of(long value) {
        return new LongNumber(value);
    }

    @Override
    public GraphiteNumber add(GraphiteNumber number) {
        long toAdd = number == null ? 0L : number.toLong();
        return new LongNumber(this.value + toAdd);
    }

    @Override
    public GraphiteNumber sub(GraphiteNumber number) {
        long toSub = number == null ? 0L : number.toLong();
        return new LongNumber(this.value - toSub);
    }

    @Override
    public String rendering() {
        return String.valueOf(this.value);
    }

    @Override
    public String convertToJson() {
        return this.rendering();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.value);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        boolean result;
        boolean bl = result = this == obj;
        if (!result && obj != null && obj instanceof GraphiteNumber) {
            long other = ((GraphiteNumber)obj).toLong();
            result = this.value == other;
        }
        return result;
    }

    public String toString() {
        return this.rendering();
    }

    @Override
    public long toLong() {
        return this.value;
    }

    @Override
    public double toDouble() {
        return this.value;
    }

    @Override
    public GraphiteNumber cloneNumber() {
        return new LongNumber(this.value);
    }

    @Override
    public boolean isDecimal() {
        return false;
    }

    @Override
    public BigDecimal toBigDecimal() {
        return new BigDecimal(this.value);
    }
}

