/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.models.events;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import io.inugami.api.models.events.AlertingModel;
import io.inugami.api.models.events.GenericEvent;
import io.inugami.api.models.events.TargetConfig;
import io.inugami.api.processors.ProcessorModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@XStreamAlias(value="event")
public class Event
extends GenericEvent {
    private static final long serialVersionUID = 1783705856498891253L;
    @XStreamImplicit
    private final List<TargetConfig> targets;
    @XStreamAsAttribute
    private String scheduler;

    public Event() {
        this.targets = new ArrayList<TargetConfig>();
    }

    public Event(String name, String from, String until, String provider, List<ProcessorModel> processors, List<TargetConfig> targets, String scheduler, String mapper, List<AlertingModel> alertings) {
        super(name, from, until, provider, processors, mapper, alertings);
        this.targets = targets == null ? null : Collections.unmodifiableList(targets);
        this.scheduler = scheduler;
    }

    @Override
    public GenericEvent cloneObj() {
        ArrayList<ProcessorModel> cpProcessors = new ArrayList<ProcessorModel>();
        this.getProcessors().ifPresent(cpProcessors::addAll);
        ArrayList<AlertingModel> cpAlertings = new ArrayList<AlertingModel>();
        this.getAlertings().ifPresent(cpAlertings::addAll);
        ArrayList<TargetConfig> newTarget = null;
        if (this.targets != null) {
            newTarget = new ArrayList<TargetConfig>();
            for (TargetConfig target : this.targets) {
                newTarget.add((TargetConfig)target.cloneObj());
            }
        }
        String mapper = this.getMapper().orElse(null);
        String from = this.getFrom().orElse(null);
        String until = this.getUntil().orElse(null);
        String provider = this.getProvider().orElse(null);
        Event result = new Event(this.getName(), from, until, provider, cpProcessors, newTarget, this.scheduler, mapper, cpAlertings);
        this.getFromFirstTime().ifPresent(result::buildFromFirstTime);
        return result;
    }

    public List<TargetConfig> getTargets() {
        List<TargetConfig> result = null;
        if (this.targets != null) {
            result = this.targets;
        }
        return result;
    }

    public String getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(String scheduler) {
        this.scheduler = scheduler;
    }
}

