/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.models.events;

import io.inugami.api.functionnals.ApplyIfNotNullAndSameType;
import io.inugami.api.mapping.events.ListAlertsMapper;
import io.inugami.api.mapping.events.ListProcessorMapper;
import io.inugami.api.mapping.events.ListTargetsMapper;
import io.inugami.api.models.Builder;
import io.inugami.api.models.events.AlertingModel;
import io.inugami.api.models.events.Event;
import io.inugami.api.models.events.TargetConfig;
import io.inugami.api.models.events.TargetConfigBuilder;
import io.inugami.api.processors.ProcessorModel;
import io.inugami.api.tools.NashornTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.script.Bindings;

public class EventBuilder
implements Builder<Event>,
ApplyIfNotNullAndSameType {
    private String name;
    private String from;
    private String until;
    private String provider;
    private String scheduler;
    private String mapper;
    private List<ProcessorModel> processors;
    private List<TargetConfig> targets;
    private List<AlertingModel> alertings;

    public EventBuilder() {
    }

    public EventBuilder(Event event) {
        this.name = event.getName();
        event.getFrom().ifPresent(value -> {
            this.from = value;
        });
        event.getUntil().ifPresent(value -> {
            this.until = value;
        });
        event.getProvider().ifPresent(value -> {
            this.provider = value;
        });
        event.getProcessors().ifPresent(value -> {
            this.processors = value;
        });
    }

    public EventBuilder(Bindings data) {
        if (data != null) {
            ListProcessorMapper processorsMapper = new ListProcessorMapper();
            ListAlertsMapper alertsMapper = new ListAlertsMapper();
            ListTargetsMapper targetsMapper = new ListTargetsMapper();
            Function mapString = this.buildStringMapper();
            Function<Object, List> mapProcessors = v -> NashornTools.isArray(v) ? processorsMapper.mapping(NashornTools.convertToList(v)) : null;
            Function<Object, List> mapAlerts = v -> NashornTools.isArray(v) ? alertsMapper.mapping(NashornTools.convertToList(v)) : null;
            Function<Object, List> mapTargets = v -> NashornTools.isArray(v) ? targetsMapper.mapping(NashornTools.convertToList(v)) : null;
            this.ifNotNullAndSameType(data.get("name"), mapString, v -> {
                this.name = v;
            });
            this.ifNotNullAndSameType(data.get("from"), mapString, v -> {
                this.from = v;
            });
            this.ifNotNullAndSameType(data.get("until"), mapString, v -> {
                this.until = v;
            });
            this.ifNotNullAndSameType(data.get("provider"), mapString, v -> {
                this.provider = v;
            });
            this.ifNotNullAndSameType(data.get("targets"), mapTargets, v -> {
                this.targets = v;
            });
            this.ifNotNullAndSameType(data.get("scheduler"), mapString, v -> {
                this.scheduler = v;
            });
            this.ifNotNullAndSameType(data.get("mapper"), mapString, v -> {
                this.mapper = v;
            });
            this.ifNotNullAndSameType(data.get("processors"), mapProcessors, v -> {
                this.processors = v;
            });
            this.ifNotNullAndSameType(data.get("alertings"), mapAlerts, v -> {
                this.alertings = v;
            });
        }
    }

    public EventBuilder addName(String name) {
        this.name = name;
        return this;
    }

    public EventBuilder addFrom(String from) {
        this.from = from;
        return this;
    }

    public EventBuilder addUntil(String until) {
        this.until = until;
        return this;
    }

    public EventBuilder addProvider(String provider) {
        this.provider = provider;
        return this;
    }

    public EventBuilder addScheduler(String scheduler) {
        this.scheduler = scheduler;
        return this;
    }

    public EventBuilder addMapper(String mapper) {
        this.mapper = mapper;
        return this;
    }

    public EventBuilder addAlertings(List<AlertingModel> alertings) {
        this.alertings = alertings;
        return this;
    }

    public EventBuilder addAlerting(AlertingModel alerting) {
        if (this.alertings == null) {
            this.alertings = new ArrayList<AlertingModel>();
        }
        if (alerting != null) {
            this.alertings.add(alerting);
        }
        return this;
    }

    public EventBuilder addProcessors(List<ProcessorModel> processors) {
        if (this.processors == null) {
            this.processors = new ArrayList<ProcessorModel>();
        }
        if (processors != null) {
            this.processors.addAll(processors);
        }
        return this;
    }

    public EventBuilder addProcessors(ProcessorModel ... processors) {
        return this.addProcessors(Arrays.asList(processors));
    }

    public EventBuilder addTargets(List<TargetConfig> targets) {
        if (this.targets == null) {
            this.targets = new ArrayList<TargetConfig>();
        }
        if (targets != null) {
            this.targets.addAll(targets);
        }
        return this;
    }

    public EventBuilder addTarget(String name, String query) {
        this.addTargets(TargetConfigBuilder.builder().addName(name).addQuery(query).build());
        return this;
    }

    public EventBuilder addTargets(TargetConfig ... targets) {
        return this.addTargets(Arrays.asList(targets));
    }

    public Event build() {
        return new Event(this.name, this.from, this.until, this.provider, this.processors, this.targets, this.scheduler, this.mapper, this.alertings);
    }
}

