/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.models.events;

import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import io.inugami.api.models.ClonableObject;
import io.inugami.api.models.events.AlertingModel;
import io.inugami.api.processors.ProcessorModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class GenericEvent
implements Serializable,
ClonableObject<GenericEvent> {
    private static final long serialVersionUID = -355683229478830003L;
    @XStreamAsAttribute
    private String name;
    @XStreamAsAttribute
    protected String fromFirstTime;
    @XStreamAsAttribute
    protected String from;
    @XStreamAsAttribute
    private String until;
    @XStreamAsAttribute
    private String provider;
    @XStreamAsAttribute
    private String mapper;
    @XStreamImplicit
    private List<ProcessorModel> processors;
    @XStreamImplicit
    private List<AlertingModel> alertings;

    public GenericEvent(String name) {
        this(name, null, null, null, null, null, null);
    }

    public GenericEvent(String name, String from, String unitl, String provider, List<ProcessorModel> processors, String mapper, List<AlertingModel> alertings) {
        this.name = name;
        this.from = from;
        this.provider = provider;
        this.processors = processors == null ? null : Collections.unmodifiableList(processors);
        this.alertings = alertings == null ? null : Collections.unmodifiableList(alertings);
        this.until = unitl;
        this.mapper = mapper;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '@' + System.identityHashCode(this) + '[' + "name=" + this.name + ", from=" + this.from + ", provider=" + this.provider + ", processors=" + this.processors + ']';
    }

    public Optional<String> getFrom() {
        return Optional.ofNullable(this.from);
    }

    public Optional<String> getProvider() {
        return Optional.ofNullable(this.provider);
    }

    public Optional<List<ProcessorModel>> getProcessors() {
        return Optional.ofNullable(this.processors);
    }

    public Optional<String> getUntil() {
        return Optional.ofNullable(this.until);
    }

    public Optional<String> getFromFirstTime() {
        return Optional.ofNullable(this.fromFirstTime);
    }

    public void buildFrom(String from) {
        this.from = from;
    }

    public void buildUntil(String until) {
        this.until = until;
    }

    public void buildProvider(String provider) {
        this.provider = provider;
    }

    public void buildFromFirstTime(String fromFirstTime) {
        this.fromFirstTime = fromFirstTime;
    }

    public Optional<String> getMapper() {
        return Optional.ofNullable(this.mapper);
    }

    public void buildMapper(String mapper) {
        this.mapper = mapper;
    }

    public Optional<List<AlertingModel>> getAlertings() {
        return Optional.ofNullable(this.alertings);
    }

    public GenericEvent cloneObj() {
        ArrayList<ProcessorModel> cpProcessors = null;
        if (this.processors != null) {
            cpProcessors = new ArrayList<ProcessorModel>();
            cpProcessors.addAll(this.processors);
        }
        return new GenericEvent(this.name, this.from, this.until, this.provider, cpProcessors, this.mapper, this.alertings);
    }

    public GenericEvent() {
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFromFirstTime(String fromFirstTime) {
        this.fromFirstTime = fromFirstTime;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setUntil(String until) {
        this.until = until;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public void setMapper(String mapper) {
        this.mapper = mapper;
    }

    public void setProcessors(List<ProcessorModel> processors) {
        this.processors = processors;
    }

    public void setAlertings(List<AlertingModel> alertings) {
        this.alertings = alertings;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenericEvent)) {
            return false;
        }
        GenericEvent other = (GenericEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GenericEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }
}

