/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.models.events;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import io.inugami.api.models.events.AlertingModel;
import io.inugami.api.models.events.GenericEvent;
import io.inugami.api.processors.ProcessorModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@XStreamAlias(value="simple-event")
public class SimpleEvent
extends GenericEvent {
    private static final long serialVersionUID = -1139191592954226047L;
    private final String query;
    @XStreamOmitField
    private final String parent;
    @XStreamAsAttribute
    private String scheduler;

    public SimpleEvent() {
        this.query = null;
        this.parent = null;
    }

    public SimpleEvent(String name, String from, String until, String provider, List<ProcessorModel> processors, String query, String parent, String scheduler, String mapper, List<AlertingModel> alertings) {
        super(name, from, until, provider, processors, mapper, alertings);
        this.query = query;
        this.parent = parent;
        this.scheduler = scheduler;
    }

    @Override
    public GenericEvent cloneObj() {
        ArrayList<ProcessorModel> cpProcessors = new ArrayList<ProcessorModel>();
        this.getProcessors().ifPresent(cpProcessors::addAll);
        ArrayList<AlertingModel> cpAlertings = new ArrayList<AlertingModel>();
        this.getAlertings().ifPresent(cpAlertings::addAll);
        String from = this.getFrom().orElse(null);
        String until = this.getUntil().orElse(null);
        String provider = this.getProvider().orElse(null);
        String mapper = this.getMapper().orElse(null);
        SimpleEvent result = new SimpleEvent(this.getName(), from, until, provider, cpProcessors, this.query, this.parent, this.scheduler, mapper, cpAlertings);
        this.getFromFirstTime().ifPresent(result::buildFromFirstTime);
        return result;
    }

    public String getQuery() {
        return this.query;
    }

    public Optional<String> getParent() {
        return this.parent == null ? Optional.empty() : Optional.of(this.parent);
    }

    public String getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(String scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public String getName() {
        return super.getName();
    }

    @Override
    public Optional<String> getFrom() {
        return super.getFrom();
    }

    @Override
    public Optional<String> getProvider() {
        return super.getProvider();
    }

    @Override
    public Optional<List<ProcessorModel>> getProcessors() {
        return super.getProcessors();
    }

    @Override
    public Optional<String> getUntil() {
        return super.getUntil();
    }

    @Override
    public Optional<String> getFromFirstTime() {
        return super.getFromFirstTime();
    }

    @Override
    public void buildFrom(String from) {
        super.buildFrom(from);
    }

    @Override
    public void buildUntil(String until) {
        super.buildUntil(until);
    }

    @Override
    public void buildProvider(String provider) {
        super.buildProvider(provider);
    }

    @Override
    public void buildFromFirstTime(String fromFirstTime) {
        super.buildFromFirstTime(fromFirstTime);
    }

    @Override
    public Optional<String> getMapper() {
        return super.getMapper();
    }

    @Override
    public void buildMapper(String mapper) {
        super.buildMapper(mapper);
    }

    @Override
    public Optional<List<AlertingModel>> getAlertings() {
        return super.getAlertings();
    }

    public static SimpleEventBuilder simpleEventBuilder() {
        return new SimpleEventBuilder();
    }

    public static class SimpleEventBuilder {
        private String name;
        private String from;
        private String until;
        private String provider;
        private List<ProcessorModel> processors;
        private String query;
        private String parent;
        private String scheduler;
        private String mapper;
        private List<AlertingModel> alertings;

        SimpleEventBuilder() {
        }

        public SimpleEventBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SimpleEventBuilder from(String from) {
            this.from = from;
            return this;
        }

        public SimpleEventBuilder until(String until) {
            this.until = until;
            return this;
        }

        public SimpleEventBuilder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public SimpleEventBuilder processors(List<ProcessorModel> processors) {
            this.processors = processors;
            return this;
        }

        public SimpleEventBuilder query(String query) {
            this.query = query;
            return this;
        }

        public SimpleEventBuilder parent(String parent) {
            this.parent = parent;
            return this;
        }

        public SimpleEventBuilder scheduler(String scheduler) {
            this.scheduler = scheduler;
            return this;
        }

        public SimpleEventBuilder mapper(String mapper) {
            this.mapper = mapper;
            return this;
        }

        public SimpleEventBuilder alertings(List<AlertingModel> alertings) {
            this.alertings = alertings;
            return this;
        }

        public SimpleEvent build() {
            return new SimpleEvent(this.name, this.from, this.until, this.provider, this.processors, this.query, this.parent, this.scheduler, this.mapper, this.alertings);
        }

        public String toString() {
            return "SimpleEvent.SimpleEventBuilder(name=" + this.name + ", from=" + this.from + ", until=" + this.until + ", provider=" + this.provider + ", processors=" + this.processors + ", query=" + this.query + ", parent=" + this.parent + ", scheduler=" + this.scheduler + ", mapper=" + this.mapper + ", alertings=" + this.alertings + ")";
        }
    }
}

