/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.models.events;

import io.inugami.api.functionnals.ApplyIfNotNullAndSameType;
import io.inugami.api.mapping.events.ListAlertsMapper;
import io.inugami.api.mapping.events.ListProcessorMapper;
import io.inugami.api.models.Builder;
import io.inugami.api.models.events.AlertingModel;
import io.inugami.api.models.events.SimpleEvent;
import io.inugami.api.processors.ProcessorModel;
import io.inugami.api.tools.NashornTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.script.Bindings;

@Deprecated
public class SimpleEventBuilder
implements Builder<SimpleEvent>,
ApplyIfNotNullAndSameType {
    private String name;
    private String from;
    private String until;
    private String provider;
    private String scheduler;
    private String mapper;
    private List<ProcessorModel> processors;
    private String query;
    private String parent;
    private List<AlertingModel> alertings;

    public SimpleEventBuilder() {
    }

    public SimpleEventBuilder(SimpleEvent event) {
        this.name = event.getName();
        this.query = event.getQuery();
        this.scheduler = event.getScheduler();
        event.getFrom().ifPresent(s -> {
            this.from = s;
        });
        event.getUntil().ifPresent(s -> {
            this.until = s;
        });
        event.getProvider().ifPresent(s -> {
            this.provider = s;
        });
        event.getProcessors().ifPresent(s -> {
            this.processors = s;
        });
        event.getParent().ifPresent(s -> {
            this.parent = s;
        });
        event.getAlertings().ifPresent(s -> {
            this.alertings = s;
        });
    }

    public SimpleEventBuilder(Bindings data) {
        if (data != null) {
            ListProcessorMapper processorsMapper = new ListProcessorMapper();
            ListAlertsMapper alertsMapper = new ListAlertsMapper();
            Function mapString = this.buildStringMapper();
            Function<Object, List> mapProcessors = v -> NashornTools.isArray(v) ? processorsMapper.mapping(NashornTools.convertToList(v)) : null;
            Function<Object, List> mapAlerts = v -> NashornTools.isArray(v) ? alertsMapper.mapping(NashornTools.convertToList(v)) : null;
            this.ifNotNullAndSameType(data.get("name"), mapString, v -> {
                this.name = v;
            });
            this.ifNotNullAndSameType(data.get("from"), mapString, v -> {
                this.from = v;
            });
            this.ifNotNullAndSameType(data.get("until"), mapString, v -> {
                this.until = v;
            });
            this.ifNotNullAndSameType(data.get("provider"), mapString, v -> {
                this.provider = v;
            });
            this.ifNotNullAndSameType(data.get("scheduler"), mapString, v -> {
                this.scheduler = v;
            });
            this.ifNotNullAndSameType(data.get("mapper"), mapString, v -> {
                this.mapper = v;
            });
            this.ifNotNullAndSameType(data.get("query"), mapString, v -> {
                this.query = v;
            });
            this.ifNotNullAndSameType(data.get("processors"), mapProcessors, v -> {
                this.processors = v;
            });
            this.ifNotNullAndSameType(data.get("alertings"), mapAlerts, v -> {
                this.alertings = v;
            });
        }
    }

    public SimpleEventBuilder addName(String name) {
        this.name = name;
        return this;
    }

    public SimpleEventBuilder addFrom(String from) {
        this.from = from;
        return this;
    }

    public SimpleEventBuilder addParent(String parent) {
        this.parent = parent;
        return this;
    }

    public SimpleEventBuilder addUntil(String until) {
        this.until = until;
        return this;
    }

    public SimpleEventBuilder addScheduler(String scheduler) {
        this.scheduler = scheduler;
        return this;
    }

    public SimpleEventBuilder addMapper(String mapper) {
        this.mapper = mapper;
        return this;
    }

    public SimpleEventBuilder addProvider(String provider) {
        this.provider = provider;
        return this;
    }

    public SimpleEventBuilder addProcessors(List<ProcessorModel> processors) {
        this.processors = processors;
        return this;
    }

    public SimpleEventBuilder addProcessors(ProcessorModel ... processors) {
        List<ProcessorModel> data = Arrays.asList(processors);
        if (this.processors == null) {
            this.processors = data;
        } else {
            this.processors.addAll(data);
        }
        return this;
    }

    public SimpleEventBuilder addAlertings(List<AlertingModel> alertings) {
        this.alertings = alertings;
        return this;
    }

    public SimpleEventBuilder addAlerting(AlertingModel alerting) {
        if (this.alertings == null) {
            this.alertings = new ArrayList<AlertingModel>();
        }
        if (alerting != null) {
            this.alertings.add(alerting);
        }
        return this;
    }

    public SimpleEventBuilder addQuery(String query) {
        this.query = query;
        return this;
    }

    public SimpleEvent build() {
        return new SimpleEvent(this.name, this.from, this.until, this.provider, this.processors, this.query, this.parent, this.scheduler, this.mapper, this.alertings);
    }
}

