/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.models.events;

import io.inugami.api.models.Builder;
import io.inugami.api.models.events.AlertingModel;
import io.inugami.api.models.events.TargetConfig;
import io.inugami.api.processors.ProcessorModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TargetConfigBuilder
implements Builder<TargetConfig> {
    private String name;
    private String from;
    private String until;
    private String provider;
    private List<ProcessorModel> processors;
    private String query;
    private String parent;
    private String mapper;
    private List<AlertingModel> alertings;

    public static TargetConfigBuilder builder() {
        return new TargetConfigBuilder();
    }

    public TargetConfigBuilder() {
    }

    public TargetConfigBuilder(TargetConfig event) {
        this.name = event.getName();
        this.query = event.getQuery();
        event.getFrom().ifPresent(value -> {
            this.from = value;
        });
        event.getUntil().ifPresent(value -> {
            this.until = value;
        });
        event.getProvider().ifPresent(value -> {
            this.provider = value;
        });
        event.getProcessors().ifPresent(value -> {
            this.processors = value;
        });
        event.getParent().ifPresent(value -> {
            this.parent = value;
        });
        event.getFrom().ifPresent(value -> {
            this.from = value;
        });
        event.getAlertings().ifPresent(s -> {
            this.alertings = s;
        });
    }

    public TargetConfigBuilder addName(String name) {
        this.name = name;
        return this;
    }

    public TargetConfigBuilder addFrom(String from) {
        this.from = from;
        return this;
    }

    public TargetConfigBuilder addUntil(String until) {
        this.until = until;
        return this;
    }

    public TargetConfigBuilder addMapper(String mapper) {
        this.mapper = mapper;
        return this;
    }

    public TargetConfigBuilder addProvider(String provider) {
        this.provider = provider;
        return this;
    }

    public TargetConfigBuilder addProcessors(List<ProcessorModel> processors) {
        this.processors = processors;
        return this;
    }

    public TargetConfigBuilder addProcessors(ProcessorModel ... processors) {
        List<ProcessorModel> data = Arrays.asList(processors);
        if (this.processors == null) {
            this.processors = data;
        } else {
            this.processors.addAll(data);
        }
        return this;
    }

    public TargetConfigBuilder addAlertings(List<AlertingModel> alertings) {
        this.alertings = alertings;
        return this;
    }

    public TargetConfigBuilder addAlerting(AlertingModel alerting) {
        if (this.alertings == null) {
            this.alertings = new ArrayList<AlertingModel>();
        }
        if (alerting != null) {
            this.alertings.add(alerting);
        }
        return this;
    }

    public TargetConfigBuilder addQuery(String query) {
        this.query = query;
        return this;
    }

    public TargetConfig build() {
        return new TargetConfig(this.name, this.from, this.until, this.provider, this.processors, this.query, this.parent, null, this.mapper, this.alertings);
    }
}

