/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.models.plugins;

import java.io.File;
import java.io.Serializable;
import java.net.URL;

public final class ManifestInfo
implements Serializable {
    private static final long serialVersionUID = -7900064144760028719L;
    private File workspace;
    private URL manifestUrl;

    public ManifestInfo(String workspace) {
        this.workspace = workspace == null ? null : new File(workspace);
        this.manifestUrl = null;
    }

    public ManifestInfo(ManifestInfo manifest, URL manifestUrl) {
        this.workspace = manifest.getWorkspace();
        this.manifestUrl = manifestUrl;
    }

    public static ManifestInfoBuilder builder() {
        return new ManifestInfoBuilder();
    }

    public ManifestInfoBuilder toBuilder() {
        return new ManifestInfoBuilder().workspace(this.workspace).manifestUrl(this.manifestUrl);
    }

    public String toString() {
        return "ManifestInfo()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof ManifestInfo;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public void setWorkspace(File workspace) {
        this.workspace = workspace;
    }

    public void setManifestUrl(URL manifestUrl) {
        this.manifestUrl = manifestUrl;
    }

    public File getWorkspace() {
        return this.workspace;
    }

    public URL getManifestUrl() {
        return this.manifestUrl;
    }

    public ManifestInfo() {
    }

    public ManifestInfo(File workspace, URL manifestUrl) {
        this.workspace = workspace;
        this.manifestUrl = manifestUrl;
    }

    public static class ManifestInfoBuilder {
        private File workspace;
        private URL manifestUrl;

        ManifestInfoBuilder() {
        }

        public ManifestInfoBuilder workspace(File workspace) {
            this.workspace = workspace;
            return this;
        }

        public ManifestInfoBuilder manifestUrl(URL manifestUrl) {
            this.manifestUrl = manifestUrl;
            return this;
        }

        public ManifestInfo build() {
            return new ManifestInfo(this.workspace, this.manifestUrl);
        }

        public String toString() {
            return "ManifestInfo.ManifestInfoBuilder(workspace=" + this.workspace + ", manifestUrl=" + this.manifestUrl + ")";
        }
    }
}

