/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.models.tools;

import io.inugami.api.exceptions.tools.StrategyException;
import io.inugami.api.models.tools.Strategy;
import java.util.function.Function;

public class DefaultStrategy<IN, OUT>
implements Strategy<IN, OUT> {
    private final Function<IN, Boolean> accept;
    private final Function<IN, OUT> process;

    @Override
    public boolean accept(IN inputData) {
        return this.accept == null || this.accept.apply(inputData) != false;
    }

    @Override
    public OUT process(IN inputData) throws StrategyException {
        return this.process == null ? null : (OUT)this.process.apply(inputData);
    }

    public static <IN, OUT> DefaultStrategyBuilder<IN, OUT> builder() {
        return new DefaultStrategyBuilder();
    }

    public DefaultStrategyBuilder<IN, OUT> toBuilder() {
        return new DefaultStrategyBuilder().accept(this.accept).process(this.process);
    }

    public DefaultStrategy(Function<IN, Boolean> accept, Function<IN, OUT> process) {
        this.accept = accept;
        this.process = process;
    }

    public static class DefaultStrategyBuilder<IN, OUT> {
        private Function<IN, Boolean> accept;
        private Function<IN, OUT> process;

        DefaultStrategyBuilder() {
        }

        public DefaultStrategyBuilder<IN, OUT> accept(Function<IN, Boolean> accept) {
            this.accept = accept;
            return this;
        }

        public DefaultStrategyBuilder<IN, OUT> process(Function<IN, OUT> process) {
            this.process = process;
            return this;
        }

        public DefaultStrategy<IN, OUT> build() {
            return new DefaultStrategy<IN, OUT>(this.accept, this.process);
        }

        public String toString() {
            return "DefaultStrategy.DefaultStrategyBuilder(accept=" + this.accept + ", process=" + this.process + ")";
        }
    }
}

