/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.models.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.UnaryOperator;

public class FixSizeList<T>
extends ArrayList<T> {
    private static final long serialVersionUID = -5757831411643911290L;
    private final int capacity;

    public FixSizeList(int initialCapacity) {
        super(initialCapacity);
        this.capacity = initialCapacity;
    }

    @Override
    public boolean add(T e) {
        if (this.size() >= this.capacity) {
            this.remove(0);
        }
        return super.add(e);
    }

    @Override
    public void add(int index, T element) {
        throw new IllegalAccessError("You can't insert element!");
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean result = false;
        if (c != null) {
            c.forEach(this::add);
            result = true;
        }
        return result;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new IllegalAccessError("You can't insert elements!");
    }

    @Override
    public T set(int index, T element) {
        throw new IllegalAccessError("You can't use set!");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new IllegalAccessError("You can't use retainAll!");
    }

    @Override
    public void replaceAll(UnaryOperator<T> operator) {
        throw new IllegalAccessError("You can't use replaceAll!");
    }
}

