/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.models.tools;

import io.inugami.api.exceptions.tools.StrategyException;
import io.inugami.api.models.tools.Strategy;
import java.util.regex.Pattern;

public class StringPatternStrategy
implements Strategy<String, String> {
    private final boolean acceptAll;
    private final Pattern pattern;
    private final String result;

    public StringPatternStrategy(String result) {
        this.acceptAll = true;
        this.pattern = null;
        this.result = result;
    }

    public StringPatternStrategy(String pattern, String result) {
        this.acceptAll = pattern == null;
        this.pattern = pattern == null ? null : Pattern.compile(pattern);
        this.result = result;
    }

    @Override
    public boolean accept(String inputData) {
        return this.acceptAll ? this.acceptAll : this.pattern.matcher(inputData).matches();
    }

    @Override
    public String process(String inputData) throws StrategyException {
        return this.result;
    }

    public boolean isAcceptAll() {
        return this.acceptAll;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public String getResult() {
        return this.result;
    }

    public String toString() {
        return "StringPatternStrategy(acceptAll=" + this.isAcceptAll() + ", pattern=" + this.getPattern() + ", result=" + this.getResult() + ")";
    }
}

