/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.monitoring;

import io.inugami.api.exceptions.DefaultErrorCode;
import io.inugami.api.exceptions.ErrorCode;
import io.inugami.api.functionnals.FunctionalUtils;
import io.inugami.api.functionnals.VoidFunctionWithException;
import io.inugami.api.listeners.ApplicationLifecycleSPI;
import io.inugami.api.listeners.DefaultApplicationLifecycleSPI;
import io.inugami.api.loggers.mdc.mapper.LoggerMdcMappingSPI;
import io.inugami.api.models.Tuple;
import io.inugami.api.monitoring.RequestContext;
import io.inugami.api.monitoring.RequestInformation;
import io.inugami.api.monitoring.models.Headers;
import io.inugami.api.monitoring.models.IoInfoDTO;
import io.inugami.api.processors.ConfigHandler;
import io.inugami.api.spi.SpiLoader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class MdcService
implements ApplicationLifecycleSPI {
    private static final Logger log = LoggerFactory.getLogger(MdcService.class);
    private static final String X_B_3_TRACE_ID = "X-B3-TraceId";
    public static final String ISO_DATE = "yyyy-MM-dd'T'HH:mm:ss.sss";
    public static final String CALL_TYPE_REST = "REST";
    public static final String CALL_TYPE_JMS = "JMS";
    public static final String CALL_TYPE_RABBITMQ = "RABBITMQ";
    private static final String DEFAULT_STRING_VALUE = "xxxx";
    private static final String SEP = ";";
    private static final String IN = "in";
    private static final String OUT = "out";
    private static final String SUCCESS = "success";
    private static final String ERROR = "error";
    public static final String NULL = "null";
    private Headers headers;
    private List<LoggerMdcMappingSPI> mdcMappers = SpiLoader.getInstance().loadSpiServicesByPriority(LoggerMdcMappingSPI.class);
    private static final MdcService INSTANCE = new MdcService();

    private MdcService() {
        DefaultApplicationLifecycleSPI.register(this);
        this.headers = new Headers().refreshConfig();
    }

    public void onConfigurationReady(ConfigHandler<String, String> configuration) {
        this.headers = new Headers().refreshConfig(configuration);
    }

    public void onContextRefreshed(Object event) {
        this.mdcMappers = SpiLoader.getInstance().loadSpiServicesByPriority(LoggerMdcMappingSPI.class);
    }

    public static MdcService getInstance() {
        return INSTANCE;
    }

    public void initialize() {
        RequestInformation requestContext = RequestContext.getInstance();
        this.setMdc(MDCKeys.env, (Serializable)((Object)requestContext.getEnv()));
        this.setMdc(MDCKeys.asset, (Serializable)((Object)requestContext.getAsset()));
        this.setMdc(MDCKeys.hostname, (Serializable)((Object)requestContext.getHostname()));
        this.setMdc(MDCKeys.instanceName, (Serializable)((Object)requestContext.getInstanceName()));
        this.setMdc(MDCKeys.instanceNumber, (Serializable)((Object)requestContext.getInstanceNumber()));
        this.setMdc(MDCKeys.correlation_id, (Serializable)((Object)requestContext.getCorrelationId()));
        this.setMdc(MDCKeys.request_id, (Serializable)((Object)requestContext.getRequestId()));
        this.setMdc(MDCKeys.traceId, (Serializable)((Object)requestContext.getTraceId()));
        this.setMdc(MDCKeys.conversation_id, (Serializable)((Object)requestContext.getConversationId()));
        this.setMdc(MDCKeys.sessionId, (Serializable)((Object)requestContext.getSessionId()));
        this.setMdc(MDCKeys.applicationVersion, (Serializable)((Object)requestContext.getApplicationVersion()));
        this.setMdc(MDCKeys.callFrom, (Serializable)((Object)requestContext.getCallFrom()));
        this.setMdc(MDCKeys.deviceIdentifier, (Serializable)((Object)requestContext.getDeviceIdentifier()));
        this.setMdc(MDCKeys.deviceType, (Serializable)((Object)requestContext.getDeviceType()));
        this.setMdc(MDCKeys.deviceClass, (Serializable)((Object)requestContext.getDeviceClass()));
        this.setMdc(MDCKeys.version, (Serializable)((Object)requestContext.getVersion()));
        this.setMdc(MDCKeys.majorVersion, (Serializable)((Object)requestContext.getMajorVersion()));
        this.setMdc(MDCKeys.osVersion, (Serializable)((Object)requestContext.getOsVersion()));
        this.setMdc(MDCKeys.deviceNetworkType, (Serializable)((Object)requestContext.getDeviceNetworkType()));
        this.setMdc(MDCKeys.deviceNetworkSpeedDown, (Serializable)((Object)String.valueOf(requestContext.getDeviceNetworkSpeedDown())));
        this.setMdc(MDCKeys.deviceNetworkSpeedUp, (Serializable)((Object)String.valueOf(requestContext.getDeviceNetworkSpeedUp())));
        this.setMdc(MDCKeys.deviceNetworkSpeedLatency, (Serializable)((Object)String.valueOf(requestContext.getDeviceNetworkSpeedLatency())));
        this.setMdc(MDCKeys.remoteAddress, (Serializable)((Object)requestContext.getRemoteAddress()));
        this.setMdc(MDCKeys.deviceIp, (Serializable)((Object)requestContext.getDeviceIp()));
        this.setMdc(MDCKeys.userAgent, (Serializable)((Object)requestContext.getUserAgent()));
        this.setMdc(MDCKeys.language, (Serializable)((Object)requestContext.getLanguage()));
        this.setMdc(MDCKeys.country, (Serializable)((Object)requestContext.getCountry()));
        this.setMdc(MDCKeys.service, (Serializable)((Object)requestContext.getService()));
        if (requestContext.getSpecific() != null) {
            for (Map.Entry<String, String> entry : requestContext.getSpecific().entrySet()) {
                if (entry.getKey() == null) continue;
                MDC.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public MdcService setMdc(Map<String, Serializable> values) {
        if (values == null) {
            return this;
        }
        for (Map.Entry<String, Serializable> value : values.entrySet()) {
            this.setMdc(value.getKey(), value.getValue());
        }
        return this;
    }

    public MdcService setMdc(MDCKeys key, Serializable value) {
        if (key == null) {
            return this;
        }
        if (MdcService.isNull(value)) {
            this.remove(key);
            return this;
        }
        return this.setMdc(key.getCurrentName(), value);
    }

    private static boolean isNull(Serializable value) {
        return value == null || NULL.equals(value) || String.valueOf(value).isEmpty();
    }

    public MdcService setMdc(String key, Serializable value) {
        if (MdcService.isNull(value)) {
            this.remove(key);
            return this;
        }
        if (value instanceof Date) {
            MDC.put((String)key, (String)new SimpleDateFormat(ISO_DATE).format((Date)value));
        } else if (value instanceof Calendar) {
            MDC.put((String)key, (String)new SimpleDateFormat(ISO_DATE).format(((Calendar)value).getTime()));
        } else if (value instanceof LocalDateTime) {
            MDC.put((String)key, (String)((LocalDateTime)value).format(DateTimeFormatter.ISO_DATE_TIME));
        } else if (value instanceof LocalDate) {
            MDC.put((String)key, (String)((LocalDate)value).format(DateTimeFormatter.ISO_DATE));
        } else {
            MDC.put((String)key, (String)String.valueOf(value));
        }
        return this;
    }

    public MdcService addMdc(Tuple<String, Serializable> ... keys) {
        if (keys != null) {
            for (Tuple<String, Serializable> key : keys) {
                this.setMdc(key.getKey(), key.getValue());
            }
        }
        return this;
    }

    public MdcService addMdc(Collection<Tuple<String, Serializable>> keys) {
        if (keys != null) {
            for (Tuple<String, Serializable> key : keys) {
                this.setMdc(key.getKey(), key.getValue());
            }
        }
        return this;
    }

    public String getMdc(MDCKeys key) {
        if (key == null) {
            return null;
        }
        return this.getMdc(key.getCurrentName());
    }

    public String getMdc(String key) {
        if (key == null) {
            return null;
        }
        return MDC.get((String)key);
    }

    public boolean getBoolean(MDCKeys key) {
        return key == null ? false : this.getBoolean(key.name());
    }

    public boolean getBoolean(String key) {
        String value = this.getMdc(key);
        return Boolean.parseBoolean(value);
    }

    private int getInt(MDCKeys key) {
        return key == null ? 0 : this.getInt(key.name());
    }

    private int getInt(String key) {
        try {
            String value = this.getMdc(key);
            return value == null ? 0 : Integer.parseInt(value);
        }
        catch (Throwable e) {
            return 0;
        }
    }

    private long getLong(MDCKeys key) {
        return key == null ? 0L : this.getLong(key.name());
    }

    private long getLong(String key) {
        try {
            String value = this.getMdc(key);
            return value == null ? 0L : Long.parseLong(value);
        }
        catch (Throwable e) {
            return 0L;
        }
    }

    private double getDouble(MDCKeys key) {
        return key == null ? 0.0 : this.getDouble(key.name());
    }

    private double getDouble(String key) {
        if (key == null) {
            return 0.0;
        }
        try {
            String value = this.getMdc(key);
            return value == null ? 0.0 : Double.parseDouble(value);
        }
        catch (Throwable e) {
            return 0.0;
        }
    }

    public Charset getCharset(MDCKeys key) {
        return key == null ? null : this.getCharset(key.name());
    }

    public Charset getCharset(String key) {
        if (key == null) {
            return null;
        }
        String value = this.getMdc(key);
        Charset result = null;
        if (value != null) {
            try {
                result = Charset.forName(value);
            }
            catch (Throwable e) {
                result = StandardCharsets.UTF_8;
            }
        }
        return result;
    }

    public LocalDateTime getLocalDateTime(MDCKeys key) {
        return key == null ? null : this.getLocalDateTime(key.name());
    }

    public LocalDateTime getLocalDateTime(String key) {
        if (key == null) {
            return null;
        }
        LocalDateTime result = null;
        String value = this.getMdc(key);
        if (value != null) {
            try {
                result = LocalDateTime.parse(value);
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
            }
        }
        return result;
    }

    public Map<String, String> getAllMdc() {
        return MDC.getCopyOfContextMap();
    }

    public Map<String, Serializable> getAllMdcExtended() {
        LinkedHashMap<String, Serializable> result = new LinkedHashMap<String, Serializable>();
        Map<String, String> standardMdc = this.getAllMdc();
        if (this.mdcMappers == null) {
            result.putAll(standardMdc);
        } else {
            for (Map.Entry<String, String> entry : standardMdc.entrySet()) {
                for (LoggerMdcMappingSPI mapper : this.mdcMappers) {
                    if (!mapper.accept(entry.getKey())) continue;
                    result.put(entry.getKey(), mapper.convert(entry.getValue()));
                }
            }
        }
        return result;
    }

    public MdcService remove(MDCKeys ... keys) {
        if (keys != null) {
            for (MDCKeys key : keys) {
                MDC.remove((String)key.name());
            }
        }
        return this;
    }

    public MdcService remove(String ... keys) {
        if (keys != null) {
            for (String key : keys) {
                MDC.remove((String)key);
            }
        }
        return this;
    }

    public MdcService clear() {
        MDC.clear();
        return this;
    }

    public MdcService appClass(String value) {
        this.setMdc(MDCKeys.appClass, (Serializable)((Object)value));
        return this;
    }

    public String appClass() {
        return this.getMdc(MDCKeys.appClass);
    }

    public MdcService appClassShortName(String value) {
        this.setMdc(MDCKeys.appClassShortName, (Serializable)((Object)value));
        return this;
    }

    public String appClassShortName() {
        return this.getMdc(MDCKeys.appClassShortName);
    }

    public MdcService domain(String value) {
        this.setMdc(MDCKeys.domain, (Serializable)((Object)value));
        return this;
    }

    public String domain() {
        return this.getMdc(MDCKeys.domain);
    }

    public MdcService subDomain(String value) {
        this.setMdc(MDCKeys.subDomain, (Serializable)((Object)value));
        return this;
    }

    public String subDomain() {
        return this.getMdc(MDCKeys.subDomain);
    }

    public MdcService appMethod(String value) {
        this.setMdc(MDCKeys.appMethod, (Serializable)((Object)value));
        return this;
    }

    public String appMethod() {
        return this.getMdc(MDCKeys.appMethod);
    }

    public MdcService appService(String value) {
        this.setMdc(MDCKeys.appService, (Serializable)((Object)value));
        return this;
    }

    public String appService() {
        return this.getMdc(MDCKeys.appService);
    }

    public MdcService appSubService(String value) {
        this.setMdc(MDCKeys.appSubService, (Serializable)((Object)value));
        return this;
    }

    public String appSubService() {
        return this.getMdc(MDCKeys.appSubService);
    }

    public MdcService applicationVersion(String value) {
        this.setMdc(MDCKeys.applicationVersion, (Serializable)((Object)value));
        return this;
    }

    public String applicationVersion() {
        return this.getMdc(MDCKeys.applicationVersion);
    }

    public MdcService asset(String value) {
        this.setMdc(MDCKeys.asset, (Serializable)((Object)value));
        return this;
    }

    public String asset() {
        return this.getMdc(MDCKeys.asset);
    }

    public MdcService authProtocol(String value) {
        this.setMdc(MDCKeys.authProtocol, (Serializable)((Object)value));
        return this;
    }

    public String authProtocol() {
        return this.getMdc(MDCKeys.authProtocol);
    }

    public MdcService callFrom(String value) {
        this.setMdc(MDCKeys.callFrom, (Serializable)((Object)value));
        return this;
    }

    public String callFrom() {
        return this.getMdc(MDCKeys.callFrom);
    }

    public MdcService callType(String value) {
        this.setMdc(MDCKeys.callType, (Serializable)((Object)value));
        return this;
    }

    public String callType() {
        return this.getMdc(MDCKeys.callType);
    }

    public MdcService conversationId(String value) {
        this.setMdc(MDCKeys.conversation_id, (Serializable)((Object)value));
        return this;
    }

    public String conversationId() {
        return this.getMdc(MDCKeys.conversation_id);
    }

    public MdcService correlationId(String value) {
        this.setMdc(MDCKeys.correlation_id, (Serializable)((Object)value));
        return this;
    }

    public String correlationId() {
        String value = this.getMdc(MDCKeys.correlation_id);
        if (value == null) {
            value = UUID.randomUUID().toString();
            this.correlationId(value);
        }
        return value;
    }

    public MdcService country(String value) {
        this.setMdc(MDCKeys.country, (Serializable)((Object)value));
        return this;
    }

    public String country() {
        return this.getMdc(MDCKeys.country);
    }

    public MdcService customerId(String value) {
        this.setMdc(MDCKeys.customerId, (Serializable)((Object)value));
        return this;
    }

    public String customerId() {
        return this.getMdc(MDCKeys.customerId);
    }

    public MdcService deviceClass(String value) {
        this.setMdc(MDCKeys.deviceClass, (Serializable)((Object)value));
        return this;
    }

    public String deviceClass() {
        return this.getMdc(MDCKeys.deviceClass);
    }

    public MdcService deviceIdentifier(String value) {
        this.setMdc(MDCKeys.deviceIdentifier, (Serializable)((Object)value));
        return this;
    }

    public String deviceIdentifier() {
        return this.getMdc(MDCKeys.deviceIdentifier);
    }

    public MdcService deviceIp(String value) {
        this.setMdc(MDCKeys.deviceIp, (Serializable)((Object)value));
        return this;
    }

    public String deviceIp() {
        return this.getMdc(MDCKeys.deviceIp);
    }

    public MdcService deviceNetworkSpeedDown(double value) {
        this.setMdc(MDCKeys.deviceNetworkSpeedDown, (Serializable)Double.valueOf(value));
        return this;
    }

    public double deviceNetworkSpeedDown() {
        return this.getDouble(MDCKeys.deviceNetworkSpeedDown);
    }

    public MdcService deviceNetworkSpeedLatency(double value) {
        this.setMdc(MDCKeys.deviceNetworkSpeedLatency, (Serializable)Double.valueOf(value));
        return this;
    }

    public double deviceNetworkSpeedLatency() {
        return this.getDouble(MDCKeys.deviceNetworkSpeedLatency);
    }

    public MdcService deviceNetworkSpeedUp(double value) {
        this.setMdc(MDCKeys.deviceNetworkSpeedUp, (Serializable)Double.valueOf(value));
        return this;
    }

    public double deviceNetworkSpeedUp() {
        return this.getDouble(MDCKeys.deviceNetworkSpeedUp);
    }

    public MdcService deviceNetworkType(String value) {
        this.setMdc(MDCKeys.deviceNetworkType, (Serializable)((Object)value));
        return this;
    }

    public String deviceNetworkType() {
        return this.getMdc(MDCKeys.deviceNetworkType);
    }

    public MdcService deviceType(String value) {
        this.setMdc(MDCKeys.deviceType, (Serializable)((Object)value));
        return this;
    }

    public String deviceType() {
        return this.getMdc(MDCKeys.deviceType);
    }

    public MdcService duration(long value) {
        this.setMdc(MDCKeys.duration, (Serializable)Long.valueOf(value));
        return this;
    }

    public long duration() {
        return this.getLong(MDCKeys.duration);
    }

    public MdcService env(String value) {
        this.setMdc(MDCKeys.env, (Serializable)((Object)value));
        return this;
    }

    public String env() {
        return this.getMdc(MDCKeys.env);
    }

    public MdcService errorCategory(String value) {
        this.setMdc(MDCKeys.errorCategory, (Serializable)((Object)value));
        return this;
    }

    public String errorCategory() {
        return this.getMdc(MDCKeys.errorCategory);
    }

    public MdcService errorCode(String value) {
        this.setMdc(MDCKeys.errorCode, (Serializable)((Object)value));
        return this;
    }

    public boolean hasError() {
        return this.errorCode() != null;
    }

    public MdcService errorCode(ErrorCode errorCode) {
        if (errorCode == null) {
            this.errorCodeRemove();
            return this;
        }
        for (Map.Entry entry : errorCode.toMap().entrySet()) {
            if ("errorStatus".equals(entry.getKey())) {
                this.setMdc((String)entry.getKey(), entry.getValue() == null ? Integer.valueOf(500) : (Serializable)entry.getValue());
                continue;
            }
            this.setMdc((String)entry.getKey(), (Serializable)entry.getValue());
        }
        return this;
    }

    public MdcService errorCodeRemove() {
        for (String key : ErrorCode.KEYS_SET) {
            this.remove(key);
        }
        return this;
    }

    public ErrorCode errorCode() {
        String code = this.getMdc(MDCKeys.errorCode);
        if (code == null) {
            return null;
        }
        return DefaultErrorCode.buildUndefineErrorCode().errorCode(code).category(this.errorCategory()).statusCode(this.errorStatus()).message(this.errorMessage()).messageDetail(this.errorMessageDetail()).errorType(this.errorType()).retryable(this.errorRetryable()).exploitationError(this.errorExploitationError()).field(this.errorField()).rollback(this.errorRollback()).url(this.errorUrl()).domain(this.errorDomain()).subDomain(this.errorSubDomain()).build();
    }

    public MdcService errorExploitationError(boolean value) {
        this.setMdc(MDCKeys.errorExploitationError, (Serializable)Boolean.valueOf(value));
        return this;
    }

    public boolean errorExploitationError() {
        return this.getBoolean(MDCKeys.errorExploitationError);
    }

    public MdcService errorField(String ... value) {
        if (value == null) {
            this.remove(MDCKeys.errorField);
        }
        this.setMdc(MDCKeys.errorField, (Serializable)((Object)String.join((CharSequence)SEP, value)));
        return this;
    }

    public String errorField() {
        return this.getMdc(MDCKeys.errorField);
    }

    public MdcService errorMessage(String value) {
        this.setMdc(MDCKeys.errorMessage, (Serializable)((Object)value));
        return this;
    }

    public String errorMessage() {
        return this.getMdc(MDCKeys.errorMessage);
    }

    public MdcService errorMessageDetail(String value) {
        this.setMdc(MDCKeys.errorMessageDetail, (Serializable)((Object)value));
        return this;
    }

    public String errorMessageDetail() {
        return this.getMdc(MDCKeys.errorMessageDetail);
    }

    public MdcService errorRetryable(boolean value) {
        this.setMdc(MDCKeys.errorRetryable, (Serializable)Boolean.valueOf(value));
        return this;
    }

    public boolean errorRetryable() {
        return this.getBoolean(MDCKeys.errorRetryable);
    }

    public MdcService errorRollback(boolean value) {
        this.setMdc(MDCKeys.errorRollback, (Serializable)Boolean.valueOf(value));
        return this;
    }

    public boolean errorRollback() {
        return this.getBoolean(MDCKeys.errorRollback);
    }

    public MdcService errorStatus(int value) {
        this.setMdc(MDCKeys.errorStatus, (Serializable)Integer.valueOf(value));
        return this;
    }

    public int errorStatus() {
        return this.getInt(MDCKeys.errorStatus);
    }

    public MdcService errorType(String value) {
        this.setMdc(MDCKeys.errorType, (Serializable)((Object)value));
        return this;
    }

    public String errorType() {
        return this.getMdc(MDCKeys.errorType);
    }

    public MdcService errorUrl(String value) {
        this.setMdc(MDCKeys.errorUrl, (Serializable)((Object)value));
        return this;
    }

    public String errorUrl() {
        return this.getMdc(MDCKeys.errorUrl);
    }

    public MdcService exceptionName(String value) {
        this.setMdc(MDCKeys.exceptionName, (Serializable)((Object)value));
        return this;
    }

    public MdcService errorDomain(String value) {
        this.setMdc(MDCKeys.errorDomain, (Serializable)((Object)value));
        return this;
    }

    public String errorDomain() {
        return this.getMdc(MDCKeys.errorDomain);
    }

    public MdcService errorSubDomain(String value) {
        this.setMdc(MDCKeys.errorSubDomain, (Serializable)((Object)value));
        return this;
    }

    public String errorSubDomain() {
        return this.getMdc(MDCKeys.errorSubDomain);
    }

    public String exceptionName() {
        return this.getMdc(MDCKeys.exceptionName);
    }

    public MdcService flags(String value) {
        this.setMdc(MDCKeys.flags, (Serializable)((Object)value));
        return this;
    }

    public String flags() {
        return this.getMdc(MDCKeys.flags);
    }

    public MdcService from(LocalDateTime value) {
        this.setMdc(MDCKeys.from, (Serializable)value);
        return this;
    }

    public LocalDateTime from() {
        return this.getLocalDateTime(MDCKeys.from);
    }

    public MdcService groupId(String value) {
        this.setMdc(MDCKeys.groupId, (Serializable)((Object)value));
        return this;
    }

    public String groupId() {
        return this.getMdc(MDCKeys.groupId);
    }

    public MdcService artifactId(String value) {
        this.setMdc(MDCKeys.artifactId, (Serializable)((Object)value));
        return this;
    }

    public String artifactId() {
        return this.getMdc(MDCKeys.artifactId);
    }

    public MdcService commitId(String value) {
        this.setMdc(MDCKeys.commitId, (Serializable)((Object)value));
        return this;
    }

    public String commitId() {
        return this.getMdc(MDCKeys.commitId);
    }

    public MdcService commitDate(String value) {
        this.setMdc(MDCKeys.commitDate, (Serializable)((Object)value));
        return this;
    }

    public String commitDate() {
        return this.getMdc(MDCKeys.commitDate);
    }

    public MdcService fromTimestamp(long value) {
        this.setMdc(MDCKeys.fromTimestamp, (Serializable)Long.valueOf(value));
        return this;
    }

    public long fromTimestamp() {
        return this.getLong(MDCKeys.fromTimestamp);
    }

    public MdcService functionalUid(String value) {
        this.setMdc(MDCKeys.functionalUid, (Serializable)((Object)value));
        return this;
    }

    public String functionalUid() {
        return this.getMdc(MDCKeys.functionalUid);
    }

    public MdcService globalStatus(String value) {
        this.setMdc(MDCKeys.globalStatus, (Serializable)((Object)value));
        return this;
    }

    public String globalStatus() {
        return this.getMdc(MDCKeys.globalStatus);
    }

    public void globalStatusSuccess() {
        this.setMdc(MDCKeys.globalStatus, (Serializable)((Object)SUCCESS));
    }

    public void globalStatusError() {
        this.setMdc(MDCKeys.globalStatus, (Serializable)((Object)ERROR));
    }

    public MdcService removeGlobalStatus() {
        this.remove(MDCKeys.globalStatus);
        return this;
    }

    public MdcService healthStatus(String value) {
        this.setMdc(MDCKeys.healthStatus, (Serializable)((Object)value));
        return this;
    }

    public String healthStatus() {
        return this.getMdc(MDCKeys.healthStatus);
    }

    public MdcService hostname(String value) {
        this.setMdc(MDCKeys.hostname, (Serializable)((Object)value));
        return this;
    }

    public String hostname() {
        return this.getMdc(MDCKeys.hostname);
    }

    public MdcService httpStatus(int value) {
        this.setMdc(MDCKeys.httpStatus, (Serializable)Integer.valueOf(value));
        return this;
    }

    public int httpStatus() {
        return this.getInt(MDCKeys.httpStatus);
    }

    public MdcService instanceName(String value) {
        this.setMdc(MDCKeys.instanceName, (Serializable)((Object)value));
        return this;
    }

    public String instanceName() {
        return this.getMdc(MDCKeys.instanceName);
    }

    public MdcService instanceNumber(String value) {
        this.setMdc(MDCKeys.instanceNumber, (Serializable)((Object)value));
        return this;
    }

    public String instanceNumber() {
        return this.getMdc(MDCKeys.instanceNumber);
    }

    public MdcService ioinfoIoLog(IoInfoDTO info) {
        if (info == null) {
            return this.removeIoinfoIoLog();
        }
        this.url(info.getUrl());
        this.verb(info.getMethod());
        this.service(info.getPartnerService());
        this.appSubService(info.getPartnerSubService());
        this.status(info.getStatus());
        this.duration(info.getDuration());
        return this;
    }

    private MdcService removeIoinfoIoLog() {
        this.remove(MDCKeys.url, MDCKeys.verb, MDCKeys.service, MDCKeys.appSubService, MDCKeys.status, MDCKeys.duration);
        return this;
    }

    public MdcService ioinfoPartner(IoInfoDTO info) {
        if (info == null) {
            return this.removeIoinfoPartner();
        }
        this.partner(info.getPartnerName());
        this.partnerUrl(info.getUrl());
        this.partnerVerb(info.getMethod());
        this.partnerService(info.getPartnerService());
        this.partnerSubService(info.getPartnerSubService());
        this.partnerRequestCharset(info.getRequestCharset());
        this.partnerResponseStatus(info.getStatus());
        this.partnerResponseCharset(info.getResponseCharset());
        this.partnerResponseDuration(info.getDuration());
        this.partnerResponseMessage(info.getMessage());
        return this;
    }

    public MdcService partnerRemove() {
        return this.removeIoinfoPartner();
    }

    public MdcService removeIoinfoPartner() {
        this.remove(MDCKeys.errorCategory, MDCKeys.errorCode, MDCKeys.errorExploitationError, MDCKeys.errorField, MDCKeys.errorMessage, MDCKeys.errorMessageDetail, MDCKeys.errorRetryable, MDCKeys.errorRollback, MDCKeys.errorStatus, MDCKeys.errorType, MDCKeys.errorUrl, MDCKeys.exceptionName, MDCKeys.errorDomain, MDCKeys.errorSubDomain, MDCKeys.partner, MDCKeys.partnerRequestCharset, MDCKeys.partnerResponseCharset, MDCKeys.partnerResponseDuration, MDCKeys.partnerResponseMessage, MDCKeys.partnerResponseStatus, MDCKeys.partnerService, MDCKeys.partnerSubService, MDCKeys.partnerType, MDCKeys.partnerUrl, MDCKeys.partnerVerb, MDCKeys.lifecycle, MDCKeys.duration);
        return this;
    }

    public MdcService language(String value) {
        this.setMdc(MDCKeys.language, (Serializable)((Object)value));
        return this;
    }

    public String language() {
        return this.getMdc(MDCKeys.language);
    }

    public MdcService lifecycle(String value) {
        this.setMdc(MDCKeys.lifecycle, (Serializable)((Object)value));
        return this;
    }

    public String lifecycle() {
        return this.getMdc(MDCKeys.lifecycle);
    }

    public MdcService lifecycleIn() {
        this.setMdc(MDCKeys.lifecycle, (Serializable)((Object)IN));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exception lifecycleIn(VoidFunctionWithException function) {
        Exception error = null;
        if (function != null) {
            this.lifecycleIn();
            try {
                function.process();
            }
            catch (Exception e) {
                error = e;
            }
            finally {
                this.lifecycleRemove();
            }
        }
        return error;
    }

    public MdcService lifecycleOut() {
        this.setMdc(MDCKeys.lifecycle, (Serializable)((Object)OUT));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exception lifecycleOut(VoidFunctionWithException function) {
        Exception error = null;
        if (function != null) {
            this.lifecycleOut();
            try {
                function.process();
            }
            catch (Exception e) {
                error = e;
            }
            finally {
                this.lifecycleRemove();
            }
        }
        return error;
    }

    public MdcService lifecycleRemove() {
        this.remove(MDCKeys.lifecycle);
        return this;
    }

    public MdcService majorVersion(String value) {
        this.setMdc(MDCKeys.majorVersion, (Serializable)((Object)value));
        return this;
    }

    public String majorVersion() {
        return this.getMdc(MDCKeys.majorVersion);
    }

    public MdcService messageId(String value) {
        this.setMdc(MDCKeys.messageId, (Serializable)((Object)value));
        return this;
    }

    public String messageId() {
        return this.getMdc(MDCKeys.messageId);
    }

    public MdcService methodInCause(String value) {
        this.setMdc(MDCKeys.methodInCause, (Serializable)((Object)value));
        return this;
    }

    public String methodInCause() {
        return this.getMdc(MDCKeys.methodInCause);
    }

    public Map<String, String> getTrackingInformation() {
        return this.getTrackingInformation(null);
    }

    public Map<String, String> getTrackingInformation(Headers headers) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        Headers currentHeaders = headers == null ? this.headers : headers;
        FunctionalUtils.applyIfNotNull((Object)this.deviceIdentifier(), value -> result.put(currentHeaders.getDeviceIdentifier(), (String)value));
        FunctionalUtils.applyIfNotNull((Object)this.correlationId(), value -> result.put(currentHeaders.getCorrelationId(), (String)value));
        FunctionalUtils.applyIfNotNull((Object)this.conversationId(), value -> result.put(currentHeaders.getConversationId(), (String)value));
        FunctionalUtils.applyIfNotNull((Object)this.traceId(), value -> result.put(currentHeaders.getRequestId(), (String)value));
        return result;
    }

    public MdcService orderId(String value) {
        this.setMdc(MDCKeys.orderId, (Serializable)((Object)value));
        return this;
    }

    public String orderId() {
        return this.getMdc(MDCKeys.orderId);
    }

    public MdcService osVersion(String value) {
        this.setMdc(MDCKeys.osVersion, (Serializable)((Object)value));
        return this;
    }

    public String osVersion() {
        return this.getMdc(MDCKeys.osVersion);
    }

    public MdcService parentSpanId(String value) {
        this.setMdc(MDCKeys.parentSpanId, (Serializable)((Object)value));
        return this;
    }

    public String parentSpanId() {
        return this.getMdc(MDCKeys.parentSpanId);
    }

    public MdcService partner(String value) {
        this.setMdc(MDCKeys.partner, (Serializable)((Object)value));
        return this;
    }

    public String partner() {
        return this.getMdc(MDCKeys.partner);
    }

    public MdcService partnerRequestCharset(String value) {
        this.setMdc(MDCKeys.partnerRequestCharset, (Serializable)((Object)value));
        return this;
    }

    public MdcService partnerRequestCharset(Charset value) {
        if (value == null) {
            this.remove(MDCKeys.partnerRequestCharset);
        } else {
            this.setMdc(MDCKeys.partnerRequestCharset, (Serializable)((Object)value.name()));
        }
        return this;
    }

    public Charset partnerRequestCharset() {
        return this.getCharset(MDCKeys.partnerRequestCharset);
    }

    public MdcService partnerResponseCharset(String value) {
        this.setMdc(MDCKeys.partnerResponseCharset, (Serializable)((Object)value));
        return this;
    }

    public MdcService partnerResponseCharset(Charset value) {
        if (value == null) {
            this.remove(MDCKeys.partnerResponseCharset);
        } else {
            this.setMdc(MDCKeys.partnerResponseCharset, (Serializable)((Object)value.name()));
        }
        return this;
    }

    public Charset partnerResponseCharset() {
        return this.getCharset(MDCKeys.partnerResponseCharset);
    }

    public MdcService partnerResponseDuration(long value) {
        this.setMdc(MDCKeys.partnerResponseDuration, (Serializable)Long.valueOf(value));
        return this;
    }

    public long partnerResponseDuration() {
        return this.getLong(MDCKeys.partnerResponseDuration);
    }

    public MdcService partnerResponseMessage(String value) {
        this.setMdc(MDCKeys.partnerResponseMessage, (Serializable)((Object)value));
        return this;
    }

    public String partnerResponseMessage() {
        return this.getMdc(MDCKeys.partnerResponseMessage);
    }

    public MdcService partnerResponseStatus(int value) {
        this.setMdc(MDCKeys.partnerResponseStatus, (Serializable)Integer.valueOf(value));
        return this;
    }

    public int partnerResponseStatus() {
        return this.getInt(MDCKeys.partnerResponseStatus);
    }

    public MdcService partnerService(String value) {
        this.setMdc(MDCKeys.partnerService, (Serializable)((Object)value));
        return this;
    }

    public String partnerService() {
        return this.getMdc(MDCKeys.partnerService);
    }

    public MdcService partnerSubService(String value) {
        this.setMdc(MDCKeys.partnerSubService, (Serializable)((Object)value));
        return this;
    }

    public String partnerSubService() {
        return this.getMdc(MDCKeys.partnerSubService);
    }

    public MdcService partnerType(String value) {
        this.setMdc(MDCKeys.partnerType, (Serializable)((Object)value));
        return this;
    }

    public String partnerType() {
        return this.getMdc(MDCKeys.partnerType);
    }

    public MdcService partnerUrl(String value) {
        this.setMdc(MDCKeys.partnerUrl, (Serializable)((Object)value));
        return this;
    }

    public String partnerUrl() {
        return this.getMdc(MDCKeys.partnerUrl);
    }

    public MdcService partnerVerb(String value) {
        this.setMdc(MDCKeys.partnerVerb, (Serializable)((Object)value));
        return this;
    }

    public String partnerVerb() {
        return this.getMdc(MDCKeys.partnerVerb);
    }

    public MdcService price(double value) {
        this.setMdc(MDCKeys.price, (Serializable)Double.valueOf(value));
        return this;
    }

    public double price() {
        return this.getDouble(MDCKeys.price);
    }

    public MdcService principal(String value) {
        this.setMdc(MDCKeys.principal, (Serializable)((Object)value));
        return this;
    }

    public String principal() {
        return this.getMdc(MDCKeys.principal);
    }

    public MdcService productId(String value) {
        this.setMdc(MDCKeys.productId, (Serializable)((Object)value));
        return this;
    }

    public String productId() {
        return this.getMdc(MDCKeys.productId);
    }

    public MdcService processId(String value) {
        this.setMdc(MDCKeys.processId, (Serializable)((Object)value));
        return this;
    }

    public String processId() {
        return this.getMdc(MDCKeys.processId);
    }

    public MdcService processName(String value) {
        this.setMdc(MDCKeys.processName, (Serializable)((Object)value));
        return this;
    }

    public String processName() {
        return this.getMdc(MDCKeys.processName);
    }

    public MdcService processStatus(String value) {
        this.setMdc(MDCKeys.processStatus, (Serializable)((Object)value));
        return this;
    }

    public String processStatus() {
        return this.getMdc(MDCKeys.processStatus);
    }

    public MdcService quantity(double value) {
        this.setMdc(MDCKeys.quantity, (Serializable)Double.valueOf(value));
        return this;
    }

    public double quantity() {
        return this.getDouble(MDCKeys.quantity);
    }

    public MdcService remoteAddress(String value) {
        this.setMdc(MDCKeys.remoteAddress, (Serializable)((Object)value));
        return this;
    }

    public String remoteAddress() {
        return this.getMdc(MDCKeys.remoteAddress);
    }

    public MdcService requestHeaders(String value) {
        this.setMdc(MDCKeys.requestHeaders, (Serializable)((Object)value));
        return this;
    }

    public String requestHeaders() {
        return this.getMdc(MDCKeys.requestHeaders);
    }

    public MdcService requestId(String value) {
        this.setMdc(MDCKeys.request_id, (Serializable)((Object)value));
        return this;
    }

    public String requestId() {
        String value = this.getMdc(MDCKeys.request_id);
        if (value == null) {
            value = UUID.randomUUID().toString();
            this.requestId(value);
        }
        return value;
    }

    public MdcService reservationNumber(String value) {
        this.setMdc(MDCKeys.reservationNumber, (Serializable)((Object)value));
        return this;
    }

    public String reservationNumber() {
        return this.getMdc(MDCKeys.reservationNumber);
    }

    public MdcService responseHeaders(String value) {
        this.setMdc(MDCKeys.responseHeaders, (Serializable)((Object)value));
        return this;
    }

    public String responseHeaders() {
        return this.getMdc(MDCKeys.responseHeaders);
    }

    public MdcService service(String value) {
        this.setMdc(MDCKeys.service, (Serializable)((Object)value));
        return this;
    }

    public String service() {
        return this.getMdc(MDCKeys.service);
    }

    public MdcService sessionId(String value) {
        this.setMdc(MDCKeys.sessionId, (Serializable)((Object)value));
        return this;
    }

    public String sessionId() {
        return this.getMdc(MDCKeys.sessionId);
    }

    public MdcService size(double value) {
        this.setMdc(MDCKeys.size, (Serializable)Double.valueOf(value));
        return this;
    }

    public double size() {
        return this.getDouble(MDCKeys.size);
    }

    public MdcService traceId(String value) {
        this.setMdc(MDCKeys.traceId, (Serializable)((Object)value));
        return this;
    }

    public String traceId() {
        String value = this.getMdc(MDCKeys.traceId);
        if (value == null) {
            value = UUID.randomUUID().toString();
            this.traceId(value);
        }
        return value;
    }

    public MdcService until(LocalDateTime value) {
        this.setMdc(MDCKeys.until, (Serializable)value);
        return this;
    }

    public LocalDateTime until() {
        return this.getLocalDateTime(MDCKeys.until);
    }

    public MdcService untilTimestamp(long value) {
        this.setMdc(MDCKeys.untilTimestamp, (Serializable)Long.valueOf(value));
        return this;
    }

    public long untilTimestamp() {
        return this.getLong(MDCKeys.untilTimestamp);
    }

    public MdcService uri(String value) {
        this.setMdc(MDCKeys.uri, (Serializable)((Object)value));
        return this;
    }

    public String uri() {
        return this.getMdc(MDCKeys.uri);
    }

    public MdcService url(String value) {
        this.setMdc(MDCKeys.url, (Serializable)((Object)value));
        return this;
    }

    public String url() {
        return this.getMdc(MDCKeys.url);
    }

    public MdcService urlPattern(String value) {
        this.setMdc(MDCKeys.urlPattern, (Serializable)((Object)value));
        return this;
    }

    public String urlPattern() {
        return this.getMdc(MDCKeys.urlPattern);
    }

    public MdcService userAgent(String value) {
        this.setMdc(MDCKeys.userAgent, (Serializable)((Object)value));
        return this;
    }

    public String userAgent() {
        return this.getMdc(MDCKeys.userAgent);
    }

    public MdcService userId(String value) {
        this.setMdc(MDCKeys.userId, (Serializable)((Object)value));
        return this;
    }

    public String userId() {
        return this.getMdc(MDCKeys.userId);
    }

    public MdcService verb(String value) {
        this.setMdc(MDCKeys.verb, (Serializable)((Object)value));
        return this;
    }

    public MdcService status(int status) {
        this.setMdc(MDCKeys.status, (Serializable)Integer.valueOf(status));
        return this;
    }

    public int status() {
        int status = this.getInt(MDCKeys.status);
        return status < 200 ? 200 : status;
    }

    public String verb() {
        return this.getMdc(MDCKeys.verb);
    }

    public MdcService version(String value) {
        this.setMdc(MDCKeys.version, (Serializable)((Object)value));
        return this;
    }

    public String version() {
        return this.getMdc(MDCKeys.version);
    }

    public MdcService warning(String value) {
        this.setMdc(MDCKeys.warning, (Serializable)((Object)value));
        return this;
    }

    public String warning() {
        return this.getMdc(MDCKeys.warning);
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public List<LoggerMdcMappingSPI> getMdcMappers() {
        return this.mdcMappers;
    }

    public static enum MDCKeys {
        appClass,
        appClassShortName,
        appMethod,
        appService,
        appSubService,
        applicationVersion,
        asset,
        artifactId,
        authProtocol,
        callFrom,
        callType,
        conversation_id,
        correlation_id,
        commitId,
        commitDate,
        country,
        customerId,
        deviceClass,
        deviceIdentifier,
        deviceIp,
        deviceNetworkSpeedDown(Double.valueOf(0.0)),
        deviceNetworkSpeedLatency(Double.valueOf(0.0)),
        deviceNetworkSpeedUp(Double.valueOf(0.0)),
        deviceNetworkType,
        deviceType,
        domain((Serializable)((Object)"xxxx"), "appDomain"),
        duration(Long.valueOf(0L)),
        env,
        errorCategory,
        errorCode,
        errorExploitationError(Boolean.FALSE),
        errorField,
        errorMessage,
        errorMessageDetail,
        errorRetryable(Boolean.FALSE),
        errorRollback(Boolean.FALSE),
        errorStatus,
        errorType,
        errorUrl,
        exceptionName,
        errorDomain,
        errorSubDomain,
        flags,
        from(LocalDateTime.now()),
        fromTimestamp(Long.valueOf(0L)),
        functionalUid,
        globalStatus,
        groupId,
        healthStatus((Serializable)((Object)"up")),
        hostname,
        httpStatus(Integer.valueOf(0)),
        instanceName,
        instanceNumber,
        language,
        lifecycle,
        majorVersion,
        messageId,
        methodInCause,
        orderId,
        osVersion,
        parentSpanId,
        partner,
        partnerRequestCharset,
        partnerResponseCharset,
        partnerResponseDuration(Long.valueOf(0L)),
        partnerResponseMessage,
        partnerResponseStatus(Integer.valueOf(0)),
        partnerService,
        partnerSubService,
        partnerType,
        partnerUrl,
        partnerVerb,
        price(Double.valueOf(0.0)),
        principal,
        productId,
        processId,
        processName,
        processStatus,
        quantity(Double.valueOf(0.0)),
        remoteAddress,
        requestHeaders,
        request_id,
        reservationNumber,
        responseHeaders,
        service,
        sessionId,
        size(Double.valueOf(0.0)),
        traceId,
        until(LocalDateTime.now()),
        untilTimestamp(Long.valueOf(0L)),
        uri((Serializable)((Object)"xxxx"), "appUri"),
        url((Serializable)((Object)"xxxx"), "appUrl"),
        urlPattern,
        userAgent,
        userId,
        status,
        subDomain((Serializable)((Object)"xxxx"), "appSubDomain"),
        verb((Serializable)((Object)"xxxx"), "appVerb"),
        version,
        warning;

        public static final MDCKeys[] VALUES;
        private final Serializable defaultValue;
        private final Class<? extends Serializable> type;
        private final String currentName;

        private MDCKeys() {
            this.defaultValue = MdcService.DEFAULT_STRING_VALUE;
            this.type = String.class;
            this.currentName = this.name();
        }

        private MDCKeys(Serializable defaultValue) {
            this.defaultValue = defaultValue;
            this.type = defaultValue.getClass();
            this.currentName = this.name();
        }

        private MDCKeys(Serializable defaultValue, String name) {
            this.defaultValue = defaultValue;
            this.type = defaultValue.getClass();
            this.currentName = name;
        }

        public Serializable getDefaultValue() {
            return this.defaultValue;
        }

        public Class<? extends Serializable> getType() {
            return this.type;
        }

        public String getCurrentName() {
            return this.currentName;
        }

        static {
            VALUES = MDCKeys.values();
        }
    }
}

