/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.monitoring;

import io.inugami.api.monitoring.MonitoringLoaderSpi;
import io.inugami.api.monitoring.RequestInformation;
import io.inugami.api.monitoring.models.Monitoring;
import java.util.ArrayList;
import java.util.ServiceLoader;
import java.util.UUID;

public final class RequestContext {
    private static Monitoring config = RequestContext.loadConfig();
    private static final ThreadLocal<RequestInformation> INSTANCE = new ThreadLocal();

    public static synchronized void clean() {
        INSTANCE.remove();
    }

    public static synchronized Monitoring loadConfig() {
        if (config == null) {
            ArrayList services = new ArrayList();
            ServiceLoader<MonitoringLoaderSpi> servicesLoader = ServiceLoader.load(MonitoringLoaderSpi.class);
            servicesLoader.forEach(services::add);
            if (!services.isEmpty()) {
                config = ((MonitoringLoaderSpi)services.get(0)).load();
            }
        }
        return config;
    }

    public static synchronized RequestInformation getInstance() {
        RequestInformation result = INSTANCE.get();
        if (result == null) {
            result = RequestContext.initializeTechnicalRequest();
        }
        return result;
    }

    public static synchronized void setInstance(RequestInformation instance) {
        INSTANCE.set(instance);
    }

    public static RequestInformation initializeTechnicalRequest() {
        RequestInformation.RequestInformationBuilder builder = RequestInformation.builder();
        if (config != null) {
            builder.env(config.getEnv());
            builder.asset(config.getAsset());
            builder.hostname(config.getHostname());
            builder.instanceName(config.getInstanceName());
            builder.instanceNumber(config.getInstanceNumber());
            builder.applicationVersion(config.getApplicationVersion());
        }
        builder.deviceIdentifier("system");
        builder.correlationId(UUID.randomUUID().toString());
        String traceId = UUID.randomUUID().toString();
        builder.requestId(traceId);
        builder.traceId(traceId);
        builder.service(String.join((CharSequence)"_", "technical", Thread.currentThread().getName()));
        RequestInformation result = builder.build();
        RequestContext.setInstance(result);
        return result;
    }

    private RequestContext() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

