/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.monitoring.exceptions;

import io.inugami.api.exceptions.ErrorCode;
import java.io.Serializable;

public final class ErrorResult
implements Serializable {
    private static final long serialVersionUID = 6750655178043958203L;
    static final String DEFAULT_ERROR_TYPE = "technical";
    private final int httpCode;
    private final String errorCode;
    private final String errorType;
    private final String message;
    private final String stack;
    private final String cause;
    private final String fallBack;
    private final boolean exploitationError;
    private final transient ErrorCode currentErrorCode;
    private final transient Throwable exception;

    public static ErrorResultBuilder builder() {
        return new ErrorResultBuilder();
    }

    public ErrorResultBuilder toBuilder() {
        return new ErrorResultBuilder().httpCode(this.httpCode).errorCode(this.errorCode).errorType(this.errorType).message(this.message).stack(this.stack).cause(this.cause).fallBack(this.fallBack).exploitationError(this.exploitationError).currentErrorCode(this.currentErrorCode).exception(this.exception);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErrorResult)) {
            return false;
        }
        ErrorResult other = (ErrorResult)o;
        String this$errorCode = this.getErrorCode();
        String other$errorCode = other.getErrorCode();
        return !(this$errorCode == null ? other$errorCode != null : !this$errorCode.equals(other$errorCode));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $errorCode = this.getErrorCode();
        result = result * 59 + ($errorCode == null ? 43 : $errorCode.hashCode());
        return result;
    }

    public ErrorResult(int httpCode, String errorCode, String errorType, String message, String stack, String cause, String fallBack, boolean exploitationError, ErrorCode currentErrorCode, Throwable exception) {
        this.httpCode = httpCode;
        this.errorCode = errorCode;
        this.errorType = errorType;
        this.message = message;
        this.stack = stack;
        this.cause = cause;
        this.fallBack = fallBack;
        this.exploitationError = exploitationError;
        this.currentErrorCode = currentErrorCode;
        this.exception = exception;
    }

    public String toString() {
        return "ErrorResult(httpCode=" + this.getHttpCode() + ", errorCode=" + this.getErrorCode() + ", errorType=" + this.getErrorType() + ", message=" + this.getMessage() + ", stack=" + this.getStack() + ", cause=" + this.getCause() + ", fallBack=" + this.getFallBack() + ", exploitationError=" + this.isExploitationError() + ", currentErrorCode=" + this.getCurrentErrorCode() + ", exception=" + this.getException() + ")";
    }

    public int getHttpCode() {
        return this.httpCode;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorType() {
        return this.errorType;
    }

    public String getMessage() {
        return this.message;
    }

    public String getStack() {
        return this.stack;
    }

    public String getCause() {
        return this.cause;
    }

    public String getFallBack() {
        return this.fallBack;
    }

    public boolean isExploitationError() {
        return this.exploitationError;
    }

    public ErrorCode getCurrentErrorCode() {
        return this.currentErrorCode;
    }

    public Throwable getException() {
        return this.exception;
    }

    public static class ErrorResultBuilder {
        private int httpCode;
        private String errorCode;
        private String errorType;
        private String message;
        private String stack;
        private String cause;
        private String fallBack;
        private boolean exploitationError;
        private ErrorCode currentErrorCode;
        private Throwable exception;

        ErrorResultBuilder() {
        }

        public ErrorResultBuilder httpCode(int httpCode) {
            this.httpCode = httpCode;
            return this;
        }

        public ErrorResultBuilder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public ErrorResultBuilder errorType(String errorType) {
            this.errorType = errorType;
            return this;
        }

        public ErrorResultBuilder message(String message) {
            this.message = message;
            return this;
        }

        public ErrorResultBuilder stack(String stack) {
            this.stack = stack;
            return this;
        }

        public ErrorResultBuilder cause(String cause) {
            this.cause = cause;
            return this;
        }

        public ErrorResultBuilder fallBack(String fallBack) {
            this.fallBack = fallBack;
            return this;
        }

        public ErrorResultBuilder exploitationError(boolean exploitationError) {
            this.exploitationError = exploitationError;
            return this;
        }

        public ErrorResultBuilder currentErrorCode(ErrorCode currentErrorCode) {
            this.currentErrorCode = currentErrorCode;
            return this;
        }

        public ErrorResultBuilder exception(Throwable exception) {
            this.exception = exception;
            return this;
        }

        public ErrorResult build() {
            return new ErrorResult(this.httpCode, this.errorCode, this.errorType, this.message, this.stack, this.cause, this.fallBack, this.exploitationError, this.currentErrorCode, this.exception);
        }

        public String toString() {
            return "ErrorResult.ErrorResultBuilder(httpCode=" + this.httpCode + ", errorCode=" + this.errorCode + ", errorType=" + this.errorType + ", message=" + this.message + ", stack=" + this.stack + ", cause=" + this.cause + ", fallBack=" + this.fallBack + ", exploitationError=" + this.exploitationError + ", currentErrorCode=" + this.currentErrorCode + ", exception=" + this.exception + ")";
        }
    }
}

