/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.monitoring.logs;

import io.inugami.api.monitoring.logs.BasicLogEvent;
import io.inugami.api.monitoring.logs.LogListener;
import java.util.function.Consumer;
import java.util.regex.Pattern;

public class DefaultLogListener
implements LogListener {
    private final Class<?> logClass;
    private final Pattern regex;
    private final Consumer<BasicLogEvent> consumer;

    public DefaultLogListener(Class<?> logClass, Consumer<BasicLogEvent> consumer) {
        this.logClass = logClass;
        this.consumer = consumer;
        this.regex = null;
    }

    public DefaultLogListener(String pattern, Consumer<BasicLogEvent> consumer) {
        this.logClass = null;
        this.consumer = consumer;
        this.regex = Pattern.compile(pattern);
    }

    public boolean accept(String loggerName) {
        if (this.consumer == null) {
            return false;
        }
        return this.logClass == null ? this.matchPattern(loggerName) : this.matchClass(loggerName);
    }

    private boolean matchPattern(String loggerName) {
        return this.regex.matcher(loggerName).matches();
    }

    private boolean matchClass(String loggerName) {
        return this.logClass.getName().equals(loggerName);
    }

    public void append(BasicLogEvent event) {
        this.consumer.accept(event);
    }
}

